/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.datatype.AnyDatatype;
import it.unical.mat.dlv.metainfo.datatype.Datatype;
import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.List;

public class SimpleTerm
implements Term {
    private String content = "";
    private Datatype datatype = AnyDatatype.getInstance();
    int beginLine;
    int beginColumn;
    int endLine;
    int endColumn;

    public SimpleTerm() {
    }

    public SimpleTerm(String t) {
        this.content = t;
    }

    @Override
    public boolean isVariable() {
        if (this.equals(NO_TERM)) {
            return false;
        }
        return Character.isUpperCase(this.content.charAt(0));
    }

    @Override
    public boolean isGround() {
        return !this.isVariable();
    }

    public int getAsInt() {
        return Integer.parseInt(this.content);
    }

    @Override
    public boolean isNumericConstant() {
        try {
            this.getAsInt();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String toString() {
        return this.content;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public List<Term> getVariables() {
        ArrayList<Term> ris = new ArrayList<Term>();
        if (this.isVariable()) {
            ris.add(this);
        }
        return ris;
    }

    @Override
    public List<Term> attributes() {
        return new ArrayList<Term>(0);
    }

    @Override
    public boolean existsMatch(Term t) {
        if (t.toString() == "_" || this.toString() == "_") {
            return false;
        }
        if (t.isVariable() && this.isVariable()) {
            return this.toString().equals(t.toString());
        }
        return false;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    @Override
    public SimpleTerm clone() {
        SimpleTerm term = new SimpleTerm(this.content);
        try {
            term.datatype = this.datatype.clone();
        }
        catch (CloneNotSupportedException e) {
            term.datatype = AnyDatatype.getInstance();
        }
        return term;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTerm other = (SimpleTerm)obj;
        return !(this.content == null ? other.content != null : !this.content.equals(other.content));
    }
}

