/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program.error;

import it.unical.mat.dlv.program.ProgramExpression;

public class Error {
    String message;
    ProgramExpression expression;
    int beginLine;
    int endLine;
    int beginColumn;
    int endColumn;

    public Error(String message, ProgramExpression expression) {
        this.message = message;
        this.setExpression(expression);
    }

    public Error(String message, ProgramExpression expression, int beginLine, int endLine) {
        this(message, expression, beginLine, endLine, 0, 0);
    }

    public Error(String message, ProgramExpression expression, int beginLine, int endLine, int beginColumn, int endColumn) {
        this.message = message;
        this.setExpression(expression);
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginColumn = beginColumn;
        this.endColumn = endColumn;
    }

    public void setExpression(ProgramExpression expression) {
        if (expression != null) {
            this.expression = expression;
            this.beginLine = expression.getLine();
            this.endLine = expression.getEndLine();
            this.beginColumn = expression.getBeginColumn();
            this.endColumn = expression.getEndColumn();
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ProgramExpression getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.message;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Error other = (Error)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

