/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.testing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Filter {
    TypeFilter typeFilter;
    boolean onSelectedRules;
    List<String> predicates = new ArrayList<String>();

    public Filter() {
    }

    public Filter(TypeFilter typeFilter, boolean onSelectedRules) {
        this.typeFilter = typeFilter;
        this.onSelectedRules = onSelectedRules;
    }

    public TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
    }

    public boolean isOnSelectedRules() {
        return this.onSelectedRules;
    }

    public void setOnSelectedRules(boolean onSelectedRules) {
        this.onSelectedRules = onSelectedRules;
    }

    public List<String> getPredicates() {
        return this.predicates;
    }

    public void addPredicate(String predicate) {
        this.predicates.add(predicate);
    }

    public void setPredicates(List<String> predicates) {
        this.predicates = predicates;
    }

    public void setPredicates(String predicates) {
        String[] pred = predicates.split(",");
        int i = 0;
        while (i < pred.length) {
            this.addPredicate(pred[i].trim());
            ++i;
        }
    }

    public String getPredicatesString() {
        StringBuffer text = new StringBuffer();
        Iterator<String> iterator = this.predicates.iterator();
        while (iterator.hasNext()) {
            String predName = iterator.next();
            text.append(predName);
            if (!iterator.hasNext()) continue;
            text.append(", ");
        }
        return text.toString();
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        switch (this.typeFilter) {
            case NORMAL: {
                text.append("filter");
                break;
            }
            case POSITIVE: {
                text.append("pfilter");
                break;
            }
            case NEGATIVE: {
                text.append("nfilter");
            }
        }
        if (this.onSelectedRules) {
            text.append("[");
            text.append("SELECTED_RULES");
            text.append("]");
        } else {
            text.append("(\"");
            Iterator<String> iterator = this.predicates.iterator();
            while (iterator.hasNext()) {
                String predName = iterator.next();
                text.append(predName);
                if (!iterator.hasNext()) continue;
                text.append(", ");
            }
            text.append("\")");
        }
        text.append(";");
        return text.toString();
    }

    public static enum TypeFilter {
        NORMAL,
        POSITIVE,
        NEGATIVE;

    }
}

