/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.testing;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.testing.Assert;
import it.unical.mat.dlv.testing.Filter;
import it.unical.mat.dlv.testing.InputTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TestCase {
    private ExecuteOn executeOn = ExecuteOn.PROGRAM;
    private boolean includeComponentRulesInSlice = false;
    private String name;
    private List<InputTest> inputList = new ArrayList<InputTest>();
    private List<InputTest> excludeInputList = new ArrayList<InputTest>();
    private String newOptions = null;
    private Filter filter = null;
    private List<Assert> assertList = new ArrayList<Assert>();
    private List<String> selectedRules = new ArrayList<String>();
    private List<String> selectedRulesWithPredicatesInHead = new ArrayList<String>();
    private List<String> selectedRulesWithPredicatesInBody = new ArrayList<String>();
    private List<String> selectedRulesWithPredicatesInPositiveBody = new ArrayList<String>();
    private List<String> selectedRulesWithPredicatesInNegativeBody = new ArrayList<String>();
    private List<String> selectedRulesWithPredicatesInAggregate = new ArrayList<String>();
    private List<Atom> inputAtomsDLPFunction = new ArrayList<Atom>();
    private Set<Atom> splittingSet = new HashSet<Atom>();
    private boolean checkSplittingSet = false;
    private boolean checkDLPFunction = false;

    public TestCase() {
    }

    public TestCase(String testCaseName) {
        this.name = testCaseName;
    }

    public TestCase(String testCaseName, ExecuteOn executeOn) {
        this(testCaseName);
        this.executeOn = executeOn;
    }

    public ExecuteOn getExecuteOn() {
        return this.executeOn;
    }

    public void setExecuteOn(ExecuteOn executeOn) {
        this.executeOn = executeOn;
    }

    public List<InputTest> getInputList() {
        return this.inputList;
    }

    public void addInputTest(InputTest inputTest) {
        this.inputList.add(inputTest);
    }

    public void addAssert(Assert assertion) {
        if (assertion.isConstraintType()) {
            List<Assert> constrAsserts = this.getConstraintsAssert();
            assertion.assertConstraintNumber = constrAsserts.size() > 0 ? constrAsserts.get((int)(constrAsserts.size() - 1)).assertConstraintNumber + 1 : 1;
        }
        this.assertList.add(assertion);
    }

    public List<Assert> getConstraintsAssert() {
        ArrayList<Assert> constrAsserts = new ArrayList<Assert>();
        for (Assert asser : this.assertList) {
            if (!asser.isConstraintType()) continue;
            constrAsserts.add(asser);
        }
        return constrAsserts;
    }

    public boolean isCheckDLPFunction() {
        return this.checkDLPFunction;
    }

    public void setCheckDLPFunction(boolean checkDLPFunction) {
        this.checkDLPFunction = checkDLPFunction;
    }

    public boolean isCheckSplittingSet() {
        return this.checkSplittingSet;
    }

    public void setCheckSplittingSet(boolean checkSplittingSet) {
        this.checkSplittingSet = checkSplittingSet;
    }

    public void addExcludeInputTest(InputTest inputTest) {
        this.excludeInputList.add(inputTest);
    }

    public void setInputList(List<InputTest> inputList) {
        this.inputList = inputList;
    }

    public List<InputTest> getExcludeInputList() {
        return this.excludeInputList;
    }

    public void setExcludeInputList(List<InputTest> excludeInputList) {
        this.excludeInputList = excludeInputList;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public List<Assert> getAssertList() {
        return this.assertList;
    }

    public List<Atom> getInputAtomsDLPFunction() {
        return this.inputAtomsDLPFunction;
    }

    public void setInputAtomsDLPFunction(List<Atom> inputAtomsDLPFunction) {
        this.inputAtomsDLPFunction = inputAtomsDLPFunction;
    }

    public void addInputAtomDLPFunction(Atom atom) {
        this.inputAtomsDLPFunction.add(atom);
    }

    public void addInputAtomsDLPFunction(List<Atom> atoms) {
        this.inputAtomsDLPFunction.addAll(atoms);
    }

    public Set<Atom> getSplittingSet() {
        return this.splittingSet;
    }

    public void setSplittingSet(Set<Atom> splittingSet) {
        this.splittingSet = splittingSet;
    }

    public void addAtomInSplittingSet(Atom atom) {
        this.splittingSet.add(atom);
    }

    public void addAtomsInSplittingSet(List<Atom> atoms) {
        this.splittingSet.addAll(atoms);
    }

    public void setAssertList(List<Assert> assertList) {
        this.assertList = assertList;
        int counter = 1;
        for (Assert assert1 : assertList) {
            if (!assert1.isConstraintType()) continue;
            assert1.assertConstraintNumber = counter++;
        }
    }

    public void addSelectedRule(String selectedRule) {
        this.selectedRules.add(selectedRule);
    }

    public List<String> getSelectedRules() {
        return this.selectedRules;
    }

    public void setSelectedRules(List<String> selectedRules) {
        this.selectedRules = selectedRules;
    }

    public void addSelectedRulesWithPredicatesInAggregates(String selectedPredicate) {
        this.selectedRulesWithPredicatesInAggregate.add(selectedPredicate);
    }

    public List<String> getSelectedRulesWithPredicatesInAggregates() {
        return this.selectedRulesWithPredicatesInAggregate;
    }

    public void setSelectedRulesWithPredicatesInAggregate(List<String> selectedRulesWithPredicatesInAggregate) {
        this.selectedRulesWithPredicatesInAggregate = selectedRulesWithPredicatesInAggregate;
    }

    public void addSelectedRulesWithPredicatesInBody(String selectedPredicate) {
        this.selectedRulesWithPredicatesInBody.add(selectedPredicate);
    }

    public List<String> getSelectedRulesWithPredicatesInBody() {
        return this.selectedRulesWithPredicatesInBody;
    }

    public void setSelectedRulesWithPredicatesInBody(List<String> selectedRulesWithPredicatesInBody) {
        this.selectedRulesWithPredicatesInBody = selectedRulesWithPredicatesInBody;
    }

    public void addSelectedRulesWithPredicatesInHead(String selectedPredicate) {
        this.selectedRulesWithPredicatesInHead.add(selectedPredicate);
    }

    public List<String> getSelectedRulesWithPredicatesInHead() {
        return this.selectedRulesWithPredicatesInHead;
    }

    public void setSelectedRulesWithPredicatesInHead(List<String> selectedRulesWithPredicatesInHead) {
        this.selectedRulesWithPredicatesInHead = selectedRulesWithPredicatesInHead;
    }

    public void addSelectedRulesWithPredicatesInNegativeBody(String selectedPredicate) {
        this.selectedRulesWithPredicatesInNegativeBody.add(selectedPredicate);
    }

    public List<String> getSelectedRulesWithPredicatesInNegativeBody() {
        return this.selectedRulesWithPredicatesInNegativeBody;
    }

    public void setSelectedRulesWithPredicatesInNegativeBody(List<String> selectedRulesWithPredicatesInNegativeBody) {
        this.selectedRulesWithPredicatesInNegativeBody = selectedRulesWithPredicatesInNegativeBody;
    }

    public void addSelectedRulesWithPredicatesInPositiveBody(String selectedPredicate) {
        this.selectedRulesWithPredicatesInPositiveBody.add(selectedPredicate);
    }

    public List<String> getSelectedRulesWithPredicatesInPositiveBody() {
        return this.selectedRulesWithPredicatesInPositiveBody;
    }

    public void setSelectedRulesWithPredicatesInPositiveBody(List<String> selectedRulesWithPredicatesInPositiveBody) {
        this.selectedRulesWithPredicatesInPositiveBody = selectedRulesWithPredicatesInPositiveBody;
    }

    public boolean isSomeRuleSelected() {
        return this.getSelectedRules().size() > 0 || this.getSelectedRulesWithPredicatesInAggregates().size() > 0 || this.getSelectedRulesWithPredicatesInBody().size() > 0 || this.getSelectedRulesWithPredicatesInHead().size() > 0 || this.getSelectedRulesWithPredicatesInNegativeBody().size() > 0 || this.getSelectedRulesWithPredicatesInPositiveBody().size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String testCaseName) {
        this.name = testCaseName;
    }

    public String getNewOptions() {
        return this.newOptions;
    }

    public void setNewOptions(String newOptions) {
        this.newOptions = newOptions;
    }

    public boolean isIncludeComponentRulesInSlice() {
        return this.includeComponentRulesInSlice;
    }

    public void setIncludeComponentRulesInSlice(boolean includeComponentRulesInSlice) {
        this.includeComponentRulesInSlice = includeComponentRulesInSlice;
    }

    public void removeAssert(Assert assert1) {
        this.assertList.remove(assert1);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.name);
        text.append("(");
        switch (this.executeOn) {
            case SELECTED_RULES: {
                text.append("SELECTED_RULES");
                break;
            }
            case SPLIT_PROGRAM: {
                text.append("SPLIT_PROGRAM");
                break;
            }
            default: {
                text.append("PROGRAM");
            }
        }
        if (this.isIncludeComponentRulesInSlice()) {
            text.append(",SELECT_RULES_IN_SCC");
        }
        text.append(")");
        text.append("\n");
        text.append("{");
        text.append("\n");
        if (this.newOptions != null) {
            text.append("\t");
            text.append("newOptions(\"" + this.newOptions + "\");");
            text.append("\n");
            text.append("\n");
        }
        for (InputTest input : this.inputList) {
            text.append("\t");
            text.append(input.toString());
            text.append("\n");
            text.append("\n");
        }
        for (InputTest input : this.excludeInputList) {
            text.append("\t");
            if (input.toString().startsWith("inputFile")) {
                text.append("excludeInputFile" + input.toString().substring(9));
            } else if (input.toString().startsWith("input")) {
                text.append("excludeInput" + input.toString().substring(5));
            }
            text.append("\n");
            text.append("\n");
        }
        if (this.filter != null) {
            text.append("\t");
            text.append(this.filter.toString());
            text.append("\n");
            text.append("\n");
        }
        if (this.isCheckSplittingSet()) {
            text.append("\t");
            text.append("checkModularity");
            text.append("(");
            text.append("SPLITTING_SET");
            if (!this.getSplittingSet().isEmpty()) {
                for (Atom atom : this.getSplittingSet()) {
                    text.append(", ");
                    text.append("\"" + atom.toString() + "\"");
                }
            }
            text.append(");");
            text.append("\n");
            text.append("\n");
        }
        if (this.isCheckDLPFunction()) {
            text.append("\t");
            text.append("checkModularity");
            text.append("(");
            text.append("DLP_FUNCTION");
            if (!this.getInputAtomsDLPFunction().isEmpty()) {
                for (Atom atom : this.getInputAtomsDLPFunction()) {
                    text.append(", ");
                    text.append("\"" + atom.toString() + "\"");
                }
            }
            text.append(");");
            text.append("\n");
            text.append("\n");
        }
        if (this.selectedRules.size() > 0) {
            Iterator<String> iterator = this.selectedRules.iterator();
            while (iterator.hasNext()) {
                text.append("\t");
                text.append("selectRule");
                text.append("(");
                String ruleName = iterator.next();
                text.append("\"");
                text.append(ruleName);
                text.append("\"");
                text.append(")");
                text.append(";");
                text.append("\n");
            }
            text.append("\n");
        }
        for (Assert asser : this.assertList) {
            text.append("\t");
            text.append(asser.toString());
            text.append("\n");
            text.append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCase other = (TestCase)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public static enum ExecuteOn {
        SELECTED_RULES,
        SPLIT_PROGRAM,
        PROGRAM;

    }
}

