/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.testing.execution;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.DLPFunction;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.ProgramExpression;
import it.unical.mat.dlv.program.ProgramPredicate;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.dlv.testing.Assert;
import it.unical.mat.dlv.testing.Filter;
import it.unical.mat.dlv.testing.InputTest;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.TestInvocation;
import it.unical.mat.dlv.testing.TestSuite;
import it.unical.mat.dlv.testing.execution.DLVExceptionHandler;
import it.unical.mat.dlv.testing.execution.TestCaseExecutor;
import it.unical.mat.dlv.testing.parser.ParseException;
import it.unical.mat.wrapper.DLVError;
import it.unical.mat.wrapper.DLVInputProgram;
import it.unical.mat.wrapper.DLVInputProgramImpl;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVWrapper;
import it.unical.mat.wrapper.DlvFinishedHandler;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.ModelHandler;
import it.unical.mat.wrapper.ModelResult;
import it.unical.mat.wrapper.Predicate;
import it.unical.mat.wrapper.exception.BadInputAtomInDLPFunctionException;
import it.unical.mat.wrapper.exception.BadInputInTestException;
import it.unical.mat.wrapper.exception.BadSplittingSetException;
import it.unical.mat.wrapper.exception.ExecutableNotFoundInTestSuiteException;
import it.unical.mat.wrapper.exception.FileNotFoundInTestSuiteException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TestSuiteExecutor
extends Thread
implements ModelHandler,
DlvFinishedHandler,
Cloneable {
    List<DLVExceptionHandler> dlvExceptionHandlers = new LinkedList<DLVExceptionHandler>();
    HashMap<TestCaseExecutor, List<Exception>> testCasesExceptions = new HashMap();
    List<Exception> otherException = new LinkedList<Exception>();
    private DLVInvocation invocation;
    private DLVInputProgram inputProgram = new DLVInputProgramImpl();
    private TestState state = TestState.NOT_READY;
    private List<TestCaseExecutor> testCaseExecutors = new ArrayList<TestCaseExecutor>();
    TestSuite testSuite;
    List<Model> globalInput = new ArrayList<Model>();
    HashMap<Assert, String> failedGlobalAsserts = new HashMap();
    private TestCaseExecutor currentTestCaseExecution = null;
    private boolean executeOnlyGlobal = false;
    private String failureMotivation = "";
    private List<AssertState> globalAssertsChecking = new ArrayList<AssertState>();
    private List<Assert> pendingGlobalAsserts = new ArrayList<Assert>();
    private int numberGlobalModelsFound = 0;
    private long executionTime = 0L;
    private long start;

    public TestSuiteExecutor(TestSuite testSuite) {
        this.testSuite = testSuite;
        this.generateTestCasesExecutors();
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setProgramInput() throws FileNotFoundInTestSuiteException {
        for (InputTest testSuiteInput : this.testSuite.getInputList()) {
            Object content = testSuiteInput.getInputContent().getContent();
            if (content instanceof Program) {
                this.inputProgram.includeProgram((Program)content);
                continue;
            }
            if (!(content instanceof String)) continue;
            File programFile = new File((String)content);
            if (!programFile.exists()) {
                throw new FileNotFoundInTestSuiteException(this.testSuite, (String)content);
            }
            this.inputProgram.addFile((String)content);
        }
    }

    public void setInvocation() throws DLVInvocationException, ExecutableNotFoundInTestSuiteException {
        TestInvocation testInvocation = this.testSuite.getInvocation();
        if (testInvocation != null) {
            if (testInvocation.getExecutable() != null) {
                this.invocation = DLVWrapper.getInstance().createInvocation(testInvocation.getExecutable());
                this.invocation.subscribe(this);
                if (testInvocation.getOptions() != null) {
                    this.invocation.setOptions(testInvocation.getOptions());
                }
                this.invocation.setInputProgram(this.inputProgram);
                this.state = TestState.READY;
                this.invocation.subscribe(new DlvFinishedHandler(){

                    @Override
                    public void dlvFinished(DLVInvocation observed, List<DLVError> dlvErrors) {
                        if (!dlvErrors.isEmpty()) {
                            String message = "Cannot execute because of the following DLV Error : \n";
                            for (DLVError error : dlvErrors) {
                                message = String.valueOf(message) + error.getText() + "\n";
                            }
                            TestSuiteExecutor.this.addExceptionInTest(new Exception(message));
                        }
                    }
                });
                if (!new File(testInvocation.getExecutable()).exists()) {
                    throw new ExecutableNotFoundInTestSuiteException(this.testSuite, testInvocation.getExecutable());
                }
            }
        } else {
            throw new ExecutableNotFoundInTestSuiteException(this.testSuite, "No test invocation set.");
        }
    }

    public void setInvocation(DLVInvocation invocation) throws DLVInvocationException {
        this.invocation = invocation;
        invocation.subscribe(this);
        this.inputProgram = new DLVInputProgramImpl();
        invocation.setInputProgram(this.inputProgram);
        this.state = TestState.READY;
    }

    private void addExceptionInTest(Exception exception) {
        if (this.currentTestCaseExecution != null) {
            if (!this.testCasesExceptions.containsKey(this.currentTestCaseExecution)) {
                this.testCasesExceptions.put(this.currentTestCaseExecution, new ArrayList());
            }
            this.testCasesExceptions.get(this.currentTestCaseExecution).add(exception);
            this.fail(this.currentTestCaseExecution);
        } else {
            this.otherException.add(exception);
            this.fail();
        }
    }

    public List<TestCaseExecutor> getTestCaseExecutors() {
        return this.testCaseExecutors;
    }

    public void subscribeDLVExceptionHandler(DLVExceptionHandler expHandler) {
        this.dlvExceptionHandlers.add(expHandler);
    }

    public void unsubscribeDLVExceptionHandler(DLVExceptionHandler expHandler) {
        this.dlvExceptionHandlers.remove(expHandler);
    }

    private void executeTestSuite() throws DLVInvocationException, IOException, ParseException {
        if (this.invocation == null) {
            throw new DLVInvocationException("The invocation of the test suite is not set.");
        }
        if (this.state == TestState.READY) {
            this.state = TestState.RUNNING;
        }
        if (this.state == TestState.RUNNING) {
            this.globalAssertsChecking.clear();
            for (TestCaseExecutor testCaseExec : this.testCaseExecutors) {
                try {
                    this.currentTestCaseExecution = testCaseExec;
                    this.executeTestCase();
                    this.currentTestCaseExecution = null;
                }
                catch (Exception e) {
                    this.addExceptionInTest(e);
                    try {
                        this.reInitTestCaseExecution();
                    }
                    catch (FileNotFoundInTestSuiteException e1) {
                        this.addExceptionInTest(e1);
                    }
                }
            }
            if (!this.testSuite.getGlobalAssertList().isEmpty()) {
                this.executeTestSuiteOnlyGlobal();
            }
            if (this.state == TestState.RUNNING) {
                this.state = TestState.PASSED;
            }
        }
    }

    private void notifyExceptionHandler() {
        if (!this.testCasesExceptions.isEmpty() || !this.otherException.isEmpty()) {
            ArrayList<Exception> allExcepts = new ArrayList<Exception>();
            for (List<Exception> lstExcepts : this.testCasesExceptions.values()) {
                allExcepts.addAll(lstExcepts);
            }
            allExcepts.addAll(this.otherException);
            for (DLVExceptionHandler handler : this.dlvExceptionHandlers) {
                handler.handle(allExcepts);
            }
        }
    }

    public HashMap<TestCaseExecutor, List<Exception>> getTestCasesExceptions() {
        return this.testCasesExceptions;
    }

    public void executeTestSuiteOnlyGlobal() throws DLVInvocationException, IOException, ParseException {
        if (this.invocation == null) {
            throw new DLVInvocationException("The invocation of the test suite is not set.");
        }
        Program includedProgram = null;
        includedProgram = new Program();
        for (Assert assertion : this.getTestSuite().getGlobalAssertList()) {
            if (!assertion.isConstraintType()) continue;
            Program constraintsAssertsRules = new Program();
            if (assertion.getExpectedOutput().getContent().containsOnlyConstraints() && assertion.getExpectedOutput().getContent().getRules().size() == 1) {
                for (Rule constr : assertion.getExpectedOutput().getContent().getRules()) {
                    AssertState assertState = this.getAssertState(assertion);
                    List<Rule> constrsWithHead = TestSuiteExecutor.generateTestConstraint(constr, assertState.getAssert().getConstraintPredName());
                    constraintsAssertsRules.addAll(constrsWithHead);
                }
                this.inputProgram.includeProgram(constraintsAssertsRules);
                includedProgram.addAll(constraintsAssertsRules);
                continue;
            }
            throw new ParseException("The Assertion of Constraints mush contain one constraint (only)");
        }
        this.invocation.run();
        this.start = System.currentTimeMillis();
        this.invocation.waitUntilExecutionFinishes();
        this.inputProgram.removeProgram(includedProgram);
        this.executionOnlyGlobalFinished();
    }

    public void executionOnlyGlobalFinished() {
        if (this.numberGlobalModelsFound == 0) {
            if (this.state == TestState.READY) {
                this.state = TestState.RUNNING;
            }
            for (Assert asser : this.testSuite.getGlobalAssertList()) {
                this.processModelGlobalInAssert(null, asser);
            }
        }
        TestSuiteExecutor.managePendingAsserts(this.pendingGlobalAsserts, this.failedGlobalAsserts);
        if (this.pendingGlobalAsserts.size() > 0) {
            this.state = TestState.FAILED;
            this.pendingGlobalAsserts.clear();
        }
        this.numberGlobalModelsFound = 0;
        this.executeOnlyGlobal = false;
    }

    public void startTestCaseExecution(TestCaseExecutor testCaseExec) {
        this.currentTestCaseExecution = testCaseExec;
        this.executeOnlyGlobal = false;
        this.start();
    }

    public void startTestSuiteExecutionOnlyGlobal() {
        this.currentTestCaseExecution = null;
        this.executeOnlyGlobal = true;
        this.start();
    }

    public void startTestSuiteExecution() {
        this.currentTestCaseExecution = null;
        this.executeOnlyGlobal = false;
        this.start();
    }

    @Override
    public synchronized void start() {
        this.state = TestState.RUNNING;
        super.start();
    }

    @Override
    public void run() {
        super.run();
        try {
            if (this.currentTestCaseExecution != null) {
                this.executeTestCase();
            } else if (this.executeOnlyGlobal) {
                this.executeTestSuiteOnlyGlobal();
            } else {
                this.executeTestSuite();
            }
        }
        catch (Exception e) {
            this.addExceptionInTest(e);
        }
        this.notifyExceptionHandler();
    }

    public void executeTestCase(TestCaseExecutor testCaseExec) throws Exception {
        this.currentTestCaseExecution = testCaseExec;
        this.executeTestCase();
        this.currentTestCaseExecution = null;
    }

    /*
     * WARNING - void declaration
     */
    private void executeTestCase() throws Exception {
        if (this.invocation == null) {
            throw new DLVInvocationException("The invocation of the test suite is not set.");
        }
        HashMap<String, Object> includedFiles = new HashMap<String, Object>();
        TestCase testCase = this.currentTestCaseExecution.getTestCase();
        if (testCase.isSomeRuleSelected() || testCase.getExcludeInputList().size() > 0) {
            for (String fileProgram : this.inputProgram.getFiles()) {
                if (new File(fileProgram).exists()) {
                    try {
                        Director director = new Director(new FileInputStream(fileProgram));
                        SimpleProgramBuilder builder = new SimpleProgramBuilder();
                        director.configureBuilder(builder);
                        director.start();
                        Program parsedProg = (Program)builder.getProductHandler();
                        includedFiles.put(fileProgram, parsedProg);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new FileNotFoundInTestSuiteException(this.testSuite, fileProgram);
                    }
                }
                throw new FileNotFoundInTestSuiteException(this.testSuite, fileProgram);
            }
        }
        DLPFunction sliceFunction = null;
        boolean createSlice = true;
        if ((testCase.isSomeRuleSelected() || testCase.isCheckDLPFunction() || testCase.isCheckSplittingSet()) && !testCase.isSomeRuleSelected()) {
            boolean canAvoidCheck = true;
            if (testCase.isCheckDLPFunction() && !testCase.getInputAtomsDLPFunction().isEmpty()) {
                canAvoidCheck = false;
            }
            if (testCase.isCheckSplittingSet() && !testCase.getSplittingSet().isEmpty()) {
                canAvoidCheck = false;
            }
            if (canAvoidCheck) {
                createSlice = false;
            }
        }
        Program completeProgram = null;
        IndexedProgram indexedCompleteProgram = null;
        Program slice = null;
        if (createSlice) {
            completeProgram = new Program();
            completeProgram.addAll(this.inputProgram.getProgram());
            for (Program fileProgram : includedFiles.values()) {
                completeProgram.addAll(fileProgram);
            }
            if (testCase.isSomeRuleSelected()) {
                Filter filter;
                slice = new Program();
                for (Expression expr : completeProgram) {
                    if (!(expr instanceof ProgramExpression) || !testCase.getSelectedRules().contains(((ProgramExpression)expr).getName())) continue;
                    slice.add(expr);
                }
                for (String selPred : testCase.getSelectedRulesWithPredicatesInHead()) {
                    List<Rule> list;
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    if ((list = indexedCompleteProgram.getRulesWithPredicateInHead(selPred)) == null) continue;
                    for (Rule rule : list) {
                        if (slice.contains(rule)) continue;
                        slice.add(rule);
                    }
                }
                for (String selPred : testCase.getSelectedRulesWithPredicatesInBody()) {
                    List<Rule> list;
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    if ((list = indexedCompleteProgram.getRulesWithPredicateInBody(selPred)) == null) continue;
                    for (Rule rule : list) {
                        if (slice.contains(rule)) continue;
                        slice.add(rule);
                    }
                }
                for (String selPred : testCase.getSelectedRulesWithPredicatesInPositiveBody()) {
                    List<Rule> list;
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    if ((list = indexedCompleteProgram.getRulesWithPredicateInPositiveBody(selPred)) == null) continue;
                    for (Rule rule : list) {
                        if (slice.contains(rule)) continue;
                        slice.add(rule);
                    }
                }
                for (String selPred : testCase.getSelectedRulesWithPredicatesInNegativeBody()) {
                    List<Rule> list;
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    if ((list = indexedCompleteProgram.getRulesWithPredicateInNegativeBody(selPred)) == null) continue;
                    for (Rule rule : list) {
                        if (slice.contains(rule)) continue;
                        slice.add(rule);
                    }
                }
                for (String selPred : testCase.getSelectedRulesWithPredicatesInAggregates()) {
                    List<Rule> list;
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    if ((list = indexedCompleteProgram.getRulesWithPredicateInAggregates(selPred)) == null) continue;
                    for (Rule rule : list) {
                        if (slice.contains(rule)) continue;
                        slice.add(rule);
                    }
                }
                if (testCase.isIncludeComponentRulesInSlice()) {
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    slice = indexedCompleteProgram.getComponentsSubProgram(slice);
                }
                if ((filter = testCase.getFilter()) != null && filter.isOnSelectedRules()) {
                    List<ProgramPredicate> predicatesFiltering = slice.getPredicates();
                    filter.getPredicates().clear();
                    for (ProgramPredicate programPredicate : predicatesFiltering) {
                        filter.addPredicate(programPredicate.getName());
                    }
                }
                if (testCase.getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES) {
                    this.inputProgram.clean();
                    this.inputProgram.includeProgram(slice);
                    includedFiles.clear();
                } else if (testCase.getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM) {
                    this.inputProgram.clean();
                    if (indexedCompleteProgram == null) {
                        indexedCompleteProgram = new IndexedProgram(completeProgram);
                    }
                    try {
                        slice = indexedCompleteProgram.getSplitBottom(indexedCompleteProgram.getSplittingSet(slice.getPredicateSymbolsAsAtoms()));
                    }
                    catch (BadSplittingSetException e) {
                        e.printStackTrace();
                    }
                    this.inputProgram.includeProgram(slice);
                    includedFiles.clear();
                }
            } else {
                slice = completeProgram;
            }
        }
        if (slice != null) {
            if (testCase.isCheckDLPFunction()) {
                if (completeProgram.isGround()) {
                    if (testCase.isSomeRuleSelected()) {
                        Program restOfProgram = new Program();
                        for (Expression expr : completeProgram) {
                            restOfProgram.add(expr);
                        }
                        for (Expression expr : slice) {
                            restOfProgram.remove(expr);
                        }
                        sliceFunction = new DLPFunction(slice);
                        DLPFunction restOfProgramFunction = new DLPFunction(restOfProgram);
                        if (testCase.getInputAtomsDLPFunction().isEmpty()) {
                            DLPFunction.makeDLPFunctionsComposible(sliceFunction, restOfProgramFunction, true);
                        } else {
                            for (Atom atom : testCase.getInputAtomsDLPFunction()) {
                                try {
                                    sliceFunction.addInput(atom);
                                }
                                catch (BadInputAtomInDLPFunctionException e) {
                                    throw new BadInputAtomInDLPFunctionException("The atom " + atom.toString() + " cannot be set as input for the selected DLP-Function.");
                                }
                            }
                            DLPFunction.makeDLPFunctionsComposible(sliceFunction, restOfProgramFunction, true, true, false);
                        }
                    } else if (!testCase.getInputAtomsDLPFunction().isEmpty()) {
                        sliceFunction = new DLPFunction(slice);
                        for (Atom inputAtom : testCase.getInputAtomsDLPFunction()) {
                            try {
                                sliceFunction.addInput(inputAtom);
                            }
                            catch (BadInputAtomInDLPFunctionException badInputAtomInDLPFunctionException) {
                                throw new BadInputAtomInDLPFunctionException("The atom " + inputAtom.toString() + " cannot be set as input for the selected DLP function.");
                            }
                        }
                    }
                } else {
                    throw new Exception("The selected rules must be ground to be considered a DLP-Function.");
                }
            }
            if (testCase.isCheckSplittingSet() && (testCase.isSomeRuleSelected() || !testCase.isSomeRuleSelected() && !testCase.getSplittingSet().isEmpty())) {
                void var11_56;
                void var10_33;
                IndexedProgram indSlice = new IndexedProgram(slice);
                if (indexedCompleteProgram == null) {
                    indexedCompleteProgram = new IndexedProgram(completeProgram);
                }
                Set<Atom> atoms = null;
                atoms = !testCase.getSplittingSet().isEmpty() ? testCase.getSplittingSet() : indSlice.getPredicateSymbolsAsAtoms();
                if (testCase.getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM) {
                    Set<Atom> set = indSlice.getPredicateSymbolsAsAtoms();
                    IndexedProgram indexedProgram = indSlice;
                } else {
                    Set<Atom> set = indexedCompleteProgram.getSplittingSet(atoms);
                    Program program = indexedCompleteProgram.getSplitBottom(set);
                }
                if (var10_33.size() != atoms.size()) {
                    throw new BadSplittingSetException();
                }
                for (Atom atom : var10_33) {
                    if (atoms.contains(atom)) continue;
                    throw new BadSplittingSetException();
                }
                List<Rule> correctRules = var11_56.getRules();
                List<Rule> rules = slice.getRules();
                if (correctRules.size() != rules.size()) {
                    throw new BadSplittingSetException();
                }
                for (Rule rule : correctRules) {
                    if (rules.contains(rule)) continue;
                    throw new BadSplittingSetException();
                }
            }
        }
        for (InputTest testCaseInput : testCase.getInputList()) {
            Object TypeContent = testCaseInput.getInputContent().getContent();
            if (TypeContent instanceof Program) {
                Program program = (Program)TypeContent;
                this.inputProgram.includeProgram(program);
                continue;
            }
            if (!(TypeContent instanceof String)) continue;
            File file = new File((String)TypeContent);
            if (!file.exists()) {
                throw new FileNotFoundInTestSuiteException(this.testSuite, file.getAbsolutePath());
            }
            this.inputProgram.addFile((String)TypeContent);
            if (testCase.getExcludeInputList().size() <= 0 && !testCase.isCheckDLPFunction()) continue;
            try {
                Director director = new Director(new FileInputStream((String)TypeContent));
                SimpleProgramBuilder builder = new SimpleProgramBuilder();
                director.configureBuilder(builder);
                director.start();
                Program parsedProg = (Program)builder.getProductHandler();
                includedFiles.put((String)TypeContent, parsedProg);
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundInTestSuiteException(this.testSuite, file.getAbsolutePath());
            }
        }
        ArrayList<String> excludedFiles = new ArrayList<String>();
        for (InputTest testCaseExcludeInput : testCase.getExcludeInputList()) {
            Object TypeContent = testCaseExcludeInput.getInputContent().getContent();
            if (TypeContent instanceof Program) {
                for (String currentFile : includedFiles.keySet()) {
                    if (!((Program)includedFiles.get(currentFile)).containsAll((Program)TypeContent) || excludedFiles.contains(currentFile)) continue;
                    this.inputProgram.removeFile(currentFile);
                    this.inputProgram.includeProgram((Program)includedFiles.get(currentFile));
                    excludedFiles.add(currentFile);
                }
                this.inputProgram.removeProgram((Program)TypeContent);
                continue;
            }
            if (!(TypeContent instanceof String)) continue;
            String fileName = (String)TypeContent;
            if (!new File(fileName).exists()) {
                throw new FileNotFoundInTestSuiteException(this.testSuite, fileName);
            }
            this.inputProgram.removeFile((String)TypeContent);
        }
        if (testCase.isCheckDLPFunction()) {
            for (InputTest testCaseInput : testCase.getInputList()) {
                Object TypeContent = testCaseInput.getInputContent().getContent();
                if (TypeContent instanceof Program) {
                    Program programLocalInput = new Program();
                    for (Expression expr : (Program)TypeContent) {
                        if (!this.inputProgram.getProgram().contains(expr)) continue;
                        programLocalInput.add(expr);
                    }
                    for (Rule rule : programLocalInput.getRules()) {
                        boolean found = false;
                        for (Atom headAtom : rule.getHead()) {
                            if (sliceFunction.getAtoms().contains(headAtom)) {
                                if (!sliceFunction.getInputSignature().contains(headAtom)) continue;
                                found = true;
                                continue;
                            }
                            found = true;
                        }
                        if (found) continue;
                        throw new BadInputInTestException(this.getTestSuite(), "The input '" + rule.getHead().toString() + "' is not specified in the input signature of the selected rules.");
                    }
                    continue;
                }
                if (!(TypeContent instanceof String) || !this.inputProgram.getFiles().contains((String)TypeContent) && !excludedFiles.contains((String)TypeContent)) continue;
                Program fileProgram = (Program)includedFiles.get((String)TypeContent);
                for (Rule rule : fileProgram.getRules()) {
                    boolean canContinue = false;
                    if (excludedFiles.contains((String)TypeContent)) {
                        if (this.inputProgram.getProgram().contains(rule)) {
                            canContinue = true;
                        }
                    } else if (this.inputProgram.getFiles().contains((String)TypeContent)) {
                        canContinue = true;
                    }
                    if (!canContinue) continue;
                    boolean found = false;
                    for (Atom headAtom : rule.getHead()) {
                        NormalAtom tmpAtom = new NormalAtom(headAtom.getName());
                        if (sliceFunction.getAtoms().contains(tmpAtom)) {
                            if (!sliceFunction.getInputSignature().contains(tmpAtom)) continue;
                            found = true;
                            continue;
                        }
                        found = true;
                    }
                    if (found) continue;
                    throw new BadInputInTestException(this.getTestSuite(), "The input '" + rule.getHead().toString() + "' is not specified in the input signature of the selected rules.");
                }
            }
        }
        if (testCase.getNewOptions() != null) {
            this.invocation.setOptions(testCase.getNewOptions());
        }
        for (Assert assertion : testCase.getAssertList()) {
            if (!assertion.isConstraintType()) continue;
            Program program = new Program();
            if (assertion.getExpectedOutput().getContent().containsOnlyConstraints() && assertion.getExpectedOutput().getContent().getRules().size() == 1) {
                for (Rule constr : assertion.getExpectedOutput().getContent().getRules()) {
                    AssertState assertState = this.currentTestCaseExecution.getAssertState(assertion);
                    List<Rule> constrsWithHead = TestSuiteExecutor.generateTestConstraint(constr, assertState.getAssert().getConstraintPredName());
                    program.addAll(constrsWithHead);
                }
                this.inputProgram.includeProgram(program);
                continue;
            }
            throw new it.unical.mat.dlv.parser.ParseException("The Assertion of Constraints mush contain one constraint (only)");
        }
        this.invocation.run();
        this.start = System.currentTimeMillis();
        this.invocation.waitUntilExecutionFinishes();
        this.reInitTestCaseExecution();
    }

    public synchronized void reInitTestCaseExecution() throws FileNotFoundInTestSuiteException, DLVInvocationException {
        if (this.invocation == null) {
            throw new DLVInvocationException("The invocation of the test suite is not set.");
        }
        this.inputProgram.cleanProgram();
        this.setProgramInput();
        if (this.currentTestCaseExecution != null) {
            if (this.currentTestCaseExecution.getTestCase().getNewOptions() != null) {
                if (this.testSuite.getInvocation().getOptions() != null) {
                    this.invocation.setOptions(this.testSuite.getInvocation().getOptions());
                } else {
                    this.invocation.resetOptions();
                }
            }
            this.currentTestCaseExecution = null;
        }
    }

    public void resetTestSuite() {
        this.globalAssertsChecking.clear();
        this.pendingGlobalAsserts.clear();
        this.state = TestState.READY;
        this.executionTime = 0L;
        this.start = 0L;
        this.failedGlobalAsserts.clear();
        this.executeOnlyGlobal = false;
        this.numberGlobalModelsFound = 0;
        for (TestCaseExecutor test : this.testCaseExecutors) {
            test.resetTest();
        }
    }

    public int getNumberTestCases() {
        return this.testCaseExecutors.size();
    }

    public int getNumberFailedTestCases() {
        int counter = 0;
        for (TestCaseExecutor test : this.testCaseExecutors) {
            if (test.getTestCaseState() != TestState.FAILED) continue;
            ++counter;
        }
        return counter;
    }

    public int getNumberPassedTestCases() {
        int counter = 0;
        for (TestCaseExecutor test : this.testCaseExecutors) {
            if (test.getTestCaseState() != TestState.PASSED) continue;
            ++counter;
        }
        return counter;
    }

    public AssertState getAssertState(Assert assert1) {
        AssertState assertState2;
        for (AssertState assertState2 : this.globalAssertsChecking) {
            if (assertState2.getAssert() != assert1) continue;
            return assertState2;
        }
        assertState2 = new AssertState(assert1);
        this.globalAssertsChecking.add(assertState2);
        return assertState2;
    }

    @Override
    public void handleResult(DLVInvocation observed, ModelResult result) {
        if (result instanceof Model) {
            if (this.currentTestCaseExecution != null) {
                if (this.state == TestState.READY) {
                    this.state = TestState.RUNNING;
                }
                this.currentTestCaseExecution.processModel((Model)result);
            } else {
                this.processModelGlobal((Model)result);
            }
        }
    }

    public void processModelGlobal(Model result) {
        ++this.numberGlobalModelsFound;
        for (Assert asser : this.testSuite.getGlobalAssertList()) {
            this.processModelGlobalInAssert(result, asser);
        }
    }

    public void processModelGlobalInAssert(Model result, Assert asser) {
        AssertState assertState = this.getAssertState(asser);
        TestSuiteExecutor.assertion(assertState, this.failedGlobalAsserts, result, this.numberGlobalModelsFound, null);
        if (assertState.state == TestState.PASSED) {
            this.pendingGlobalAsserts.remove(asser);
            this.failedGlobalAsserts.remove(asser);
        } else if (assertState.state == TestState.FAILED) {
            this.state = TestState.FAILED;
            this.pendingGlobalAsserts.remove(asser);
        } else if ((asser.getName().equals("assertTrueInAtLeast") || asser.getName().equals("assertBravelyTrue") || asser.getName().equals("assertTrueIn") || asser.getName().equals("assertFalseInAtLeast") || asser.getName().equals("assertFalseIn") || asser.getName().equals("assertBravelyFalse") || asser.getName().equals("assertConstraintIn") || asser.getName().equals("assertConstraintInAtLeast") || asser.getName().equals("assertNumberModels") || asser.getName().equals("assertNoModels")) && !this.pendingGlobalAsserts.contains(asser)) {
            this.pendingGlobalAsserts.add(asser);
        }
    }

    @Override
    public synchronized void dlvFinished(DLVInvocation observed, List<DLVError> dlvErrors) {
        this.globalAssertsChecking.clear();
        if (this.currentTestCaseExecution != null) {
            this.currentTestCaseExecution.executionFinished();
            if (this.currentTestCaseExecution.getTestCaseState() == TestState.FAILED) {
                this.state = TestState.FAILED;
            }
        }
        this.executionTime = System.currentTimeMillis() - this.start;
        this.notify();
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public TestState getTestSuiteState() {
        return this.state;
    }

    public DLVInvocation getInvocation() {
        return this.invocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail() {
        for (TestCaseExecutor exec : this.testCaseExecutors) {
            if (exec.getTestCaseState() != TestState.READY && exec.getTestCaseState() != TestState.RUNNING) continue;
            exec.setTestCaseState(TestState.FAILED);
        }
        if (this.getTestSuiteState() == TestState.READY || this.getTestSuiteState() == TestState.RUNNING) {
            this.state = TestState.FAILED;
        }
        TestSuiteExecutor testSuiteExecutor = this;
        synchronized (testSuiteExecutor) {
            this.notify();
        }
    }

    public void fail(TestCaseExecutor testExecutor) {
        testExecutor.setTestCaseState(TestState.FAILED);
        this.state = TestState.FAILED;
    }

    public synchronized void waitUntilTestExecutionFinishes() throws DLVInvocationException {
        boolean wait = false;
        for (TestCaseExecutor exec : this.testCaseExecutors) {
            if (exec.getTestCaseState() != TestState.READY && exec.getTestCaseState() != TestState.RUNNING) continue;
            wait = true;
        }
        if (this.getTestSuiteState() == TestState.READY || this.getTestSuiteState() == TestState.RUNNING) {
            wait = true;
        }
        if (wait) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitUntilTestExecutionFinishes();
        }
    }

    public void generateTestCasesExecutors() {
        this.testCaseExecutors.clear();
        for (TestCase testCase : this.testSuite.getTestCases()) {
            TestCaseExecutor testCaseExecutor = new TestCaseExecutor(this, testCase);
            this.testCaseExecutors.add(testCaseExecutor);
        }
    }

    public String getFailedMotivation(boolean onlyGlobalAssert) {
        StringBuffer reasons = new StringBuffer();
        reasons.append(this.failureMotivation);
        if (!onlyGlobalAssert) {
            for (TestCaseExecutor testCaseExecutor : this.testCaseExecutors) {
                if (testCaseExecutor.getTestCaseState() != TestState.FAILED) continue;
                reasons.append(testCaseExecutor.getFailedMotivation());
            }
        }
        for (Assert failedAssert : this.failedGlobalAsserts.keySet()) {
            reasons.append("Failed Global Assert '" + failedAssert.toString() + "'");
            reasons.append(" : ");
            reasons.append(this.failedGlobalAsserts.get(failedAssert));
            reasons.append("\n");
        }
        return reasons.toString();
    }

    public static void assertion(AssertState assertState, Model currentModel, int modelNumber, Filter filter) {
        TestSuiteExecutor.assertion(assertState, null, currentModel, modelNumber, filter);
    }

    public static void assertion(AssertState assertState, HashMap<Assert, String> failedAssertsMotivations, Model currentModel, int modelNumber, Filter filter) {
        Assert assertion = assertState.getAssert();
        boolean canContinue = true;
        Program programOutput = null;
        if (!assertion.isWeakConstraintType()) {
            programOutput = assertion.getExpectedOutput().getContent();
            if (!assertion.isConstraintType() && programOutput != null && !programOutput.containsOnlyFacts(false)) {
                canContinue = false;
            }
        }
        if (assertState.state == TestState.FAILED) {
            canContinue = false;
        }
        if (canContinue) {
            if (assertion.getName().equals("assertTrue") || assertion.getName().equals("assertCautiouslyTrue")) {
                TestSuiteExecutor.assertTruth(true, assertState, currentModel, programOutput, filter);
                if (assertState.state == TestState.PASSED) {
                    failedAssertsMotivations.remove(assertion);
                } else if (assertState.state == TestState.FAILED) {
                    String failedReason = "The Answer Set {" + TestSuiteExecutor.getCleanedModel(currentModel).toString() + "} does not contain all literals: {" + programOutput.toString() + "}";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertTrueInAtLeast")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertTruthIn(true, assertState, currentModel, programOutput, numberModels, "AT_LEAST", filter);
                if (assertState.state == TestState.PASSED) {
                    failedAssertsMotivations.remove(assertion);
                }
            } else if (assertion.getName().equals("assertTrueIn")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertTruthIn(true, assertState, currentModel, programOutput, numberModels, "EXACTLY", filter);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets " + "containing literals {" + programOutput.toString() + "}";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertBravelyTrue")) {
                int numberModels = 1;
                TestSuiteExecutor.assertTruthIn(true, assertState, currentModel, programOutput, numberModels, "AT_LEAST", filter);
            } else if (assertion.getName().equals("assertTrueInAtMost")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertTruthIn(true, assertState, currentModel, programOutput, numberModels, "AT_MOST", filter);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets " + "containing literals {" + programOutput.toString() + "}";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertFalse") || assertion.getName().equals("assertCautiouslyFalse")) {
                TestSuiteExecutor.assertTruth(false, assertState, currentModel, programOutput, filter);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The Answer Set {" + TestSuiteExecutor.getCleanedModel(currentModel).toString() + "} contains all literals: {" + programOutput.toString() + "}";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertFalseInAtLeast")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertTruthIn(false, assertState, currentModel, programOutput, numberModels, "AT_LEAST", filter);
            } else if (assertion.getName().equals("assertFalseIn")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertTruthIn(false, assertState, currentModel, programOutput, numberModels, "EXACTLY", filter);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets " + "that do not contain literals {" + programOutput.toString() + "}";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertBravelyFalse")) {
                int numberModels = 1;
                TestSuiteExecutor.assertTruthIn(false, assertState, currentModel, programOutput, numberModels, "AT_LEAST", filter);
            } else if (assertion.getName().equals("assertFalseInAtMost")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertTruthIn(false, assertState, currentModel, programOutput, numberModels, "AT_MOST", filter);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets " + "that do not contain literals {" + programOutput.toString() + "}";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertConstraint")) {
                TestSuiteExecutor.assertConstraint(assertState, currentModel, programOutput);
                if (assertState.state == TestState.PASSED) {
                    failedAssertsMotivations.remove(assertion);
                } else if (assertState.state == TestState.FAILED) {
                    String failedReason = "The Answer Set {" + TestSuiteExecutor.getCleanedModel(currentModel).toString() + "} does not satisfy the constraint: " + programOutput.toString();
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertConstraintInAtLeast")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertConstraintIn(assertState, currentModel, programOutput, numberModels, "AT_LEAST");
                if (assertState.state == TestState.PASSED) {
                    failedAssertsMotivations.remove(assertion);
                }
            } else if (assertion.getName().equals("assertConstraintIn")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertConstraintIn(assertState, currentModel, programOutput, numberModels, "EXACTLY");
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets " + "that satisfy the constraint: " + programOutput.toString();
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertConstraintInAtMost")) {
                int numberModels = assertion.getNumberModels();
                TestSuiteExecutor.assertConstraintIn(assertState, currentModel, programOutput, numberModels, "AT_MOST");
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets " + "that satisfy the constraint: " + programOutput.toString();
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertBestModelCost")) {
                TestSuiteExecutor.assertBestModelCost(assertState, currentModel);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The Best Model {" + TestSuiteExecutor.getCleanedModel(currentModel).toString() + "} does not have " + assertion.getBestModelCost() + " as best model cost";
                    if (assertion.getBestModelLevel() >= 0) {
                        failedReason = String.valueOf(failedReason) + " considering the level " + assertion.getBestModelLevel();
                    }
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            } else if (assertion.getName().equals("assertNumberModels") || assertion.getName().equals("assertNoModels")) {
                int numberModels = 0;
                if (assertion.getName().equals("assertNumberModels")) {
                    numberModels = assertion.getNumberModels();
                }
                TestSuiteExecutor.assertNumberModels(assertState, modelNumber, numberModels);
                if (assertState.state == TestState.FAILED) {
                    String failedReason = "The execution has generated more than " + numberModels + " Answer Sets ";
                    failedReason = failedReason.replaceAll("\n", "");
                    if (failedAssertsMotivations != null) {
                        failedAssertsMotivations.put(assertion, failedReason);
                    }
                }
            }
        }
    }

    public static void assertTruth(boolean positive, AssertState assertState, Model currentModel, Program expectedProgram, Filter filter) {
        boolean modelOk = true;
        for (Rule expectedRule : expectedProgram.getFacts(false)) {
            NormalAtom expectedAtom = (NormalAtom)expectedRule.getHead().get(0);
            boolean found = false;
            currentModel.beforeFirst();
            while (currentModel.hasMorePredicates() && !found) {
                Predicate tmpPredicate = currentModel.nextPredicate();
                if (!expectedAtom.getName().equals(tmpPredicate.name())) continue;
                tmpPredicate.beforeFirst();
                while (tmpPredicate.hasMoreLiterals() && !found) {
                    Literal tmpLiteral = tmpPredicate.nextLiteral();
                    boolean canConsider = true;
                    if (filter != null && filter.getPredicates().size() > 0) {
                        if (filter.getPredicates().contains(tmpLiteral.getName())) {
                            if (filter.getTypeFilter() == Filter.TypeFilter.NORMAL) {
                                canConsider = true;
                            } else if (filter.getTypeFilter() == Filter.TypeFilter.POSITIVE) {
                                if (((NormalAtom)tmpLiteral.getAtom()).isTrueNegated()) {
                                    canConsider = false;
                                }
                            } else if (filter.getTypeFilter() == Filter.TypeFilter.NEGATIVE && !((NormalAtom)tmpLiteral.getAtom()).isTrueNegated()) {
                                canConsider = false;
                            }
                        } else {
                            canConsider = false;
                        }
                    }
                    if (!canConsider) continue;
                    if (expectedAtom.isGround()) {
                        if (!tmpLiteral.getAtom().equals(expectedAtom)) continue;
                        found = true;
                        continue;
                    }
                    if (tmpLiteral.arity() != expectedAtom.arity()) continue;
                    boolean isGood = true;
                    HashMap<Term, Term> matching = new HashMap<Term, Term>();
                    int counterLit = 0;
                    while (counterLit < expectedAtom.arity() && isGood) {
                        Term expectedTerm = expectedAtom.getAttributeAt(counterLit);
                        Term modelTerm = tmpLiteral.getAttributeAt(counterLit);
                        if (!expectedTerm.isComplex()) {
                            if (expectedTerm.isVariable()) {
                                Term variableValue = (Term)matching.get(expectedTerm);
                                if (variableValue == null) {
                                    matching.put(expectedTerm, modelTerm);
                                } else if (!variableValue.equals(modelTerm)) {
                                    isGood = false;
                                }
                            } else if (!expectedTerm.equals(modelTerm)) {
                                isGood = false;
                            }
                        }
                        ++counterLit;
                    }
                    if (!isGood) continue;
                    found = true;
                }
            }
            if ((found || !positive) && (!found || positive)) continue;
            assertState.state = TestState.FAILED;
            modelOk = false;
        }
        if (modelOk) {
            ++assertState.matchedModels;
        }
    }

    public static void assertTruthIn(boolean positive, AssertState assertState, Model currentModel, Program expectedProgram, int numberOfModels, String operator, Filter filter) {
        boolean modelOK = true;
        for (Rule expectedRule : expectedProgram.getFacts(false)) {
            NormalAtom expectedAtom = (NormalAtom)expectedRule.getHead().get(0);
            boolean found = false;
            currentModel.beforeFirst();
            while (currentModel.hasMorePredicates() && !found) {
                Predicate tmpPredicate = currentModel.nextPredicate();
                if (!expectedAtom.getName().equals(tmpPredicate.name())) continue;
                tmpPredicate.beforeFirst();
                while (tmpPredicate.hasMoreLiterals() && !found) {
                    Literal tmpLiteral = tmpPredicate.nextLiteral();
                    boolean canConsider = true;
                    if (filter != null && filter.getPredicates().size() > 0) {
                        if (filter.getPredicates().contains(tmpLiteral.getName())) {
                            if (filter.getTypeFilter() == Filter.TypeFilter.NORMAL) {
                                canConsider = true;
                            } else if (filter.getTypeFilter() == Filter.TypeFilter.POSITIVE) {
                                if (((NormalAtom)tmpLiteral.getAtom()).isTrueNegated()) {
                                    canConsider = false;
                                }
                            } else if (filter.getTypeFilter() == Filter.TypeFilter.NEGATIVE && !((NormalAtom)tmpLiteral.getAtom()).isTrueNegated()) {
                                canConsider = false;
                            }
                        } else {
                            canConsider = false;
                        }
                    }
                    if (!canConsider) continue;
                    if (expectedAtom.isGround()) {
                        if (!tmpLiteral.getAtom().equals(expectedAtom)) continue;
                        found = true;
                        continue;
                    }
                    if (tmpLiteral.arity() != expectedAtom.arity()) continue;
                    boolean isGood = true;
                    HashMap<Term, Term> matching = new HashMap<Term, Term>();
                    int counterLit = 0;
                    while (counterLit < expectedAtom.arity() && isGood) {
                        Term expectedTerm = expectedAtom.getAttributeAt(counterLit);
                        Term modelTerm = tmpLiteral.getAttributeAt(counterLit);
                        if (!expectedTerm.isComplex()) {
                            if (expectedTerm.isVariable()) {
                                Term variableValue = (Term)matching.get(expectedTerm);
                                if (variableValue == null) {
                                    matching.put(expectedTerm, modelTerm);
                                } else if (!variableValue.equals(modelTerm)) {
                                    isGood = false;
                                }
                            } else if (!expectedTerm.equals(modelTerm)) {
                                isGood = false;
                            }
                        }
                        ++counterLit;
                    }
                    if (!isGood) continue;
                    found = true;
                }
            }
            if ((found || !positive) && (!found || positive)) continue;
            modelOK = false;
        }
        if (modelOK) {
            ++assertState.matchedModels;
            if ((operator.equals("AT_MOST") || operator.equals("EXACTLY")) && assertState.matchedModels > numberOfModels) {
                assertState.state = TestState.FAILED;
            }
            if (operator.equals("AT_LEAST") && assertState.matchedModels >= numberOfModels) {
                assertState.state = TestState.PASSED;
            }
            if (operator.equals("EXACTLY") && assertState.matchedModels == numberOfModels) {
                assertState.state = TestState.PASSED;
            }
        }
    }

    public static void assertConstraint(AssertState assertState, Model currentModel, Program constraintProgram) {
        boolean violated = false;
        currentModel.beforeFirst();
        while (currentModel.hasMorePredicates() && !violated) {
            Predicate tmpPredicate = currentModel.nextPredicate();
            String constrName = assertState.getAssert().getConstraintPredName();
            if (!tmpPredicate.name().startsWith(constrName)) continue;
            violated = true;
            assertState.state = TestState.FAILED;
        }
        if (!violated) {
            ++assertState.matchedModels;
        }
    }

    public static void assertConstraintIn(AssertState assertState, Model currentModel, Program expectedProgram, int numberOfModels, String operator) {
        boolean violated = false;
        currentModel.beforeFirst();
        while (currentModel.hasMorePredicates() && !violated) {
            Predicate tmpPredicate = currentModel.nextPredicate();
            String constrName = assertState.getAssert().getConstraintPredName();
            if (!tmpPredicate.name().startsWith(constrName)) continue;
            violated = true;
        }
        if (!violated) {
            ++assertState.matchedModels;
            if ((operator.equals("AT_MOST") || operator.equals("EXACTLY")) && assertState.matchedModels > numberOfModels) {
                assertState.state = TestState.FAILED;
            }
            if (operator.equals("AT_LEAST") && assertState.matchedModels >= numberOfModels) {
                assertState.state = TestState.PASSED;
            }
            if (operator.equals("EXACTLY") && assertState.matchedModels == numberOfModels) {
                assertState.state = TestState.PASSED;
            }
        }
    }

    public static void assertBestModelCost(AssertState assertState, Model currentModel) {
        if (currentModel.isBest()) {
            int expectedCost = assertState.getAssert().getBestModelCost();
            int fromLevel = assertState.getAssert().getBestModelLevel();
            List<Integer> levels = currentModel.getLevels();
            if (fromLevel >= 0) {
                int cost;
                assertState.state = levels.contains(fromLevel) ? ((cost = currentModel.getCost(fromLevel)) == expectedCost ? TestState.PASSED : TestState.FAILED) : TestState.FAILED;
            } else {
                boolean foundCost = false;
                Iterator<Integer> iterator = levels.iterator();
                while (iterator.hasNext() && !foundCost) {
                    Integer level = iterator.next();
                    int cost = currentModel.getCost(level);
                    if (cost != expectedCost) continue;
                    assertState.state = TestState.PASSED;
                    foundCost = true;
                }
                if (!foundCost) {
                    assertState.state = TestState.FAILED;
                }
            }
        }
    }

    public static void assertNumberModels(AssertState assertState, int modelNumber, int numberModels) {
        if (modelNumber == numberModels) {
            assertState.state = TestState.PASSED;
        } else if (modelNumber > numberModels) {
            assertState.state = TestState.FAILED;
        }
    }

    public void setTestSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public static List<Rule> generateTestConstraint(Rule constr, String constraintName) {
        ArrayList<Rule> constrRules = new ArrayList<Rule>();
        for (Literal constrLit : constr.body()) {
            Rule rule;
            boolean matchedPredicate = constrLit.getAtom() instanceof NormalAtom ? !((NormalAtom)constrLit.getAtom()).isBuiltin() : false;
            if (matchedPredicate) {
                NormalAtom atomHead = (NormalAtom)constrLit.getAtom().clone();
                if (constrLit.isPositive()) {
                    atomHead.setName(String.valueOf(constraintName) + constrLit.getAtom().getName());
                } else {
                    atomHead.setName(String.valueOf(constraintName) + "Not_" + constrLit.getAtom().getName());
                }
                rule = new Rule(new Disjunction(atomHead), constr.body());
            } else {
                rule = new Rule(new Disjunction(new NormalAtom(constraintName)), constr.body());
            }
            if (constrRules.contains(rule)) continue;
            constrRules.add(rule);
        }
        return constrRules;
    }

    public static void managePendingAsserts(List<Assert> pendingAsserts, HashMap<Assert, String> failedAssertsMotivation) {
        for (Assert pendingAssert : pendingAsserts) {
            if (!pendingAssert.getName().equals("assertTrueInAtLeast") && !pendingAssert.getName().equals("assertTrueIn") && !pendingAssert.getName().equals("assertBravelyTrue") && !pendingAssert.getName().equals("assertFalseInAtLeast") && !pendingAssert.getName().equals("assertFalseIn") && !pendingAssert.getName().equals("assertBravelyFalse") && !pendingAssert.getName().equals("assertConstraintIn") && !pendingAssert.getName().equals("assertConstraintInAtLeast") && !pendingAssert.getName().equals("assertNumberModels") && !pendingAssert.getName().equals("assertNoModels")) continue;
            Program programOutput = pendingAssert.getExpectedOutput().getContent();
            String failedReason = "The execution has generated less than " + pendingAssert.getNumberModels() + " Answer Sets ";
            if (pendingAssert.isConstraintType()) {
                failedReason = String.valueOf(failedReason) + "that satisfy the constraint: " + programOutput.toString();
            } else if (pendingAssert.getName().contains("True")) {
                failedReason = String.valueOf(failedReason) + "containing literals {" + programOutput.toString() + "}";
            } else if (pendingAssert.getName().contains("False")) {
                failedReason = String.valueOf(failedReason) + "that do not contain literals {" + programOutput.toString() + "}";
            }
            if (pendingAssert.getName().equals("assertBravelyTrue")) {
                failedReason = "The literals {" + programOutput.toString() + "} are not bravely true.";
            } else if (pendingAssert.getName().equals("assertBravelyFalse")) {
                failedReason = "The literals {" + programOutput.toString() + "} are not bravely false.";
            }
            failedReason = failedReason.replaceAll("\n", "");
            if (failedAssertsMotivation == null) continue;
            failedAssertsMotivation.put(pendingAssert, failedReason);
        }
    }

    public HashMap<Assert, String> getFailedGlobalAsserts() {
        return this.failedGlobalAsserts;
    }

    public TestCaseExecutor getTestCaseExecutor(TestCase testCase) {
        for (TestCaseExecutor testCaseExec : this.testCaseExecutors) {
            if (!testCaseExec.getTestCase().equals(testCase)) continue;
            return testCaseExec;
        }
        return null;
    }

    public void killDlv() throws DLVInvocationException {
        if (this.invocation == null) {
            throw new DLVInvocationException("The invocation of the test suite is not set.");
        }
        this.invocation.killDlv();
    }

    @Override
    public String toString() {
        if (this.getTestSuiteState() == TestState.FAILED) {
            return this.getFailedMotivation(false);
        }
        return this.getTestSuite().toString();
    }

    public static Model getCleanedModel(Model model) {
        Model newModel = new Model();
        newModel.setBest(model.isBest());
        for (int level : model.getLevels()) {
            newModel.setCost(level, model.getCost(level));
        }
        model.beforeFirst();
        while (model.hasMorePredicates()) {
            Predicate pred = model.nextPredicate();
            if (pred.name().startsWith("System_Constraint_")) continue;
            newModel.addPredicate(pred);
        }
        newModel.beforeFirst();
        return newModel;
    }

    public static class AssertState {
        Assert assert1;
        public TestState state = TestState.RUNNING;
        public int matchedModels = 0;
        public List<String> checkedConstraintsNames = new ArrayList<String>();

        public AssertState(Assert assert1) {
            this.assert1 = assert1;
        }

        public Assert getAssert() {
            return this.assert1;
        }
    }

    public static enum TestState {
        READY,
        FAILED,
        PASSED,
        RUNNING,
        NOT_READY;

    }
}

