/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.typ;

import it.unical.mat.dlv.program.Comment;
import it.unical.mat.dlv.typ.TypDefinitionInterface;
import it.unical.mat.dlv.typ.parser.TypParser;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class CreateDefinition
implements TypDefinitionInterface {
    String tableName;
    List<String> tableNameAttributes = new ArrayList<String>();
    String predicateName;
    List<String[]> predicateTypes = new ArrayList<String[]>();
    boolean keepAfterExecution = false;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getTableNameAttributes() {
        return this.tableNameAttributes;
    }

    public void setTableNameAttributes(List<String> tableNameAttributes) {
        this.tableNameAttributes = tableNameAttributes;
    }

    public void addTableNameAttribute(String attributeName) {
        this.tableNameAttributes.add(attributeName);
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public void setPredicateName(String predicateName) {
        this.predicateName = predicateName;
    }

    public List<String[]> getPredicateTypes() {
        return this.predicateTypes;
    }

    public void addPredicateType(String[] predicateType) {
        this.predicateTypes.add(predicateType);
    }

    public void setPredicateTypes(List<String[]> predicateTypes) {
        this.predicateTypes = predicateTypes;
    }

    public boolean isKeepAfterExecution() {
        return this.keepAfterExecution;
    }

    public void setKeepAfterExecution(boolean keepAfterExecution) {
        this.keepAfterExecution = keepAfterExecution;
    }

    public void clearTableNameAttributes() {
        this.tableNameAttributes.clear();
    }

    public void clearPredicateTypes() {
        this.predicateTypes.clear();
    }

    public String getPredicateType(int index) {
        String[] type = this.predicateTypes.get(index);
        StringBuffer buffer = new StringBuffer();
        buffer.append(type[0]);
        if (type.length > 1) {
            buffer.append("(");
            int j = 1;
            while (j < type.length) {
                if (j > 1) {
                    buffer.append(",");
                }
                buffer.append(type[j]);
                ++j;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE " + this.tableName);
        if (this.tableNameAttributes.size() > 0) {
            buffer.append("(" + this.tableNameAttributes.get(0));
            i = 1;
            while (i < this.tableNameAttributes.size()) {
                buffer.append("," + this.tableNameAttributes.get(i));
                ++i;
            }
            buffer.append(")");
        }
        buffer.append("\nMAPTO " + this.predicateName);
        if (this.predicateTypes.size() > 0) {
            buffer.append("(");
            i = 0;
            while (i < this.predicateTypes.size()) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.getPredicateType(i));
                ++i;
            }
            buffer.append(")");
        }
        if (this.keepAfterExecution) {
            buffer.append("\nKEEP_AFTER_EXECUTION");
        }
        buffer.append(".");
        return buffer.toString();
    }

    public Comment getCreateDefinitionAsAnnotation() {
        StringBuffer annotContent = new StringBuffer();
        annotContent.append(TypParser.CREATE_TABLE_ANNOT);
        annotContent.append(" ");
        annotContent.append(this.getTableName());
        annotContent.append(" MAPTO ");
        annotContent.append(this.getPredicateName());
        if (!this.getTableNameAttributes().isEmpty()) {
            annotContent.append("(");
            ListIterator<String[]> itTypes = this.getPredicateTypes().listIterator();
            boolean first = true;
            for (String attrName : this.getTableNameAttributes()) {
                if (first) {
                    first = false;
                } else {
                    annotContent.append(",");
                }
                String[] type = itTypes.next();
                annotContent.append(attrName);
                annotContent.append(":");
                annotContent.append(type[0]);
                if (type.length <= 1) continue;
                annotContent.append("(");
                annotContent.append(type[1]);
                if (type.length > 2) {
                    annotContent.append(",");
                    annotContent.append(type[2]);
                }
                annotContent.append(")");
            }
            annotContent.append(")");
        }
        if (this.isKeepAfterExecution()) {
            annotContent.append(" KEEP_AFTER_EXECUTION ");
        }
        return new Comment("%" + annotContent.toString());
    }
}

