/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.dlv.typ.TypDirectives;
import it.unical.mat.wrapper.DLVError;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVInvocationImpl;
import it.unical.mat.wrapper.DlvFinishedHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class DLVDBInvocationImpl
extends DLVInvocationImpl {
    private String temporaryTypPath = String.valueOf(System.getProperty("user.home")) + "/aspide/temp/" + this.hashCode() + ".typ";
    private boolean debugMode = false;

    public DLVDBInvocationImpl() {
        DlvFinishedHandler finishedHandler = new DlvFinishedHandler(){

            @Override
            public void dlvFinished(DLVInvocation observed, List<DLVError> dlvErrors) {
                if (!DLVDBInvocationImpl.this.isDebugMode()) {
                    File file = new File(DLVDBInvocationImpl.this.temporaryTypPath);
                    file.delete();
                }
            }
        };
        try {
            this.subscribe(finishedHandler);
        }
        catch (DLVInvocationException dLVInvocationException) {
            // empty catch block
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getTemporaryTypPath() {
        return this.temporaryTypPath;
    }

    public void setTemporaryTypPath(String temporaryTypPath) {
        this.temporaryTypPath = temporaryTypPath;
    }

    @Override
    public synchronized void run() throws DLVInvocationException, IOException {
        TypDirectives typDirectives = this.getInputProgram().getProgram().getTypDirectives();
        if (typDirectives != null && !typDirectives.isEmpty()) {
            File file = new File(this.temporaryTypPath);
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(this.temporaryTypPath);
            PrintStream ps = new PrintStream(fos);
            ps.print(typDirectives.toString());
            ps.flush();
            ps.close();
            this.getInputProgram().addFile(this.temporaryTypPath);
        }
        super.run();
    }
}

