/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.ListTerm;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.MultiSetTerm;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Query;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.wrapper.DLVError;
import it.unical.mat.wrapper.DLVInputProgram;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVInvocationHandler;
import it.unical.mat.wrapper.DLVResult;
import it.unical.mat.wrapper.DLVWrapper;
import it.unical.mat.wrapper.DlvFinishedHandler;
import it.unical.mat.wrapper.FactHandler;
import it.unical.mat.wrapper.FactResult;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.ModelBufferedHandler;
import it.unical.mat.wrapper.ModelHandler;
import it.unical.mat.wrapper.ModelResult;
import it.unical.mat.wrapper.Predicate;
import it.unical.mat.wrapper.PredicateHandler;
import it.unical.mat.wrapper.PredicateHandlerWithName;
import it.unical.mat.wrapper.PredicateResult;
import it.unical.mat.wrapper.QueryResultHandler;
import it.unical.mat.wrapper.QueryTupleHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DLVInvocationImpl
implements DLVInvocation {
    Director d;
    private List<String> options = new ArrayList<String>();
    private List<DLVError> errors = new ArrayList<DLVError>();
    private DLVInputProgram inputProgram;
    private Query query;
    private ParseException parseExceptionOnOutput = null;
    private Charset charset = Charset.forName("UTF-8");
    private List<ModelBufferedHandler> modelBufferedObserver = new ArrayList<ModelBufferedHandler>();
    private List<ModelHandler> modelObservers = new ArrayList<ModelHandler>();
    private List<PredicateHandler> predicateObservers = new ArrayList<PredicateHandler>();
    private List<FactHandler> factObservers = new ArrayList<FactHandler>();
    private List<QueryTupleHandler> queryTupleObservers = new ArrayList<QueryTupleHandler>();
    private List<QueryResultHandler> queryObservers = new ArrayList<QueryResultHandler>();
    private List<DlvFinishedHandler> dlvFinishedObservers = new ArrayList<DlvFinishedHandler>();
    private HashMap<String, List<PredicateHandlerWithName>> predicateObserverWithName = new HashMap();
    protected BufferedReader inputReader;
    protected BufferedReader errorReader;
    protected PrintWriter outputWriter;
    private Process dlv;
    private Model currentModel;
    private int modelCount;
    HashMap<String, Predicate> predicateMap = new HashMap();
    ArrayList<Term> currentQueryTuple = new ArrayList();
    Predicate queryResult;
    private ArrayList<ArrayList<Term>> stack = new ArrayList();
    private ArrayList<Atom> atoms = new ArrayList();
    private ArrayList<Literal> literals = new ArrayList();
    private boolean inAggregate = false;
    private boolean allPredicate = false;
    private boolean foundQueryTuple = false;
    private boolean trace = false;
    private DLVInvocation.DLVInvocationState state = DLVInvocation.DLVInvocationState.READY;
    private OutputManager outputManager;
    public boolean errorRead = false;

    @Override
    public void addOption(String s) throws DLVInvocationException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        if (!(s = s.trim()).equals("")) {
            boolean finished = false;
            int startOption = 0;
            int endOption = 0;
            while (!finished) {
                String option;
                endOption = s.indexOf(" -", startOption + 1);
                if (endOption > 0) {
                    option = s.substring(startOption, endOption).trim();
                    option = option.replace(" ", "");
                    startOption = endOption;
                    this.addReplaceOption(option);
                    continue;
                }
                endOption = s.length();
                option = s.substring(startOption, endOption).trim();
                option = option.replace(" ", "");
                this.addReplaceOption(option);
                finished = true;
            }
        }
    }

    @Override
    public void removeOptions(String s) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        if (!(s = s.trim()).equals("")) {
            boolean finished = false;
            int startOption = 0;
            int endOption = 0;
            while (!finished) {
                String option;
                endOption = s.indexOf(" -", startOption + 1);
                if (endOption > 0) {
                    option = s.substring(startOption, endOption).trim();
                    option = option.replace(" ", "");
                    startOption = endOption;
                    this.removeOption(option);
                    continue;
                }
                endOption = s.length();
                option = s.substring(startOption, endOption).trim();
                option = option.replace(" ", "");
                this.removeOption(option);
                finished = true;
            }
        }
    }

    private void removeOption(String option) throws DLVInvocationException {
        String optionName = option;
        if (option.contains("=")) {
            optionName = option.substring(0, option.indexOf("="));
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator<String> iterator = this.options.iterator();
        while (iterator.hasNext()) {
            String storedOption;
            String storedOptionName = storedOption = iterator.next();
            if (storedOption.contains("=")) {
                storedOptionName = storedOption.substring(0, storedOption.indexOf("="));
            }
            if (!storedOptionName.equals(optionName)) continue;
            toRemove.add(storedOption);
        }
        this.options.removeAll(toRemove);
    }

    private void addReplaceOption(String option) {
        String optionName = option;
        if (option.contains("=")) {
            optionName = option.substring(0, option.indexOf("="));
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator<String> iterator = this.options.iterator();
        while (iterator.hasNext()) {
            String storedOption;
            String storedOptionName = storedOption = iterator.next();
            if (storedOption.contains("=")) {
                storedOptionName = storedOption.substring(0, storedOption.indexOf("="));
            }
            if (!storedOptionName.equals(optionName)) continue;
            toRemove.add(storedOption);
        }
        this.options.removeAll(toRemove);
        this.options.add(option);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized List<DLVError> getErrors() throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) ** GOTO lbl8
        throw new DLVInvocationException("Solver never run.");
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
lbl8:
            // 3 sources

            ** while (this.state == DLVInvocation.DLVInvocationState.RUNNING || !this.errorRead)
        }
lbl9:
        // 1 sources

        return this.errors;
    }

    @Override
    public DLVInvocation.DLVInvocationState getState() {
        return this.state;
    }

    @Override
    public DLVInputProgram getInputProgram() {
        return this.inputProgram;
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }

    @Override
    public String getOptionsString() {
        StringBuilder optionsBuilder = new StringBuilder();
        if (!this.getOptions().isEmpty()) {
            optionsBuilder.append(this.getOptions().get(0));
            int i = 1;
            while (i < this.getOptions().size()) {
                optionsBuilder.append(", " + this.getOptions().get(i));
                ++i;
            }
        }
        return optionsBuilder.toString();
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public synchronized void killDlv() throws DLVInvocationException {
        if (this.outputManager == null || this.state != DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is not Running");
        }
        this.state = DLVInvocation.DLVInvocationState.KILLED;
        this.dlv.destroy();
        this.errorRead = true;
        this.notifyAll();
        this.notifyBufferedExecutionFinishes();
        this.notifyDlvFinishedHandler();
        this.outputManager.kill();
    }

    @Override
    public synchronized void reset() throws DLVInvocationException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is RUNNING, cannot reset invocation.");
        }
        this.options.clear();
        this.errors.clear();
        this.inputProgram = null;
        this.errorRead = false;
        this.query = null;
        this.state = DLVInvocation.DLVInvocationState.READY;
    }

    @Override
    public synchronized void resetState() {
        try {
            this.killDlv();
        }
        catch (DLVInvocationException dLVInvocationException) {
            // empty catch block
        }
        this.state = DLVInvocation.DLVInvocationState.READY;
    }

    @Override
    public void resetFilter() throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.removeOption("-filter=");
        this.removeOption("-pfilter=");
    }

    @Override
    public void resetMaxint() throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.removeOption("-N=");
    }

    @Override
    public void resetNumberOfModels() throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.removeOption("-n=x");
    }

    @Override
    public void resetOptions() throws DLVInvocationException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.options.clear();
    }

    @Override
    public void resumeExecution() throws DLVInvocationException {
        throw new UnsupportedOperationException("resumeExecution feature not implemented");
    }

    @Override
    public synchronized void run() throws DLVInvocationException, IOException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is RUNNING, stop current invocation before call this function");
        }
        this.errorRead = false;
        this.state = DLVInvocation.DLVInvocationState.READY;
        this.errors.clear();
        this.runDLV();
        this.modelCount = -1;
        this.outputManager = new OutputManager();
        this.outputManager.start();
    }

    private boolean containsQueryOptions() {
        return this.options.contains("-cautious") || this.options.contains("-brave");
    }

    private void runDLV() throws IOException, DLVInvocationException {
        if (this.inputProgram == null) {
            throw new DLVInvocationException("DLV program cannot be null, initialize the input program");
        }
        if (this.inputProgram.getFiles().isEmpty() && this.inputProgram.getProgram().isEmpty() && this.inputProgram.getText().equals("")) {
            throw new DLVInvocationException("DLV inputs cannot be empty, initialize the inputs");
        }
        ArrayList<String> input = new ArrayList<String>();
        input.add(DLVWrapper.getInstance().getPath());
        try {
            this.addOption("-silent");
        }
        catch (DLVInvocationException e) {
            e.printStackTrace();
        }
        input.addAll(this.options);
        input.addAll(this.inputProgram.getFiles());
        if (!this.inputProgram.getCompleteText().equals("") || this.query != null) {
            input.add("--");
        }
        String[] inputVector = new String[input.size()];
        int i = 0;
        while (i < inputVector.length) {
            inputVector[i] = (String)input.get(i);
            ++i;
        }
        this.state = DLVInvocation.DLVInvocationState.RUNNING;
        this.dlv = Runtime.getRuntime().exec(inputVector);
        this.inputReader = new BufferedReader(new InputStreamReader(this.dlv.getInputStream(), this.charset));
        this.errorReader = new BufferedReader(new InputStreamReader(this.dlv.getErrorStream(), this.charset));
        this.outputWriter = new PrintWriter(new OutputStreamWriter(this.dlv.getOutputStream(), this.charset));
        this.outputWriter.append(this.inputProgram.getCompleteText());
        if (this.query != null) {
            this.outputWriter.append(this.query.toString());
        }
        this.outputWriter.print(' ');
        this.outputWriter.close();
        this.outputWriter = null;
    }

    @Override
    public void setFilter(List<String> filterList, boolean positive) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.resetFilter();
        StringBuffer filterOptions = new StringBuffer();
        if (positive) {
            filterOptions.append("-pfilter=");
        } else {
            filterOptions.append("-filter=");
        }
        if (filterList.size() >= 1) {
            filterOptions.append(filterList.get(0));
        }
        int i = 1;
        while (i < filterList.size()) {
            filterOptions.append("," + filterList.get(i));
            ++i;
        }
        this.options.add(filterOptions.toString());
    }

    @Override
    public void setInputProgram(DLVInputProgram p) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.inputProgram = p;
    }

    @Override
    public void setMaxint(int maxInt) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.resetMaxint();
        this.options.add("-N=" + maxInt);
    }

    @Override
    public void setNumberOfModels(int nModels) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.resetNumberOfModels();
        this.options.add("-n=" + nModels);
    }

    @Override
    public void setQuery(Query query) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        this.query = query;
    }

    @Override
    public void stopExecution() throws DLVInvocationException {
        throw new UnsupportedOperationException("stopExecution feature not implemented");
    }

    @Override
    public void subscribe(DLVInvocationHandler handler) throws DLVInvocationException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        if (handler instanceof ModelHandler) {
            this.modelObservers.add((ModelHandler)handler);
            this.allPredicate = true;
            if (handler instanceof ModelBufferedHandler) {
                this.modelBufferedObserver.add((ModelBufferedHandler)handler);
            }
        }
        if (handler instanceof PredicateHandler) {
            this.predicateObservers.add((PredicateHandler)handler);
            this.allPredicate = true;
        }
        if (handler instanceof FactHandler) {
            this.factObservers.add((FactHandler)handler);
        }
        if (handler instanceof QueryTupleHandler) {
            this.queryTupleObservers.add((QueryTupleHandler)handler);
        }
        if (handler instanceof QueryResultHandler) {
            this.queryObservers.add((QueryResultHandler)handler);
        }
        if (handler instanceof PredicateHandlerWithName) {
            for (String predicateName : ((PredicateHandlerWithName)handler).getPredicateNames()) {
                if (!this.predicateObserverWithName.containsKey(predicateName)) {
                    this.predicateObserverWithName.put(predicateName, new ArrayList());
                }
                this.predicateObserverWithName.get(predicateName).add((PredicateHandlerWithName)handler);
            }
        }
        if (handler instanceof DlvFinishedHandler) {
            this.dlvFinishedObservers.add((DlvFinishedHandler)handler);
        }
    }

    @Override
    public void subscribe(Collection<DLVInvocationHandler> handler) throws DLVInvocationException {
        if (this.state != DLVInvocation.DLVInvocationState.READY) {
            throw new DLVInvocationException("DLV is not READY, stop current invocation before call this function");
        }
        for (DLVInvocationHandler h : handler) {
            this.subscribe(h);
        }
    }

    @Override
    public void unSubscribe(DLVInvocationHandler handler) throws DLVInvocationException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is RUNNING, stop current invocation before call this function");
        }
        if (handler instanceof ModelHandler) {
            this.modelObservers.remove(handler);
            if (this.modelObservers.size() == 0 && this.predicateObservers.size() == 0) {
                this.allPredicate = false;
            }
        } else if (handler instanceof PredicateHandler) {
            this.predicateObservers.remove(handler);
            if (this.modelObservers.size() == 0 && this.predicateObservers.size() == 0) {
                this.allPredicate = false;
            }
        } else if (handler instanceof FactHandler) {
            this.factObservers.remove(handler);
        } else if (handler instanceof QueryTupleHandler) {
            this.queryTupleObservers.remove(handler);
        } else if (handler instanceof QueryResultHandler) {
            this.queryObservers.remove(handler);
        } else if (handler instanceof PredicateHandlerWithName) {
            for (String predicateName : ((PredicateHandlerWithName)handler).getPredicateNames()) {
                if (this.predicateObserverWithName.containsKey(predicateName)) {
                    this.predicateObserverWithName.get(predicateName).remove(handler);
                }
                if (this.predicateObserverWithName.get(predicateName).size() != 0) continue;
                this.predicateObserverWithName.remove(predicateName);
            }
        }
    }

    @Override
    public void unSubscribe(Collection<DLVInvocationHandler> handlers) throws DLVInvocationException {
        if (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            throw new DLVInvocationException("DLV is RUNNING, stop current invocation before call this function");
        }
        for (DLVInvocationHandler h : handlers) {
            this.unSubscribe(h);
        }
    }

    @Override
    public synchronized void waitUntilExecutionFinishes() throws DLVInvocationException {
        while (this.state == DLVInvocation.DLVInvocationState.RUNNING) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void notify(DLVResult result) {
        if (result instanceof ModelResult) {
            this.notifyModelHandler((ModelResult)result);
        } else if (result instanceof PredicateResult) {
            this.notifyPredicateHandler((PredicateResult)result);
            this.notifyPredicateHandlerWithName((PredicateResult)result);
            if (result instanceof Predicate && (((Predicate)result).name().equals("QueryResult") || ((Predicate)result).name().equals("QueryGroundResult") || ((Predicate)result).name().equals("EmptyQueryResult"))) {
                this.notifyQueryResultHandler((PredicateResult)result);
            }
        } else if (result instanceof FactResult) {
            this.notifyFactHandler((FactResult)result);
            if (result instanceof Literal && (((Literal)result).getName().equals("QueryResult") || ((Literal)result).getName().equals("QueryGroundResult") || ((Literal)result).getName().equals("EmptyQueryResult"))) {
                this.notifyQueryTupleHandler((FactResult)result);
            }
        }
    }

    private void notifyModelHandler(ModelResult model) {
        for (ModelHandler observer : this.modelObservers) {
            observer.handleResult(this, model);
        }
    }

    private void notifyPredicateHandler(PredicateResult predicate) {
        for (PredicateHandler observer : this.predicateObservers) {
            observer.handleResult(this, predicate);
        }
    }

    private void notifyPredicateHandlerWithName(PredicateResult predicate) {
        String predicateName;
        if (predicate instanceof Predicate && this.predicateObserverWithName.containsKey(predicateName = ((Predicate)predicate).name())) {
            for (PredicateHandlerWithName observer : this.predicateObserverWithName.get(predicateName)) {
                observer.handleResult(this, predicate);
            }
        }
    }

    private void notifyFactHandler(FactResult fact) {
        for (FactHandler observer : this.factObservers) {
            observer.handleResult(this, fact);
        }
    }

    private void notifyQueryTupleHandler(FactResult queryTuple) {
        for (QueryTupleHandler observer : this.queryTupleObservers) {
            observer.handleResult(this, queryTuple);
        }
    }

    private void notifyQueryResultHandler(PredicateResult queryResult) {
        for (QueryResultHandler observer : this.queryObservers) {
            observer.handleResult(this, queryResult);
        }
    }

    private void notifyDlvFinishedHandler() {
        for (DlvFinishedHandler observer : this.dlvFinishedObservers) {
            List<DLVError> dlvErrs = null;
            try {
                dlvErrs = this.getErrors();
            }
            catch (DLVInvocationException e) {
                dlvErrs = null;
            }
            observer.dlvFinished(this, dlvErrs);
        }
    }

    @Override
    public BufferedReader getInputReader() {
        return this.inputReader;
    }

    @Override
    public PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public BufferedReader getErrorReader() {
        return this.errorReader;
    }

    @Override
    public boolean haveModel() {
        return this.modelCount != -1;
    }

    @Override
    public void startModel() {
        if (this.trace) {
            System.out.println("startModel()");
        }
        ++this.modelCount;
        this.currentModel = new Model();
    }

    @Override
    public void endModel() {
        if (this.trace) {
            System.out.println("endModel()");
        }
        for (String predicateName : this.predicateMap.keySet()) {
            this.currentModel.addPredicate(this.predicateMap.get(predicateName));
        }
        while (this.currentModel.hasMorePredicates()) {
            this.notify(this.currentModel.nextPredicate());
        }
        this.notify(this.currentModel);
        this.predicateMap.clear();
        this.currentModel = null;
    }

    @Override
    public void startAtom() {
        if (this.trace) {
            System.out.println("startAtom()");
        }
        this.stack.add(new ArrayList());
    }

    @Override
    public void endAtom(boolean trueNegated, String name) {
        if (this.trace) {
            System.out.println("endAtom()");
        }
        ArrayList<Term> attrs = this.topStack();
        this.stack.remove(this.stack.size() - 1);
        if (this.stack.size() == 0 || this.stack.size() == 1 && this.inAggregate) {
            this.atoms.add(new NormalAtom(trueNegated, name, attrs));
        } else {
            Term t = null;
            t = attrs.size() == 0 ? new SimpleTerm(name) : new NormalAtom(trueNegated, name, attrs);
            this.topStack().add(t);
        }
    }

    @Override
    public void literal(boolean positive) {
        if (this.trace) {
            System.out.println("literal()");
        }
        Atom a = this.atoms.remove(this.atoms.size() - 1);
        this.literals.add(new Literal(positive, a, this.modelCount));
        Literal literal = this.literals.remove(this.literals.size() - 1);
        String literalName = literal.getName();
        if (this.allPredicate) {
            if (this.predicateObservers.size() > 0 || this.modelObservers.size() > 0) {
                this.addLiteral(literal);
            }
        } else if (this.predicateObserverWithName.containsKey(literalName)) {
            this.addLiteral(literal);
        }
        this.notify(literal);
    }

    private void addLiteral(Literal literal) {
        String literalName;
        if (this.trace) {
            System.out.println("addLiteral()");
        }
        if (!this.predicateMap.containsKey(literalName = literal.getName())) {
            this.predicateMap.put(literalName, new Predicate(literalName, literal.arity(), this.modelCount));
        }
        Predicate predicate = this.predicateMap.get(literalName);
        predicate.addLiteral(literal);
    }

    @Override
    public void queryGroundOutput(boolean result) {
        if (this.trace) {
            System.out.println("queryGroundOutput()");
        }
        this.startQueryTuple("" + result);
        this.endQueryGroundTuple();
        this.endQueryResult();
    }

    private ArrayList<Term> topStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    public void endQueryGroundTuple() {
        if (this.trace) {
            System.out.println("endQueryGroundTuple()");
        }
        NormalAtom tmpAtom = new NormalAtom(false, "QueryGroundResult", this.currentQueryTuple);
        Literal tmpLiteral = new Literal(true, tmpAtom, this.modelCount);
        if (this.predicateObservers.size() > 0 || this.queryObservers.size() > 0 || this.modelObservers.size() > 0) {
            if (this.queryResult == null) {
                this.queryResult = new Predicate("QueryGroundResult", tmpLiteral.arity(), this.modelCount);
            }
            this.queryResult.addLiteral(tmpLiteral);
        }
        this.notify(tmpLiteral);
        this.foundQueryTuple = true;
    }

    @Override
    public void endQueryTuple() {
        if (this.trace) {
            System.out.println("endQueryTuple()");
        }
        NormalAtom tmpAtom = new NormalAtom(false, "QueryResult", this.currentQueryTuple);
        Literal tmpLiteral = new Literal(true, tmpAtom, this.modelCount);
        if (this.predicateObservers.size() > 0 || this.queryObservers.size() > 0 || this.modelObservers.size() > 0) {
            if (this.queryResult == null) {
                this.queryResult = new Predicate("QueryResult", tmpLiteral.arity(), this.modelCount);
            }
            this.queryResult.addLiteral(tmpLiteral);
        }
        this.notify(tmpLiteral);
        this.foundQueryTuple = true;
    }

    @Override
    public void startQueryTuple(String term) {
        if (this.trace) {
            System.out.println("startQueryTuple()");
        }
        this.currentQueryTuple.clear();
        this.currentQueryTuple.add(new SimpleTerm(term));
    }

    @Override
    public void addQueryTupleTerm(String term) {
        if (this.trace) {
            System.out.println("addQueryTupleTerm()");
        }
        this.currentQueryTuple.add(new SimpleTerm(term));
    }

    @Override
    public void endQueryResult() {
        if (this.trace) {
            System.out.println("endQueryResult()");
        }
        if (this.queryResult != null) {
            Model model = new Model();
            model.addPredicate(this.queryResult);
            this.notify(model);
        }
        this.notify(this.queryResult);
        if (this.containsQueryOptions() && !this.foundQueryTuple) {
            NormalAtom tmpAtom = new NormalAtom(false, "EmptyQueryResult");
            Literal tmpLiteral = new Literal(true, tmpAtom, 1);
            if (this.predicateObservers.size() > 0 || this.queryObservers.size() > 0 || this.modelObservers.size() > 0) {
                if (this.queryResult == null) {
                    this.queryResult = new Predicate("EmptyQueryResult", tmpLiteral.arity(), this.modelCount);
                }
                this.queryResult.addLiteral(tmpLiteral);
            }
            this.notify(tmpLiteral);
            Model model = new Model();
            model.addPredicate(this.queryResult);
            this.notify(model);
        }
        this.queryResult = null;
    }

    @Override
    public void noStableModelFound() {
        if (this.trace) {
            System.out.println("noStableModelFound()");
        }
        this.errors.add(new DLVError("No stable model found."));
    }

    @Override
    public void startCollection() {
        if (this.trace) {
            System.out.println("startCollection()");
        }
        this.stack.add(new ArrayList());
    }

    @Override
    public void endList() {
        if (this.trace) {
            System.out.println("endList()");
        }
        ArrayList<Term> attrs = this.topStack();
        this.stack.remove(this.stack.size() - 1);
        ListTerm term = new ListTerm(attrs);
        this.topStack().add(term);
    }

    @Override
    public void endMultiSet() {
        if (this.trace) {
            System.out.println("endMultiSet()");
        }
        ArrayList<Term> attrs = this.topStack();
        this.stack.remove(this.stack.size() - 1);
        MultiSetTerm term = new MultiSetTerm(attrs);
        this.topStack().add(term);
    }

    private void notifyBufferedExecutionFinishes() {
        for (ModelBufferedHandler handler : this.modelBufferedObserver) {
            handler.dlvFinished();
        }
    }

    @Override
    public ParseException getParseExceptionOnOutput() {
        return this.parseExceptionOnOutput;
    }

    @Override
    public void setOptions(String options) throws DLVInvocationException {
        this.resetOptions();
        this.addOption(options);
    }

    @Override
    public void setBestModel(boolean isBestModel) {
        if (this.currentModel != null) {
            this.currentModel.setBest(isBestModel);
        }
    }

    @Override
    public void addCostModel(int level, int cost) {
        if (this.currentModel != null) {
            this.currentModel.addCostInLevel(level, cost);
        }
    }

    private class OutputManager
    extends Thread {
        private OutputManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String line = "";
            DLVInvocationImpl.this.d = new Director(DLVInvocationImpl.this.inputReader);
            DLVInvocationImpl.this.d.configureDlvInvocation(DLVInvocationImpl.this);
            try {
                if (DLVInvocationImpl.this.containsQueryOptions()) {
                    DLVInvocationImpl.this.d.parseQueryOutput();
                } else {
                    DLVInvocationImpl.this.d.parseOutput();
                }
            }
            catch (ParseException e) {
                DLVInvocationImpl.this.parseExceptionOnOutput = e;
                try {
                    DLVInvocationImpl.this.killDlv();
                }
                catch (DLVInvocationException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    DLVInvocationImpl.this.killDlv();
                }
                catch (DLVInvocationException e1) {
                    DLVInvocationImpl.this.errors.add(new DLVError(e.getMessage()));
                }
            }
            try {
                line = DLVInvocationImpl.this.errorReader.readLine();
                while (line != null) {
                    DLVInvocationImpl.this.errors.add(new DLVError(line));
                    line = DLVInvocationImpl.this.errorReader.readLine();
                }
            }
            catch (IOException e) {
                DLVInvocationImpl.this.errors.add(new DLVError(e.getMessage()));
            }
            try {
                DLVInvocationImpl.this.dlv.waitFor();
            }
            catch (InterruptedException e) {
                DLVInvocationImpl.this.errors.add(new DLVError(e.getMessage()));
            }
            int exitValue = DLVInvocationImpl.this.dlv.exitValue();
            if (exitValue != 0) {
                System.err.println("DLV Error, exitValue=" + exitValue);
                DLVInvocationImpl.this.errors.add(new DLVError("DLV Error, exitValue=" + exitValue));
            }
            DLVInvocationImpl dLVInvocationImpl = DLVInvocationImpl.this;
            synchronized (dLVInvocationImpl) {
                DLVInvocationImpl.this.errorRead = true;
                if (DLVInvocationImpl.this.state != DLVInvocation.DLVInvocationState.KILLED) {
                    DLVInvocationImpl.this.state = DLVInvocation.DLVInvocationState.FINISHED;
                    DLVInvocationImpl.this.notifyAll();
                    DLVInvocationImpl.this.notifyDlvFinishedHandler();
                    DLVInvocationImpl.this.notifyBufferedExecutionFinishes();
                }
            }
        }

        public void kill() {
            this.interrupt();
        }
    }
}

