/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.wrapper.DLVDBInvocationImpl;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVInvocationImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class DLVWrapper {
    private static DLVWrapper instance;
    private String path;
    public static String DLV_DEFAULT_PATH;

    static {
        DLV_DEFAULT_PATH = "files/dlv.exe";
    }

    private DLVWrapper() {
    }

    public static DLVWrapper getInstance() {
        if (instance == null) {
            instance = new DLVWrapper();
        }
        return instance;
    }

    public DLVInvocation createInvocation() {
        return this.createInvocation(DLV_DEFAULT_PATH);
    }

    public DLVInvocation createInvocation(String pathDLV) {
        this.path = pathDLV;
        DLVInvocationImpl invocation = new DLVInvocationImpl();
        return invocation;
    }

    public DLVInvocation createDLVDBInvocation(String pathDLV) {
        this.path = pathDLV;
        DLVDBInvocationImpl invocation = new DLVDBInvocationImpl();
        return invocation;
    }

    public String getVersion() throws DLVInvocationException {
        String ris = "The following warning(s) occurred:\n";
        try {
            Runtime runtime = Runtime.getRuntime();
            Process dlv = runtime.exec(this.getPath());
            BufferedReader in = new BufferedReader(new InputStreamReader(dlv.getInputStream()));
            String line = in.readLine();
            if (line == null) {
                throw new DLVInvocationException("An error is occurred calling DLV.");
            }
            ris = line;
            dlv.waitFor();
        }
        catch (IOException e) {
            throw new DLVInvocationException("An error is occurred calling DLV: " + e.getMessage());
        }
        catch (InterruptedException i) {
            throw new DLVInvocationException("An error is occurred calling DLV: " + i.getMessage());
        }
        return ris;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

