/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.wrapper.ConversionType;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.PredicateImplementation;
import it.unical.mat.wrapper.PredicateMetaData;
import it.unical.mat.wrapper.PredicateResult;
import it.unical.mat.wrapper.exception.BadArityException;
import it.unical.mat.wrapper.exception.DLVExceptionUncheked;
import it.unical.mat.wrapper.exception.LiteralStaledException;
import it.unical.mat.wrapper.exception.MalformedTermException;
import it.unical.mat.wrapper.exception.NoSuchLiteralException;
import it.unical.mat.wrapper.exception.NoSuchTermException;
import it.unical.mat.wrapper.exception.TrueNegationNotSupportedException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Predicate
implements PredicateResult {
    PredicateImplementation impl = null;
    private PredicateMetaData metadata = null;
    private String name;
    private int arity;
    private Model model = null;
    private int cursor = -1;
    private int modelID;
    private boolean insertRow = false;
    private Object[] termsBuffer = null;
    private Boolean signBuffer = null;
    private boolean modified = false;
    private int bufferedRow = -1;

    public Predicate(String name, int arity) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.arity = arity;
        this.impl = new InMemoryPI(arity);
    }

    public Predicate(String name, int arity, int modelID) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.arity = arity;
        this.modelID = modelID;
        this.impl = new InMemoryPI(arity);
    }

    public Predicate(String name, PredicateMetaData metadata) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.arity = metadata.getArity();
        this.metadata = metadata;
        this.impl = new InMemoryPI(this.arity);
    }

    public Predicate(String name, int arity, Model model) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.arity = arity;
        this.model = model;
        this.impl = new InMemoryPI(arity);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPredicateMetaData(PredicateMetaData meta) {
        if (meta.getArity() != this.arity) {
            throw new BadArityException("The specified metadata is invalid.");
        }
        this.metadata = meta;
    }

    public PredicateMetaData getPredicateMetaData() {
        return this.metadata;
    }

    public String name() {
        return this.name;
    }

    public int arity() {
        return this.arity;
    }

    public int size() {
        return this.impl.size();
    }

    public Model getModel() {
        return this.model;
    }

    public String getTermAt(int i, int j) {
        if (i >= this.impl.size() || i < 0) {
            throw new NoSuchLiteralException();
        }
        if (this.metadata == null) {
            return ConversionType.objectToString(this.impl.getTerm(i, j), (byte)2);
        }
        return ConversionType.objectToString(this.impl.getTerm(i, j), this.metadata.getType(j + 1));
    }

    public void setTermAt(int i, int j, String term) {
        if (i >= this.impl.size() || i < 0) {
            throw new NoSuchLiteralException();
        }
        this.impl.setTerm(i, j, term);
        this.impl.update(i);
    }

    public ResultLiteral getLiteral() {
        return this.getLiteral(this.cursor);
    }

    public ResultLiteral getLiteral(int i) {
        if (i >= this.impl.size() || i < 0) {
            throw new NoSuchLiteralException();
        }
        String[] terms = new String[this.arity];
        if (this.metadata == null) {
            int j = 0;
            while (j < this.arity) {
                terms[j] = ConversionType.objectToString(this.impl.getTerm(i, j), (byte)2);
                ++j;
            }
        } else {
            int j = 0;
            while (j < this.arity) {
                terms[j] = ConversionType.objectToString(this.impl.getTerm(i, j), this.metadata.getType(j + 1));
                ++j;
            }
        }
        return new ResultLiteral(terms, this.impl.getSign(i));
    }

    public boolean containsLiteral(Literal literal) {
        int i = 0;
        while (i < this.size()) {
            ResultLiteral resultLit = this.getLiteral(i);
            if (literal.equals(new Literal(resultLit))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(Literal literal) {
        int i = 0;
        while (i < this.size()) {
            ResultLiteral resultLit = this.getLiteral(i);
            if (literal.equals(new Literal(resultLit))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void updateLiteral(ResultLiteral literal) {
        this.updateLiteral(this.cursor, literal);
    }

    public void updateLiteral(int i, ResultLiteral literal) {
        if (literal == null) {
            throw new NullPointerException();
        }
        if (!this.impl.trueNegationSupported() && !literal.isPositive()) {
            throw new TrueNegationNotSupportedException();
        }
        if (literal.term.length != this.arity) {
            throw new BadArityException();
        }
        int size = this.impl.size();
        if (size == 0 || i >= size || i < 0) {
            throw new NoSuchLiteralException();
        }
        this.impl.setTerms(i, literal.term);
        this.impl.setSign(i, literal.positive);
        this.impl.update(i);
    }

    public void removeLiteral() {
        this.removeLiteral(this.cursor);
    }

    public void removeLiteral(int i) {
        int size = this.impl.size();
        if (size == 0 || i >= size || i < 0) {
            return;
        }
        this.impl.remove(i);
        if (this.cursor >= i && this.cursor > 0) {
            --this.cursor;
        }
        if (this.impl.size() == 0) {
            this.cursor = -1;
        }
    }

    public void addResultLiteral(ResultLiteral literal) {
        ResultLiteral tmpF = literal;
        if (!this.impl.trueNegationSupported() && !tmpF.isPositive()) {
            throw new TrueNegationNotSupportedException();
        }
        if (literal == null) {
            throw new NullPointerException();
        }
        if (literal.term.length != this.arity) {
            throw new BadArityException();
        }
        this.impl.add(literal.term, literal.positive);
    }

    public void addLiteral(Rule rule) {
        NormalAtom atomHead = (NormalAtom)rule.head().get(0);
        String[] tmpStrings = new String[atomHead.attributes().size()];
        int count = 0;
        for (Term t : ((NormalAtom)rule.head().get(0)).attributes()) {
            tmpStrings[count] = t.toString();
            ++count;
        }
        ResultLiteral tmpLiteral = new ResultLiteral(tmpStrings);
        if (atomHead.isTrueNegated()) {
            tmpLiteral.setPositive(false);
        }
        this.addResultLiteral(tmpLiteral);
    }

    public void addLiteral(Literal literal) {
        String[] tmpStrings = new String[literal.arity()];
        int count = 0;
        for (Term t : ((NormalAtom)literal.getAtom()).attributes()) {
            tmpStrings[count] = t.toString();
            ++count;
        }
        ResultLiteral tmpLiteral = new ResultLiteral(tmpStrings);
        if (literal.getAtom() instanceof NormalAtom) {
            tmpLiteral.setPositive(!((NormalAtom)literal.getAtom()).isTrueNegated());
        }
        this.addResultLiteral(tmpLiteral);
    }

    public boolean hasMoreLiterals() {
        if (this.impl.size() != 0) {
            return this.cursor < this.impl.size() - 1;
        }
        return false;
    }

    public ResultLiteral nextResultLiteral() {
        if (this.next()) {
            return this.getLiteral();
        }
        throw new NoSuchLiteralException();
    }

    public Literal nextLiteral() {
        return new Literal(this.nextResultLiteral());
    }

    public ResultLiteral previousLiteral() {
        if (this.previous()) {
            return this.getLiteral();
        }
        throw new NoSuchLiteralException();
    }

    public ResultLiteral firstLiteral() {
        this.first();
        return this.getLiteral();
    }

    public ResultLiteral lastLiteral() {
        this.last();
        return this.getLiteral();
    }

    public int getCursor() {
        return this.cursor;
    }

    public boolean first() {
        if (this.insertRow) {
            this.moveToCurrentRow();
        }
        if (this.impl.size() > 0) {
            this.cursor = 0;
            return true;
        }
        return false;
    }

    public boolean last() {
        if (this.insertRow) {
            this.moveToCurrentRow();
        }
        if (this.impl.size() > 0) {
            this.cursor = this.impl.size() - 1;
            return true;
        }
        return false;
    }

    public void beforeFirst() {
        if (this.insertRow) {
            this.moveToCurrentRow();
        }
        this.cursor = -1;
    }

    public void afterLast() {
        if (this.insertRow) {
            this.moveToCurrentRow();
        }
        if (this.impl.size() > 0) {
            this.cursor = this.impl.size();
        }
    }

    public boolean isFirst() {
        return this.cursor == 0 && this.impl.size() > 0;
    }

    public boolean isLast() {
        int size = this.impl.size();
        return this.cursor == size - 1 && size > 0;
    }

    public boolean relative(int i) {
        int size = this.impl.size();
        if (size <= 0) {
            return false;
        }
        this.cursor += i;
        if (this.cursor < -1) {
            this.cursor = -1;
        }
        if (this.cursor > size) {
            this.cursor = size;
        }
        return this.cursor > -1 && this.cursor < size;
    }

    public boolean previous() {
        int size;
        this.cursor += -1;
        if (this.cursor < -1) {
            this.cursor = -1;
        }
        if (this.cursor > (size = this.impl.size())) {
            this.cursor = size;
        }
        return this.cursor > -1 && this.cursor < size;
    }

    public boolean next() {
        int size = this.impl.size();
        if (this.cursor < -1) {
            this.cursor = -1;
            return false;
        }
        ++this.cursor;
        if (this.cursor > size) {
            this.cursor = size;
            return false;
        }
        return this.cursor > -1 && this.cursor < size && size != 0;
    }

    public int getRow() {
        if (this.cursor == this.impl.size()) {
            return 0;
        }
        return this.cursor + 1;
    }

    public boolean absolute(int row) {
        int intRow;
        if (this.insertRow) {
            this.moveToCurrentRow();
        }
        int size = this.impl.size();
        this.cursor = row < 0 ? ((intRow = size + row) < 0 ? -1 : intRow) : ((intRow = row - 1) > size ? size : intRow);
        return this.cursor > -1 && this.cursor < size;
    }

    public void saveTo(String file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        this.appendTo(out);
        out.close();
    }

    public void appendTo(PrintWriter out) {
        if (this.impl.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.impl.size()) {
            if (!this.impl.getSign(i)) {
                out.print("-");
            }
            out.print(this.name);
            int j = 0;
            while (j < this.arity) {
                if (j == 0) {
                    out.print('(');
                }
                out.print(this.getTermAt(i, j));
                if (j == this.arity - 1) {
                    out.print(')');
                } else {
                    out.print(',');
                }
                ++j;
            }
            out.println('.');
            ++i;
        }
    }

    public Enumeration<ResultLiteral> getResultLiterals() {
        return new Enumeration<ResultLiteral>(){
            private int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < Predicate.this.impl.size();
            }

            @Override
            public ResultLiteral nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                ++this.pos;
                return Predicate.this.getLiteral(this.pos - 1);
            }
        };
    }

    public Enumeration<Literal> getLiterals() {
        return new Enumeration<Literal>(){
            Enumeration<ResultLiteral> tmpEnum;
            {
                this.tmpEnum = Predicate.this.getResultLiterals();
            }

            @Override
            public boolean hasMoreElements() {
                return this.tmpEnum.hasMoreElements();
            }

            @Override
            public Literal nextElement() {
                return new Literal(this.tmpEnum.nextElement());
            }
        };
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.impl.size()) {
            if (!this.impl.getSign(i)) {
                buffer.append("-");
            }
            buffer.append(this.name);
            int j = 0;
            while (j < this.arity) {
                if (j == 0) {
                    buffer.append('(');
                }
                buffer.append(this.getTermAt(i, j));
                if (j == this.arity - 1) {
                    buffer.append(')');
                } else {
                    buffer.append(',');
                }
                ++j;
            }
            buffer.append('.');
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public boolean getIsPositive(int row) {
        if (row >= this.impl.size() || row < 0) {
            throw new NoSuchLiteralException();
        }
        return this.impl.getSign(row);
    }

    public void setIsPositive(int row, boolean positive) {
        if (row >= this.impl.size() || row < 0) {
            throw new NoSuchLiteralException();
        }
        if (!this.impl.trueNegationSupported() && !positive) {
            throw new TrueNegationNotSupportedException();
        }
        this.impl.setSign(row, positive);
    }

    public boolean getIsPositive() {
        return this.getCurrentTermSign();
    }

    public void updateIsPositive(boolean positive) {
        if (!this.impl.trueNegationSupported() && !positive) {
            throw new TrueNegationNotSupportedException();
        }
        this.setCurrentTermSign(new Boolean(positive));
    }

    public void updateBoolean(int columnIndex, boolean x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Boolean(x));
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, x);
    }

    public void updateByte(int columnIndex, byte x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Byte(x));
    }

    public void updateDate(int columnIndex, Date x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, x);
    }

    public void updateDouble(int columnIndex, double x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Double(x));
    }

    public void updateFloat(int columnIndex, float x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Float(x));
    }

    public void updateInt(int columnIndex, int x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Integer(x));
    }

    public void updateLong(int columnIndex, long x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Long(x));
    }

    public void updateNull(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, ConversionType.DBNULL_CLASS);
    }

    public void updateShort(int columnIndex, short x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, new Short(x));
    }

    public void updateString(int columnIndex, String x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, x);
    }

    public void updateTime(int columnIndex, Time x) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        this.setCurrentTerm(arrayIndex, x);
    }

    public boolean getBoolean(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Boolean) {
            return (Boolean)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return false;
        }
        throw new MalformedTermException();
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof BigDecimal) {
            return (BigDecimal)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return null;
        }
        throw new MalformedTermException();
    }

    public byte getByte(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Byte) {
            return (Byte)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return 0;
        }
        throw new MalformedTermException();
    }

    @Override
    public int getModelID() {
        return this.modelID;
    }

    public Date getDate(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Date) {
            return (Date)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return null;
        }
        throw new MalformedTermException();
    }

    public double getDouble(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Double) {
            return (Double)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return 0.0;
        }
        throw new MalformedTermException();
    }

    public float getFloat(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Float) {
            return ((Float)term).floatValue();
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return 0.0f;
        }
        throw new MalformedTermException();
    }

    public int getInt(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Integer) {
            return (Integer)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return 0;
        }
        throw new MalformedTermException();
    }

    public long getLong(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Long) {
            return (Long)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return 0L;
        }
        throw new MalformedTermException();
    }

    public short getShort(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Short) {
            return (Short)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return 0;
        }
        throw new MalformedTermException();
    }

    public String getString(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof String) {
            return (String)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return null;
        }
        throw new MalformedTermException();
    }

    public Time getTime(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.arity) {
            throw new NoSuchLiteralException();
        }
        int arrayIndex = columnIndex - 1;
        Object term = this.getCurrentTerm(arrayIndex);
        if (term instanceof Time) {
            return (Time)term;
        }
        if (term == ConversionType.DBNULL_CLASS) {
            return null;
        }
        throw new MalformedTermException();
    }

    private void setCurrentTerm(int i, Object term) {
        if (this.bufferedRow != this.cursor || !this.modified) {
            this.bufferedRow = this.cursor;
            this.termsBuffer = new Object[this.arity];
            this.termsBuffer = this.impl.getTerms(this.bufferedRow, this.termsBuffer);
            this.signBuffer = new Boolean(this.impl.getSign(i));
            this.modified = true;
        }
        this.termsBuffer[i] = term;
    }

    private void setCurrentTermSign(Boolean b) {
        if (this.bufferedRow != this.cursor || !this.modified) {
            this.bufferedRow = this.cursor;
            this.termsBuffer = new Object[this.arity];
            this.termsBuffer = this.impl.getTerms(this.bufferedRow, this.termsBuffer);
            this.modified = true;
        }
        this.signBuffer = b;
    }

    private Object getCurrentTerm(int term) {
        if (this.insertRow || this.modified && this.bufferedRow == this.cursor) {
            return this.termsBuffer[term];
        }
        return this.impl.getTerm(this.cursor, term);
    }

    private boolean getCurrentTermSign() {
        if (this.insertRow || this.modified && this.bufferedRow == this.cursor) {
            return this.signBuffer;
        }
        return this.impl.getSign(this.cursor);
    }

    public void moveToInsertRow() {
        this.insertRow = true;
        this.bufferedRow = -1;
        this.termsBuffer = new Object[this.arity];
        this.signBuffer = new Boolean(true);
        this.modified = true;
        int i = 0;
        while (i < this.arity) {
            this.termsBuffer[i] = ConversionType.DBNULL_CLASS;
            ++i;
        }
    }

    public void cancelRowUpdates() {
        if (this.insertRow) {
            this.moveToInsertRow();
        }
        this.termsBuffer = null;
        this.signBuffer = null;
        this.modified = false;
        this.bufferedRow = -1;
    }

    public void moveToCurrentRow() {
        this.insertRow = false;
        this.termsBuffer = null;
        this.signBuffer = null;
        this.modified = false;
        this.bufferedRow = -1;
    }

    public void insertRow() {
        if (!this.insertRow) {
            throw new DLVExceptionUncheked("You must be on the insert row!");
        }
        this.impl.add(this.termsBuffer, this.signBuffer);
        this.moveToInsertRow();
    }

    public void updateRow() {
        if (this.insertRow) {
            throw new DLVExceptionUncheked("You cannot update the insert row!");
        }
        if (this.modified && this.bufferedRow == this.cursor) {
            this.impl.setTerms(this.bufferedRow, this.termsBuffer);
            this.impl.setSign(this.bufferedRow, this.signBuffer);
            this.impl.update(this.bufferedRow);
        }
    }

    class InMemoryPI
    extends PredicateImplementation {
        private ArrayList<LiteralHandler> list;

        InMemoryPI(int arity) {
            super(arity);
            this.list = new ArrayList();
        }

        @Override
        void updateImplementation(int row, Object[] terms, Boolean b) {
            if (row < 0 || row >= this.list.size()) {
                throw new NoSuchLiteralException();
            }
            LiteralHandler lh = new LiteralHandler();
            lh.term = new String[Predicate.this.arity];
            if (b != null) {
                lh.sign = b;
            }
            if (terms != null) {
                if (Predicate.this.metadata == null) {
                    int j = 0;
                    while (j < Predicate.this.arity) {
                        lh.term[j] = ConversionType.objectToString(terms[j], (byte)2);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < Predicate.this.arity) {
                        lh.term[j] = ConversionType.objectToString(terms[j], Predicate.this.metadata.getType(j + 1));
                        ++j;
                    }
                }
            } else {
                throw new NullPointerException();
            }
            this.list.remove(row);
            this.list.add(row, lh);
        }

        @Override
        Object getTerm(int row, int col) {
            if (row < 0 || row >= this.list.size()) {
                throw new NoSuchLiteralException();
            }
            if (col < 0 || col >= Predicate.this.arity) {
                throw new NoSuchTermException();
            }
            LiteralHandler lh = this.list.get(row);
            if (Predicate.this.metadata == null) {
                return ConversionType.stringToObject(lh.term[col], (byte)2);
            }
            return ConversionType.stringToObject(lh.term[col], Predicate.this.metadata.getType(col + 1));
        }

        @Override
        boolean getSign(int row) {
            if (row < 0 || row >= this.list.size()) {
                throw new NoSuchLiteralException();
            }
            LiteralHandler lh = this.list.get(row);
            return lh.sign;
        }

        @Override
        int size() {
            return this.list.size();
        }

        @Override
        void removeFromImplementaion(int row) {
            if (row < 0 || row >= this.list.size()) {
                throw new NoSuchLiteralException();
            }
            this.list.remove(row);
        }

        @Override
        int indexOf(Object[] t, boolean b) {
            int pos = 0;
            while (pos < this.list.size()) {
                LiteralHandler lh = this.list.get(pos);
                if (lh.equalTo(t, b)) {
                    return pos;
                }
                ++pos;
            }
            return -1;
        }

        @Override
        void add(Object[] terms, boolean sign) {
            LiteralHandler lh = new LiteralHandler();
            lh.sign = sign;
            lh.term = new String[Predicate.this.arity];
            if (terms != null) {
                if (Predicate.this.metadata == null) {
                    int j = 0;
                    while (j < Predicate.this.arity) {
                        lh.term[j] = ConversionType.objectToString(terms[j], (byte)2);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < Predicate.this.arity) {
                        lh.term[j] = ConversionType.objectToString(terms[j], Predicate.this.metadata.getType(j + 1));
                        ++j;
                    }
                }
            } else {
                throw new NullPointerException();
            }
            this.list.add(lh);
        }
    }

    private class LiteralHandler {
        String[] term = null;
        boolean sign = true;

        private LiteralHandler() {
        }

        boolean equalTo(Object[] o, boolean b) {
            if (b != this.sign) {
                return false;
            }
            int j = 0;
            while (j < this.term.length) {
                String t = Predicate.this.metadata == null ? ConversionType.objectToString(o[j], (byte)2) : ConversionType.objectToString(o[j], Predicate.this.metadata.getType(j + 1));
                if (!t.equals(this.term[j])) {
                    return false;
                }
                ++j;
            }
            return true;
        }
    }

    public class ResultLiteral {
        private String[] term = new String[0];
        private boolean positive = true;
        private String[] oldTerm = null;
        private boolean oldPositive = true;

        private void bufferTerm() {
            this.oldTerm = new String[Predicate.this.arity];
            int i = 0;
            while (i < Predicate.this.arity) {
                this.oldTerm[i] = this.term[i];
                ++i;
            }
            this.oldPositive = this.positive;
        }

        public ResultLiteral() {
            if (Predicate.this.arity != 0) {
                throw new BadArityException();
            }
            this.term = new String[0];
        }

        public ResultLiteral(boolean positive) {
            if (Predicate.this.arity != 0) {
                throw new BadArityException();
            }
            this.term = new String[0];
            this.positive = positive;
        }

        public void setPositive(boolean positive) {
            this.positive = positive;
        }

        public ResultLiteral(String[] term) {
            if (term.length != Predicate.this.arity) {
                throw new BadArityException();
            }
            boolean trovato = false;
            int i = 0;
            while (!trovato && i < Predicate.this.arity) {
                if (term[i] == null) {
                    trovato = true;
                }
                ++i;
            }
            if (trovato) {
                throw new NullPointerException("term contains a null String object");
            }
            this.term = term;
        }

        public ResultLiteral(String[] term, boolean positive) {
            if (term.length != Predicate.this.arity) {
                throw new BadArityException();
            }
            boolean trovato = false;
            int i = 0;
            while (!trovato && i < Predicate.this.arity) {
                if (term[i] == null) {
                    trovato = true;
                }
                ++i;
            }
            if (trovato) {
                throw new NullPointerException("term contains a null String object");
            }
            this.term = term;
            this.positive = positive;
        }

        public Predicate getPredicate() {
            return Predicate.this;
        }

        public String name() {
            return Predicate.this.name;
        }

        public int arity() {
            return Predicate.this.arity;
        }

        public String getTermAt(int i) {
            if (i >= this.term.length || i < 0) {
                throw new NoSuchTermException();
            }
            return this.term[i];
        }

        public void setTermAt(String t, int i) {
            this.setTermAt(i, t);
        }

        public void setTermAt(int i, String t) {
            if (i >= this.term.length || i < 0) {
                throw new NoSuchTermException();
            }
            if (t == null) {
                throw new NullPointerException();
            }
            if (!this.term[i].equals(t) && this.oldTerm == null) {
                this.bufferTerm();
            }
            this.term[i] = t;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public void invert() {
            if (this.oldTerm == null) {
                this.bufferTerm();
            }
            this.oldPositive = this.positive;
            this.positive = !this.positive;
        }

        public ResultLiteral getContrary() {
            return new ResultLiteral(this.term, !this.positive);
        }

        public boolean isContrary(ResultLiteral f) {
            if (f == null) {
                throw new NullPointerException();
            }
            if (f == this) {
                return false;
            }
            if (f.getPredicate() != Predicate.this) {
                return false;
            }
            if (this.positive == f.positive) {
                return false;
            }
            if (this.term.length != f.term.length) {
                return false;
            }
            int i = 0;
            while (i < this.term.length) {
                if (this.term[i] != f.term[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (!this.positive) {
                buffer.append("-");
            }
            buffer.append(Predicate.this.name);
            int j = 0;
            while (j < Predicate.this.arity) {
                if (j == 0) {
                    buffer.append('(');
                }
                buffer.append(this.term[j]);
                if (j == Predicate.this.arity - 1) {
                    buffer.append(')');
                } else {
                    buffer.append(',');
                }
                ++j;
            }
            buffer.append('.');
            return buffer.toString();
        }

        public void appendTo(PrintWriter out) {
            if (!this.positive) {
                out.print("-");
            }
            out.print(Predicate.this.name);
            int j = 0;
            while (j < Predicate.this.arity) {
                if (j == 0) {
                    out.print('(');
                }
                out.print(this.term[j]);
                if (j == Predicate.this.arity - 1) {
                    out.print(')');
                } else {
                    out.print(',');
                }
                ++j;
            }
            out.print('.');
        }

        public boolean equals(Object o) {
            ResultLiteral f = (ResultLiteral)o;
            if (f == null) {
                throw new NullPointerException();
            }
            if (f == this) {
                return true;
            }
            if (f.getPredicate() != Predicate.this) {
                return false;
            }
            if (this.positive != f.positive) {
                return false;
            }
            if (Predicate.this.arity == 0 && this.positive == f.positive) {
                return true;
            }
            if (this.term == f.term) {
                return true;
            }
            if (this.term.length != f.term.length) {
                return false;
            }
            int i = 0;
            while (i < this.term.length) {
                if (!this.term[i].equals(f.term[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void update() {
            if (!Predicate.this.impl.trueNegationSupported() && !this.positive) {
                throw new TrueNegationNotSupportedException();
            }
            int pos = -1;
            pos = this.oldTerm == null ? Predicate.this.impl.indexOf(this.term, this.positive) : Predicate.this.impl.indexOf(this.oldTerm, this.oldPositive);
            if (pos == -1) {
                throw new LiteralStaledException();
            }
            Predicate.this.impl.setTerms(pos, this.term);
            Predicate.this.impl.setSign(pos, this.positive);
            Predicate.this.impl.update(pos);
        }
    }
}

