/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import java.util.HashMap;

abstract class PredicateImplementation {
    private HashMap<Integer, LiteralHandler> modifiedTable = new HashMap();
    private int arity;

    PredicateImplementation(int arity) {
        this.arity = arity;
    }

    void update(int row) {
        Integer pos = new Integer(row);
        LiteralHandler lh = this.modifiedTable.get(pos);
        if (lh == null) {
            return;
        }
        this.updateImplementation(row, lh.term, lh.sign);
        this.modifiedTable.remove(pos);
    }

    void setSign(int row, boolean s) {
        Integer pos = new Integer(row);
        LiteralHandler lh = this.modifiedTable.get(pos);
        if (lh != null) {
            lh.sign = new Boolean(s);
        } else {
            lh = new LiteralHandler(null, new Boolean(s));
            this.modifiedTable.put(pos, lh);
        }
    }

    void setTerm(int row, int col, Object o) {
        Integer pos = new Integer(row);
        LiteralHandler lh = this.modifiedTable.get(pos);
        if (lh != null) {
            if (lh.term == null) {
                lh.term = new Object[this.arity];
            }
            lh.term[col] = o;
        } else {
            lh = new LiteralHandler(new Object[this.arity], null);
            lh.term[col] = o;
            this.modifiedTable.put(pos, lh);
        }
    }

    void remove(int row) {
        this.removeFromImplementaion(row);
        this.modifiedTable.remove(new Integer(row));
    }

    abstract void updateImplementation(int var1, Object[] var2, Boolean var3);

    abstract Object getTerm(int var1, int var2);

    abstract boolean getSign(int var1);

    abstract int size();

    abstract void removeFromImplementaion(int var1);

    abstract int indexOf(Object[] var1, boolean var2);

    abstract void add(Object[] var1, boolean var2);

    boolean trueNegationSupported() {
        return true;
    }

    void setTerms(int row, Object[] t) {
        int k = 0;
        while (k < t.length) {
            this.setTerm(row, k, t[k]);
            ++k;
        }
    }

    Object[] getTerms(int row, Object[] t) {
        int k = 0;
        while (k < t.length) {
            t[k] = this.getTerm(row, k);
            ++k;
        }
        return t;
    }

    private class LiteralHandler {
        Boolean sign = null;
        Object[] term = null;

        LiteralHandler(Object[] o, Boolean s) {
            this.sign = s;
            this.term = o;
        }
    }
}

