/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.wrapper.ConversionType;
import it.unical.mat.wrapper.exception.BadColumnNameException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class PredicateMetaData {
    private byte[] type = null;
    private String[] name = null;

    public PredicateMetaData(int arity) {
        this.type = new byte[arity];
        this.name = new String[arity];
        int i = 0;
        while (i < arity) {
            this.type[i] = 2;
            this.name[i] = null;
            ++i;
        }
    }

    public PredicateMetaData(ResultSetMetaData rsmd) throws SQLException {
        int arity = rsmd.getColumnCount();
        this.type = new byte[arity];
        this.name = new String[arity];
        int i = 0;
        while (i < arity) {
            this.type[i] = ConversionType.sqlToDlvTypes(rsmd.getColumnType(i + 1));
            this.name[i] = rsmd.getColumnName(i + 1);
            ++i;
        }
    }

    public int getArity() {
        return this.type.length;
    }

    public void setType(int argument, byte conversionType) {
        this.type[--argument] = conversionType;
    }

    public byte getType(int argument) {
        return this.type[--argument];
    }

    public void setName(int argument, String argumentName) {
        this.name[--argument] = argumentName;
    }

    public String getName(int argument) {
        return this.name[--argument];
    }

    public int getArgumentByName(String argumentName) {
        int i = 0;
        while (i < this.name.length) {
            if (!this.name[i].equals(argumentName)) continue;
            return i + 1;
        }
        throw new BadColumnNameException("The name \"" + argumentName + "\" does not correspond to a column name");
    }
}

