/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.obfuscator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;

public class IdentifierMap
implements Serializable {
    public static int MAX_SHIFT = 100;
    public static String REPLACE_PREDICATE_SUFFIX = "_FAKE";
    public static String PREDICATE_PREFIX = "predicate";
    public static String VARIABLE_PREFIX = "VAR";
    public static String CONSTANT_PREFIX = "constant";
    public int obfuscationLevel = 1;
    HashMap<String, String> predicateNames = new HashMap();
    HashMap<String, String> variableNames = new HashMap();
    HashMap<String, String> constantValues = new HashMap();
    HashMap<String, String> replacedPredicateNames = new HashMap();
    HashMap<String, Integer> shiftValues = new HashMap();

    public void setObfuscationLevel(int obfuscationLevel) {
        this.obfuscationLevel = obfuscationLevel;
    }

    public int getObfuscationLevel() {
        return this.obfuscationLevel;
    }

    public String getReplacedPredicateName(String predicateName) {
        if (!this.replacedPredicateNames.containsKey(predicateName)) {
            this.replacedPredicateNames.put(predicateName, String.valueOf(predicateName) + REPLACE_PREDICATE_SUFFIX);
        }
        return this.replacedPredicateNames.get(predicateName);
    }

    public String getOriginalPredicateNameReplaced(String replacedPredicateName) {
        for (String key : this.replacedPredicateNames.keySet()) {
            if (!this.replacedPredicateNames.get(key).equals(replacedPredicateName)) continue;
            return key;
        }
        return "undefined";
    }

    public int getPredicateShifting(String originalPredicateName) {
        if (!this.shiftValues.containsKey(originalPredicateName)) {
            Random random = new Random();
            int shiftValue = random.nextInt(MAX_SHIFT) + 1;
            this.shiftValues.put(originalPredicateName, new Integer(shiftValue));
        }
        return this.shiftValues.get(originalPredicateName);
    }

    public String getObfuscatePredicateName(String predicateName) {
        if (!this.predicateNames.containsKey(predicateName)) {
            this.predicateNames.put(predicateName, String.valueOf(PREDICATE_PREFIX) + this.predicateNames.size());
        }
        return this.predicateNames.get(predicateName);
    }

    public String getObfuscateVariableName(String variableName) {
        if (!this.variableNames.containsKey(variableName)) {
            this.variableNames.put(variableName, String.valueOf(VARIABLE_PREFIX) + this.variableNames.size());
        }
        return this.variableNames.get(variableName);
    }

    public String getObfuscateConstantValue(String constant) {
        if (!this.constantValues.containsKey(constant)) {
            this.constantValues.put(constant, String.valueOf(CONSTANT_PREFIX) + this.constantValues.size());
        }
        return this.constantValues.get(constant);
    }

    public String getOriginalVariableName(String obfuscateVariableName) {
        for (String key : this.variableNames.keySet()) {
            if (!this.variableNames.get(key).equals(obfuscateVariableName)) continue;
            return key;
        }
        return "UNDEFINIED";
    }

    public String getOriginalPredicateName(String obfuscatePredicateName) {
        for (String key : this.predicateNames.keySet()) {
            if (!this.predicateNames.get(key).equals(obfuscatePredicateName)) continue;
            if (this.predicateNames.containsValue(key)) {
                return this.getOriginalPredicateName(key);
            }
            return key;
        }
        return "undefinied";
    }

    public String getOriginalConstantValue(String obfuscateConstantValue) {
        for (String key : this.constantValues.keySet()) {
            if (!this.constantValues.get(key).equals(obfuscateConstantValue)) continue;
            return key;
        }
        return "undefinied";
    }
}

