/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.util;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

@Deprecated
public class DependencyGraph {
    private IndexedProgram program;
    private List<Set<Atom>> stronglyConnectedComponent;
    private DirectedGraph<Atom, DefaultEdge> graph;
    private DirectedGraph<Atom, DefaultEdge> currentGraph;
    private DirectedGraph<Atom, DefaultEdge> completeGraph;
    private DirectedGraph<Atom, DefaultEdge> positiveGraph;
    private DirectedGraph<Atom, DefaultEdge> connectedComponentGraph;
    private ArrayList<DefaultEdge> disabledEdges = new ArrayList();
    private boolean ground;

    protected DependencyGraph(Program program, DirectedGraph<Atom, DefaultEdge> graph, List<Set<Atom>> stronglyConnectedComponent) {
        this.graph = graph;
        this.stronglyConnectedComponent = stronglyConnectedComponent;
        this.program = program instanceof IndexedProgram ? (IndexedProgram)program : new IndexedProgram(program);
        this.ground = program.isGround();
        this.buildGraphs();
        this.currentGraph = this.completeGraph;
    }

    public IndexedProgram getProgram() {
        return this.program;
    }

    public List<Set<Atom>> getStronglyConnectedComponent() {
        return this.stronglyConnectedComponent;
    }

    public void getDependenciesFromNode(Atom atom, List<Atom> list) {
        Set l = new HashSet();
        l = this.currentGraph.incomingEdgesOf((Object)atom);
        if (!l.isEmpty()) {
            for (DefaultEdge edge : l) {
                Atom a = (Atom)this.currentGraph.getEdgeSource((Object)edge);
                if (list.contains(a) || a == atom) continue;
                list.add(a);
                this.getDependenciesFromNode(a, list);
            }
        }
    }

    public List<Atom> getDependenciesFromEdge(Atom sourceAtom, Atom targetAtom) {
        DefaultEdge edge = (DefaultEdge)this.currentGraph.getEdge((Object)sourceAtom, (Object)targetAtom);
        if (edge != null) {
            ArrayList<Atom> list = new ArrayList<Atom>();
            this.getDependenciesFromNode((Atom)this.currentGraph.getEdgeSource((Object)edge), list);
            return list;
        }
        return null;
    }

    public boolean isPositiveEdge(Atom sourceAtom, Atom targetAtom) {
        block10: {
            Set<Atom> targetConnComp;
            Set<Atom> sourceConnComp;
            block11: {
                block9: {
                    sourceConnComp = null;
                    targetConnComp = null;
                    for (Set<Atom> atomSet : this.getStronglyConnectedComponent()) {
                        if (!sourceAtom.getName().equals(atomSet.toString())) continue;
                        sourceConnComp = atomSet;
                    }
                    for (Set<Atom> atomSet : this.getStronglyConnectedComponent()) {
                        if (!targetAtom.getName().equals(atomSet.toString())) continue;
                        targetConnComp = atomSet;
                    }
                    if (sourceConnComp == null && targetConnComp == null) {
                        for (String s : this.program.getBodyRulesAtomMap().keySet()) {
                            for (Rule rule : this.program.getBodyRulesAtomMap().get(s)) {
                                for (Literal bodyLit : rule.body()) {
                                    if (bodyLit.isPositive() || !bodyLit.getAtom().equals(sourceAtom) || !rule.head().contains(targetAtom)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                    if (sourceConnComp == null || targetConnComp != null) break block9;
                    for (Atom a : sourceConnComp) {
                        if (this.isPositiveEdge(a, targetAtom)) continue;
                        return false;
                    }
                    break block10;
                }
                if (targetConnComp == null || sourceConnComp != null) break block11;
                for (Atom a : targetConnComp) {
                    if (this.isPositiveEdge(sourceAtom, a)) continue;
                    return false;
                }
                break block10;
            }
            if (targetConnComp == null || sourceConnComp == null) break block10;
            for (Atom a : sourceConnComp) {
                if (this.isPositiveEdge(a, targetAtom)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isGround() {
        return this.ground;
    }

    private void buildCompleteGraph() {
        this.completeGraph = new DefaultDirectedGraph(DefaultEdge.class);
        for (Atom a : this.graph.vertexSet()) {
            this.completeGraph.addVertex((Object)a);
        }
        for (DefaultEdge e : this.graph.edgeSet()) {
            this.completeGraph.addEdge((Object)((Atom)this.graph.getEdgeSource((Object)e)), (Object)((Atom)this.graph.getEdgeTarget((Object)e)));
        }
    }

    private void buildPositiveGraph() {
        this.positiveGraph = new DefaultDirectedGraph(DefaultEdge.class);
        for (Atom a : this.completeGraph.vertexSet()) {
            this.positiveGraph.addVertex((Object)a);
        }
        for (DefaultEdge e : this.completeGraph.edgeSet()) {
            this.positiveGraph.addEdge((Object)((Atom)this.completeGraph.getEdgeSource((Object)e)), (Object)((Atom)this.completeGraph.getEdgeTarget((Object)e)));
        }
        for (DefaultEdge edge : this.completeGraph.edgeSet()) {
            if (this.isPositiveEdge((Atom)this.completeGraph.getEdgeSource((Object)edge), (Atom)this.completeGraph.getEdgeTarget((Object)edge))) continue;
            this.positiveGraph.removeEdge((Object)((Atom)this.completeGraph.getEdgeSource((Object)edge)), (Object)((Atom)this.completeGraph.getEdgeTarget((Object)edge)));
        }
    }

    private void buildConnectedComponentGraph() {
        this.connectedComponentGraph = new DefaultDirectedGraph(DefaultEdge.class);
        for (Atom atom : this.completeGraph.vertexSet()) {
            this.connectedComponentGraph.addVertex((Object)atom);
        }
        for (DefaultEdge defaultEdge : this.completeGraph.edgeSet()) {
            this.connectedComponentGraph.addEdge((Object)((Atom)this.completeGraph.getEdgeSource((Object)defaultEdge)), (Object)((Atom)this.completeGraph.getEdgeTarget((Object)defaultEdge)));
        }
        for (Set set : this.getStronglyConnectedComponent()) {
            if (set.size() <= 1) continue;
            String atomName = set.toString();
            NormalAtom atomGroup = new NormalAtom(atomName);
            this.connectedComponentGraph.addVertex((Object)atomGroup);
            for (Atom a : set) {
                for (DefaultEdge e : this.connectedComponentGraph.outgoingEdgesOf((Object)a)) {
                    this.connectedComponentGraph.addEdge((Object)atomGroup, (Object)((Atom)this.connectedComponentGraph.getEdgeTarget((Object)e)));
                }
                for (DefaultEdge e : this.connectedComponentGraph.incomingEdgesOf((Object)a)) {
                    this.connectedComponentGraph.addEdge((Object)((Atom)this.connectedComponentGraph.getEdgeSource((Object)e)), (Object)atomGroup);
                }
                this.connectedComponentGraph.removeVertex((Object)a);
            }
            this.connectedComponentGraph.removeAllEdges((Object)atomGroup, (Object)atomGroup);
        }
    }

    public DirectedGraph<Atom, DefaultEdge> getGraph(String type) {
        this.currentGraph = type.equals("Complete") ? this.completeGraph : (type.equals("Positive") ? this.positiveGraph : (type.equals("Connected Component") ? this.connectedComponentGraph : this.completeGraph));
        System.out.println("archi disabilitati: " + this.disabledEdges);
        System.out.println("grafo principale: " + this.graph);
        if (!this.disabledEdges.isEmpty()) {
            for (DefaultEdge e : this.disabledEdges) {
                if (this.currentGraph.containsEdge((Object)((Atom)this.currentGraph.getEdgeSource((Object)e)), (Object)((Atom)this.currentGraph.getEdgeTarget((Object)e)))) {
                    this.currentGraph.removeEdge((Object)((Atom)this.currentGraph.getEdgeSource((Object)e)), (Object)((Atom)this.currentGraph.getEdgeTarget((Object)e)));
                    continue;
                }
                System.out.println("non contenuto " + this.currentGraph.getEdgeSource((Object)e) + "," + this.currentGraph.getEdgeTarget((Object)e));
                System.out.println(this.currentGraph);
            }
        }
        return this.currentGraph;
    }

    public void buildGraphs() {
        this.buildCompleteGraph();
        this.buildPositiveGraph();
        this.buildConnectedComponentGraph();
    }

    public void disableEdge(Atom sourceAtom, Atom targetAtom) {
        this.disabledEdges.add((DefaultEdge)this.currentGraph.getEdge((Object)sourceAtom, (Object)targetAtom));
    }

    public void enableEdge(DefaultEdge edge) {
        if (this.disabledEdges.remove(edge)) {
            this.buildGraphs();
        }
    }
}

