/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.util.dependencygraph;

import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompleteGraph
extends DependencyGraph {
    HashMap<Atom, List<Atom>> positiveConnections = new HashMap();
    HashMap<Atom, List<Atom>> negativeConnections = new HashMap();
    HashMap<Atom, List<Atom>> positiveAggregateConnections = new HashMap();
    HashMap<Atom, List<Atom>> negativeAggregateConnections = new HashMap();

    public CompleteGraph(IndexedProgram program) {
        this.buildGraph();
    }

    public CompleteGraph(IndexedProgram program, boolean showDisjunctionConnections) {
        this.setShowDisjunctionLinks(showDisjunctionConnections);
        this.buildGraph();
    }

    private void buildGraph() {
        boolean isProgramGround = this.getProgram().isGround();
        isProgramGround = false;
        HashMap<String, Atom> atomMap = new HashMap<String, Atom>();
        ArrayList<String> nodesNamesBody = new ArrayList<String>();
        if (isProgramGround) {
            nodesNamesBody.addAll(this.getProgram().getBodyRulesAtomMap().keySet());
        } else {
            nodesNamesBody.addAll(this.getProgram().getBodyRulesPredicateMap().keySet());
        }
        for (String atomId : nodesNamesBody) {
            Atom bodyAtom;
            if (!atomMap.containsKey(atomId)) {
                Atom atom = isProgramGround ? this.getProgram().getAtomMap().get(atomId) : CompleteGraph.generateAtom(atomId);
                atomMap.put(atomId, atom);
            }
            if (!this.containsVertex(bodyAtom = (Atom)atomMap.get(atomId))) {
                this.addVertex(bodyAtom);
            }
            List<Rule> rulesWithAtomInBody = isProgramGround ? this.getProgram().getBodyRulesAtomMap().get(atomId) : this.getProgram().getBodyRulesPredicateMap().get(atomId);
            for (Rule rule : rulesWithAtomInBody) {
                boolean isPositive = false;
                boolean isNegative = false;
                boolean inPositiveAggregate = false;
                boolean inNegativeAggregate = false;
                for (Literal literal : rule.getBody()) {
                    boolean literalGround;
                    if (literal.isPositive()) {
                        literalGround = literal.getAtom().isGround();
                        literalGround = false;
                        if (literalGround) {
                            if (literal.getAtom().toString().equals(atomId)) {
                                isPositive = true;
                            }
                        } else if (literal.getAtom().getName().equals(atomId)) {
                            isPositive = true;
                        }
                    }
                    if (!literal.isPositive()) {
                        literalGround = literal.getAtom().isGround();
                        literalGround = false;
                        if (literalGround) {
                            if (literal.getAtom().toString().equals(atomId)) {
                                isNegative = true;
                            }
                        } else if (literal.getAtom().getName().equals(atomId)) {
                            isNegative = true;
                        }
                    }
                    if (!(literal.getAtom() instanceof AggregateAtom)) continue;
                    for (Literal aggrLiteral : ((AggregateAtom)literal.getAtom()).getBody()) {
                        Atom atom;
                        if (aggrLiteral.isPositive()) {
                            atom = aggrLiteral.getAtom();
                            if (!atom.getName().equals(atomId)) continue;
                            inPositiveAggregate = true;
                            continue;
                        }
                        atom = aggrLiteral.getAtom();
                        if (!atom.getName().equals(atomId)) continue;
                        inNegativeAggregate = true;
                    }
                }
                if (rule.isFact() || rule.isConstraint()) continue;
                LinkedList<Atom> visitedHeadAtom = new LinkedList<Atom>();
                Iterator iterator = rule.head().iterator();
                while (iterator.hasNext()) {
                    String atomId2;
                    Atom headAtom;
                    Atom atom = headAtom = (Atom)iterator.next();
                    if (isProgramGround) {
                        atomId2 = atom.toString();
                    } else {
                        atom = CompleteGraph.generateAtom(headAtom.getName());
                        atomId2 = headAtom.getName();
                    }
                    if (!atomMap.containsKey(atomId2)) {
                        atomMap.put(atomId2, atom);
                    }
                    if (!this.containsVertex(atom = (Atom)atomMap.get(atomId2))) {
                        this.addVertex(atom);
                    }
                    if (isPositive && !this.containsPositiveEdge(bodyAtom, atom)) {
                        this.addPositiveEdge(bodyAtom, atom);
                    }
                    if (isNegative && !this.containsNegativeEdge(bodyAtom, atom)) {
                        this.addNegativeEdge(bodyAtom, atom);
                    }
                    if (inPositiveAggregate && !this.hasAggregatePositiveEdge(bodyAtom, atom)) {
                        this.addPositiveAggregateEdge(bodyAtom, atom);
                    }
                    if (inNegativeAggregate && !this.hasAggregateNegativeEdge(bodyAtom, atom)) {
                        this.addNegativeAggregateEdge(bodyAtom, atom);
                    }
                    if (this.isShowDisjunctionLinks()) {
                        for (Atom previousHeadAtom : visitedHeadAtom) {
                            this.addVertex(previousHeadAtom);
                            this.addVertex(atom);
                            if (!this.containsPositiveEdge(previousHeadAtom, atom)) {
                                this.addPositiveEdge(previousHeadAtom, atom);
                            }
                            if (!this.containsPositiveEdge(atom, previousHeadAtom)) {
                                this.addPositiveEdge(atom, previousHeadAtom);
                            }
                            if (!this.containsNegativeEdge(previousHeadAtom, atom)) {
                                this.addNegativeEdge(previousHeadAtom, atom);
                            }
                            if (this.containsNegativeEdge(atom, previousHeadAtom)) continue;
                            this.addNegativeEdge(atom, previousHeadAtom);
                        }
                    }
                    visitedHeadAtom.add(atom);
                }
            }
        }
        for (Rule fact : this.getProgram().getFacts(true)) {
            LinkedList<Atom> visitedHeadAtom = new LinkedList<Atom>();
            Iterator iterator = fact.head().iterator();
            while (iterator.hasNext()) {
                String atomId;
                Atom headAtom;
                Atom atom = headAtom = (Atom)iterator.next();
                if (isProgramGround) {
                    atomId = headAtom.toString();
                } else {
                    atom = CompleteGraph.generateAtom(headAtom.getName());
                    atomId = atom.getName();
                }
                if (!atomMap.containsKey(atomId)) {
                    atomMap.put(atomId, atom);
                }
                if (!this.containsVertex(atom = (Atom)atomMap.get(atomId))) {
                    this.addVertex(atom);
                }
                for (Atom previousHeadAtom : visitedHeadAtom) {
                    if (!this.containsPositiveEdge(previousHeadAtom, atom)) {
                        this.addPositiveEdge(previousHeadAtom, atom);
                    }
                    if (this.containsPositiveEdge(atom, previousHeadAtom)) continue;
                    this.addPositiveEdge(atom, previousHeadAtom);
                }
                visitedHeadAtom.add(atom);
            }
        }
    }

    private void addPositiveAggregateEdge(Atom source, Atom dest) {
        if (this.positiveAggregateConnections.containsKey(source)) {
            this.positiveAggregateConnections.get(source).add(dest);
        }
    }

    private void addNegativeAggregateEdge(Atom source, Atom dest) {
        if (this.negativeAggregateConnections.containsKey(source)) {
            this.negativeAggregateConnections.get(source).add(dest);
        }
    }

    private boolean containsPositiveEdge(Atom source, Atom dest) {
        if (this.positiveConnections.containsKey(source)) {
            return this.positiveConnections.get(source).contains(dest);
        }
        return false;
    }

    private boolean containsNegativeEdge(Atom source, Atom dest) {
        if (this.negativeConnections.containsKey(source)) {
            return this.negativeConnections.get(source).contains(dest);
        }
        return false;
    }

    private void addPositiveEdge(Atom source, Atom dest) {
        if (this.positiveConnections.containsKey(source)) {
            this.positiveConnections.get(source).add(dest);
        }
    }

    public boolean hasPositiveEdge(String sourceAtomName, String destAtomName) {
        Atom sourceAtom = null;
        Atom destAtom = null;
        for (Atom a : this.positiveConnections.keySet()) {
            if (a.getName().equals(sourceAtomName)) {
                sourceAtom = a;
            }
            if (a.getName().equals(destAtomName)) {
                destAtom = a;
            }
            for (Atom atom : this.positiveConnections.get(a)) {
                if (atom.getName().equals(sourceAtomName)) {
                    sourceAtom = atom;
                }
                if (!atom.getName().equals(destAtomName)) continue;
                destAtom = atom;
            }
        }
        if (sourceAtom != null && destAtom != null) {
            return this.hasPositiveEdge(sourceAtom, destAtom);
        }
        return false;
    }

    public boolean hasAggregatePositiveEdge(String sourceAtomName, String destAtomName) {
        Atom sourceAtom = null;
        Atom destAtom = null;
        for (Atom a : this.positiveAggregateConnections.keySet()) {
            if (a.getName().equals(sourceAtomName)) {
                sourceAtom = a;
            }
            if (a.getName().equals(destAtomName)) {
                destAtom = a;
            }
            for (Atom atom : this.positiveAggregateConnections.get(a)) {
                if (atom.getName().equals(sourceAtomName)) {
                    sourceAtom = atom;
                }
                if (!atom.getName().equals(destAtomName)) continue;
                destAtom = atom;
            }
        }
        if (sourceAtom != null && destAtom != null) {
            return this.hasAggregatePositiveEdge(sourceAtom, destAtom);
        }
        return false;
    }

    public boolean hasAggregateNegativeEdge(String sourceAtomName, String destAtomName) {
        Atom sourceAtom = null;
        Atom destAtom = null;
        for (Atom a : this.negativeAggregateConnections.keySet()) {
            if (a.getName().equals(sourceAtomName)) {
                sourceAtom = a;
            }
            if (a.getName().equals(destAtomName)) {
                destAtom = a;
            }
            for (Atom atom : this.negativeAggregateConnections.get(a)) {
                if (atom.getName().equals(sourceAtomName)) {
                    sourceAtom = atom;
                }
                if (!atom.getName().equals(destAtomName)) continue;
                destAtom = atom;
            }
        }
        if (sourceAtom != null && destAtom != null) {
            return this.hasAggregateNegativeEdge(sourceAtom, destAtom);
        }
        return false;
    }

    private void addNegativeEdge(Atom source, Atom dest) {
        if (this.negativeConnections.containsKey(source)) {
            this.negativeConnections.get(source).add(dest);
        }
    }

    private boolean containsVertex(Atom atom) {
        return this.getVertices().contains(atom);
    }

    private void addVertex(Atom atom) {
        if (!this.getVertices().contains(atom)) {
            this.positiveConnections.put(atom, new ArrayList());
            this.negativeConnections.put(atom, new ArrayList());
            this.positiveAggregateConnections.put(atom, new ArrayList());
            this.negativeAggregateConnections.put(atom, new ArrayList());
        }
    }

    private static Atom generateAtom(String name) {
        return new NormalAtom(name);
    }

    @Override
    public void refresh() {
        this.positiveConnections = new HashMap();
        this.negativeConnections = new HashMap();
        this.positiveAggregateConnections = new HashMap();
        this.negativeAggregateConnections = new HashMap();
        this.buildGraph();
    }

    @Override
    public boolean hasPositiveEdge(Atom sourceAtom, Atom targetAtom) {
        return this.positiveConnections.containsKey(sourceAtom) && this.positiveConnections.get(sourceAtom).contains(targetAtom);
    }

    @Override
    public boolean hasAggregatePositiveEdge(Atom source, Atom dest) {
        if (this.positiveAggregateConnections.containsKey(source)) {
            return this.positiveAggregateConnections.get(source).contains(dest);
        }
        return false;
    }

    @Override
    public boolean hasAggregateNegativeEdge(Object source, Object dest) {
        if (this.negativeAggregateConnections.containsKey(source)) {
            return this.negativeAggregateConnections.get(source).contains(dest);
        }
        return false;
    }

    @Override
    public boolean hasNegativeEdge(Object sourceAtom, Object targetAtom) {
        return this.negativeConnections.containsKey(sourceAtom) && this.negativeConnections.get(sourceAtom).contains(targetAtom);
    }

    public boolean hasNegativeEdge(String sourceAtomName, String destAtomName) {
        Atom sourceAtom = null;
        Atom destAtom = null;
        for (Atom a : this.negativeConnections.keySet()) {
            if (a.getName().equals(sourceAtomName)) {
                sourceAtom = a;
            }
            if (a.getName().equals(destAtomName)) {
                destAtom = a;
            }
            for (Atom atom : this.negativeConnections.get(a)) {
                if (atom.getName().equals(sourceAtomName)) {
                    sourceAtom = atom;
                }
                if (!atom.getName().equals(destAtomName)) continue;
                destAtom = atom;
            }
        }
        if (sourceAtom != null && destAtom != null) {
            return this.hasNegativeEdge(sourceAtom, destAtom);
        }
        return false;
    }

    @Override
    public boolean isStratified() {
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(program);
        return graph.isStratified();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        ArrayList<Atom> nodes = new ArrayList<Atom>();
        nodes.addAll(this.positiveConnections.keySet());
        for (Atom a : this.negativeConnections.keySet()) {
            if (nodes.contains(a)) continue;
            nodes.add(a);
        }
        for (Atom source : nodes) {
            boolean init = false;
            buffer.append(source.toString());
            if (this.positiveConnections.containsKey(source) && !this.positiveConnections.get(source).isEmpty()) {
                buffer.append(" -> (");
                init = true;
                for (Atom dest : this.positiveConnections.get(source)) {
                    buffer.append(String.valueOf(dest.toString()) + ".");
                }
            }
            if (this.negativeConnections.containsKey(source) && !this.negativeConnections.get(source).isEmpty()) {
                if (!init) {
                    buffer.append(" -> (");
                    init = true;
                }
                for (Atom dest : this.negativeConnections.get(source)) {
                    buffer.append("*" + dest.toString() + ".");
                }
            }
            if (init) {
                buffer.append(")");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public List<Atom> getVertices() {
        ArrayList<Atom> nodes = new ArrayList<Atom>();
        nodes.addAll(this.positiveConnections.keySet());
        for (Atom a : this.negativeConnections.keySet()) {
            if (nodes.contains(a)) continue;
            nodes.add(a);
        }
        for (Atom a : this.positiveAggregateConnections.keySet()) {
            if (nodes.contains(a)) continue;
            nodes.add(a);
        }
        for (Atom a : this.negativeAggregateConnections.keySet()) {
            if (nodes.contains(a)) continue;
            nodes.add(a);
        }
        return nodes;
    }

    public Atom getVertex(String atomName) {
        for (Atom atom : this.getVertices()) {
            if (!atom.getName().equals(atomName)) continue;
            return atom;
        }
        return null;
    }

    @Override
    public List<Atom> getPositiveConnectionsWithNode(Object source) {
        return this.positiveConnections.get(source);
    }

    public List<Atom> getAggregatePositiveConnectionsWithNode(Atom source) {
        return this.positiveAggregateConnections.get(source);
    }

    @Override
    public List<Atom> getNegativeConnectionsWithNode(Object source) {
        return this.negativeConnections.get(source);
    }

    public List<Atom> getAggregateNegativeConnectionsWithNode(Atom source) {
        return this.negativeAggregateConnections.get(source);
    }

    @Override
    public void removeVertex(Atom vertex) {
        this.positiveConnections.remove(vertex);
        this.positiveAggregateConnections.remove(vertex);
        this.negativeConnections.remove(vertex);
        this.negativeAggregateConnections.remove(vertex);
    }
}

