/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.util.dependencygraph;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.wrapper.util.dependencygraph.CompleteGraph;
import it.unical.mat.wrapper.util.dependencygraph.PositiveGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.util.List;

public abstract class DependencyGraph {
    static IndexedProgram program;
    boolean showDisjunctionLinks = false;
    boolean ground = false;

    public static DependencyGraph createPositiveGraph(Program p) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new PositiveGraph(program);
    }

    public static DependencyGraph createPositiveGraph(boolean ground, Program p, boolean showDisjunctionConnections) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new PositiveGraph(ground, program, showDisjunctionConnections);
    }

    public static DependencyGraph createCompleteGraph(Program p) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new CompleteGraph(program);
    }

    public static DependencyGraph createCompleteGraph(Program p, boolean showDisjunctionConnections) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new CompleteGraph(program, showDisjunctionConnections);
    }

    public static DependencyGraph createStronglyConnectedComponentGraph(Program p) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new StronglyConnectedComponentGraph(program);
    }

    public static DependencyGraph createPositiveStronglyConnectedComponentGraph(Program p) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new StronglyConnectedComponentGraph(true, true, program);
    }

    public static DependencyGraph createStronglyConnectedComponentGraph(Program p, boolean showDisjunctionConnections) {
        program = !(p instanceof IndexedProgram) ? new IndexedProgram(p) : (IndexedProgram)p;
        return new StronglyConnectedComponentGraph(program, showDisjunctionConnections);
    }

    public abstract void refresh();

    public IndexedProgram getProgram() {
        return program;
    }

    public abstract boolean hasPositiveEdge(Atom var1, Atom var2);

    public abstract boolean hasAggregatePositiveEdge(Atom var1, Atom var2);

    public abstract boolean isStratified();

    public abstract void removeVertex(Atom var1);

    public void setShowDisjunctionLinks(boolean showDisjunctionLinks) {
        this.showDisjunctionLinks = showDisjunctionLinks;
    }

    public boolean isShowDisjunctionLinks() {
        return this.showDisjunctionLinks;
    }

    public boolean isGround() {
        return this.ground;
    }

    public void setGround(boolean ground) {
        this.ground = ground;
    }

    public abstract List getVertices();

    public abstract List getPositiveConnectionsWithNode(Object var1);

    public abstract List getNegativeConnectionsWithNode(Object var1);

    public abstract boolean hasNegativeEdge(Object var1, Object var2);

    public abstract boolean hasAggregateNegativeEdge(Object var1, Object var2);
}

