/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.util.dependencygraph;

import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PositiveGraph
extends DependencyGraph {
    HashMap<Atom, List<Atom>> positiveConnections = new HashMap();
    HashMap<Atom, List<Atom>> positiveAggregateConnections = new HashMap();

    public PositiveGraph(IndexedProgram program) {
        this.buildGraph();
    }

    public PositiveGraph(boolean ground, IndexedProgram program) {
        this.setGround(ground);
    }

    public PositiveGraph(IndexedProgram program, boolean showDisjunctionLinks) {
        this.setShowDisjunctionLinks(showDisjunctionLinks);
        this.buildGraph();
    }

    public PositiveGraph(boolean ground, IndexedProgram program, boolean showDisjunctionLinks) {
        this.setShowDisjunctionLinks(showDisjunctionLinks);
        this.setGround(ground);
        this.buildGraph();
    }

    private void buildGraph() {
        boolean isProgramGround = this.ground;
        HashMap<String, Atom> atomMap = new HashMap<String, Atom>();
        ArrayList<String> nodesNamesBody = new ArrayList<String>();
        if (isProgramGround) {
            nodesNamesBody.addAll(this.getProgram().getBodyRulesAtomMap().keySet());
        } else {
            nodesNamesBody.addAll(this.getProgram().getBodyRulesPredicateMap().keySet());
        }
        for (String atomId : nodesNamesBody) {
            Atom bodyAtom;
            if (!atomMap.containsKey(atomId)) {
                Atom atom = isProgramGround ? this.getProgram().getAtomMap().get(atomId) : PositiveGraph.generateAtom(atomId);
                atomMap.put(atomId, atom);
            }
            if (!this.containsVertex(bodyAtom = (Atom)atomMap.get(atomId))) {
                this.addVertex(bodyAtom);
            }
            List<Rule> rulesWithAtomInBody = isProgramGround ? this.getProgram().getBodyRulesAtomMap().get(atomId) : this.getProgram().getBodyRulesPredicateMap().get(atomId);
            for (Rule rule : rulesWithAtomInBody) {
                boolean isPositive = false;
                boolean inAggregate = false;
                for (Literal literal : rule.getBody()) {
                    if (literal.isPositive()) {
                        boolean literalGround = literal.getAtom().isGround();
                        if (literalGround && isProgramGround) {
                            if (literal.getAtom().toString().equals(atomId)) {
                                isPositive = true;
                            }
                        } else if (literal.getAtom().getName().equals(atomId)) {
                            isPositive = true;
                        }
                    }
                    if (!(literal.getAtom() instanceof AggregateAtom)) continue;
                    for (Literal aggrLiteral : ((AggregateAtom)literal.getAtom()).getBody()) {
                        Atom atom;
                        if (!aggrLiteral.isPositive() || !(atom = aggrLiteral.getAtom()).getName().equals(atomId)) continue;
                        inAggregate = true;
                    }
                }
                if (rule.isFact() || rule.isConstraint()) continue;
                LinkedList<Atom> visitedHeadAtom = new LinkedList<Atom>();
                Iterator iterator = rule.head().iterator();
                while (iterator.hasNext()) {
                    String atomId2;
                    Atom headAtom;
                    Atom atom = headAtom = (Atom)iterator.next();
                    if (isProgramGround) {
                        atomId2 = atom.toString();
                    } else {
                        atom = PositiveGraph.generateAtom(headAtom.getName());
                        atomId2 = headAtom.getName();
                    }
                    if (!atomMap.containsKey(atomId2)) {
                        atomMap.put(atomId2, atom);
                    }
                    if (!this.containsVertex(atom = (Atom)atomMap.get(atomId2))) {
                        this.addVertex(atom);
                    }
                    if (isPositive && !this.hasPositiveEdge(bodyAtom, atom)) {
                        this.addEdge(bodyAtom, atom);
                    }
                    if (inAggregate && !this.hasAggregatePositiveEdge(bodyAtom, atom)) {
                        this.addAggregateEdge(bodyAtom, atom);
                    }
                    if (this.isShowDisjunctionLinks()) {
                        for (Atom previousHeadAtom : visitedHeadAtom) {
                            if (!this.hasPositiveEdge(previousHeadAtom, atom)) {
                                this.addEdge(previousHeadAtom, atom);
                            }
                            if (this.hasPositiveEdge(atom, previousHeadAtom)) continue;
                            this.addEdge(atom, previousHeadAtom);
                        }
                    }
                    visitedHeadAtom.add(atom);
                }
            }
        }
        for (Rule fact : this.getProgram().getFacts(true)) {
            LinkedList<Atom> visitedHeadAtom = new LinkedList<Atom>();
            Iterator iterator = fact.head().iterator();
            while (iterator.hasNext()) {
                String atomId;
                Atom headAtom;
                Atom atom = headAtom = (Atom)iterator.next();
                if (isProgramGround) {
                    atomId = headAtom.toString();
                } else {
                    atom = PositiveGraph.generateAtom(headAtom.getName());
                    atomId = atom.getName();
                }
                if (!atomMap.containsKey(atomId)) {
                    atomMap.put(atomId, atom);
                }
                if (!this.containsVertex(atom = (Atom)atomMap.get(atomId))) {
                    this.addVertex(atom);
                }
                for (Atom previousHeadAtom : visitedHeadAtom) {
                    if (!this.hasPositiveEdge(previousHeadAtom, atom)) {
                        this.addEdge(previousHeadAtom, atom);
                    }
                    if (this.hasPositiveEdge(atom, previousHeadAtom)) continue;
                    this.addEdge(atom, previousHeadAtom);
                }
                visitedHeadAtom.add(atom);
            }
        }
    }

    @Override
    public boolean hasPositiveEdge(Atom source, Atom dest) {
        if (this.positiveConnections.containsKey(source)) {
            return this.positiveConnections.get(source).contains(dest);
        }
        return false;
    }

    @Override
    public boolean hasAggregatePositiveEdge(Atom source, Atom dest) {
        if (this.positiveAggregateConnections.containsKey(source)) {
            return this.positiveAggregateConnections.get(source).contains(dest);
        }
        return false;
    }

    public boolean hasAggregateNegativeEdge(Atom source, Atom dest) {
        if (this.positiveAggregateConnections.containsKey(source)) {
            return this.positiveAggregateConnections.get(source).contains(dest);
        }
        return false;
    }

    public boolean hasPositiveEdge(String sourceAtomName, String destAtomName) {
        Atom sourceAtom = null;
        Atom destAtom = null;
        for (Atom a : this.positiveConnections.keySet()) {
            if (a.getName().equals(sourceAtomName)) {
                sourceAtom = a;
            }
            if (a.getName().equals(destAtomName)) {
                destAtom = a;
            }
            for (Atom atom : this.positiveConnections.get(a)) {
                if (atom.getName().equals(sourceAtomName)) {
                    sourceAtom = atom;
                }
                if (!atom.getName().equals(destAtomName)) continue;
                destAtom = atom;
            }
        }
        if (sourceAtom != null && destAtom != null) {
            return this.hasPositiveEdge(sourceAtom, destAtom);
        }
        return false;
    }

    public boolean hasAggregatePositiveEdge(String sourceAtomName, String destAtomName) {
        Atom sourceAtom = null;
        Atom destAtom = null;
        for (Atom a : this.positiveAggregateConnections.keySet()) {
            if (a.getName().equals(sourceAtomName)) {
                sourceAtom = a;
            }
            if (a.getName().equals(destAtomName)) {
                destAtom = a;
            }
            for (Atom atom : this.positiveAggregateConnections.get(a)) {
                if (atom.getName().equals(sourceAtomName)) {
                    sourceAtom = atom;
                }
                if (!atom.getName().equals(destAtomName)) continue;
                destAtom = atom;
            }
        }
        if (sourceAtom != null && destAtom != null) {
            return this.hasAggregatePositiveEdge(sourceAtom, destAtom);
        }
        return false;
    }

    private void addEdge(Atom source, Atom dest) {
        if (this.positiveConnections.containsKey(source)) {
            this.positiveConnections.get(source).add(dest);
        }
    }

    private void addAggregateEdge(Atom source, Atom dest) {
        if (this.positiveAggregateConnections.containsKey(source)) {
            this.positiveAggregateConnections.get(source).add(dest);
        }
    }

    private boolean containsVertex(Atom atom) {
        return this.getVertices().contains(atom);
    }

    private void addVertex(Atom atom) {
        this.positiveConnections.put(atom, new ArrayList());
        this.positiveAggregateConnections.put(atom, new ArrayList());
    }

    private static Atom generateAtom(String name) {
        return new NormalAtom(name);
    }

    @Override
    public void refresh() {
        this.positiveConnections = new HashMap();
        this.positiveAggregateConnections = new HashMap();
        this.buildGraph();
    }

    @Override
    public boolean isStratified() {
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(program);
        return graph.isStratified();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Atom source : this.positiveConnections.keySet()) {
            buffer.append(source.toString());
            if (!this.positiveConnections.get(source).isEmpty()) {
                buffer.append(" -> (");
                for (Atom dest : this.positiveConnections.get(source)) {
                    buffer.append(String.valueOf(dest.toString()) + ".");
                }
                buffer.append(")");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public List<Atom> getVertices() {
        ArrayList<Atom> nodes = new ArrayList<Atom>();
        nodes.addAll(this.positiveConnections.keySet());
        for (Atom a : this.positiveAggregateConnections.keySet()) {
            if (nodes.contains(a)) continue;
            nodes.add(a);
        }
        return nodes;
    }

    public List<Atom> getPositiveConnectionsWithNode(Atom source) {
        return this.positiveConnections.get(source);
    }

    public List<Atom> getAggregatePositiveConnectionsWithNode(Atom source) {
        return this.positiveAggregateConnections.get(source);
    }

    @Override
    public void removeVertex(Atom vertex) {
        this.positiveConnections.remove(vertex);
        this.positiveAggregateConnections.remove(vertex);
    }

    @Override
    public List getPositiveConnectionsWithNode(Object source) {
        return this.positiveConnections.get(source);
    }

    @Override
    public List getNegativeConnectionsWithNode(Object source) {
        return null;
    }

    @Override
    public boolean hasNegativeEdge(Object sourceAtom, Object targetAtom) {
        return false;
    }

    @Override
    public boolean hasAggregateNegativeEdge(Object source, Object dest) {
        return false;
    }
}

