/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.util.parseModel;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.Predicate;
import it.unical.mat.wrapper.exception.NoModelParseException;
import it.unical.mat.wrapper.util.parseModel.ModelProductBuilder;
import it.unical.mat.wrapper.util.parseModel.ParsedModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ParserModel {
    public static Model convertInModel(Program program) throws ParseException, NoModelParseException {
        ParsedModel model = new ParsedModel();
        for (Expression expr : program) {
            model.add(expr);
            if (!model.isNoModel()) continue;
            throw new NoModelParseException();
        }
        return model;
    }

    public static List<Atom> convertInAtoms(Model model) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        int cursor = model.getCursor();
        model.beforeFirst();
        while (model.hasMorePredicates()) {
            Predicate pred = model.nextPredicate();
            pred.beforeFirst();
            while (pred.hasMoreLiterals()) {
                Literal lit = pred.nextLiteral();
                atoms.add(lit.getAtom());
            }
        }
        model.absolute(cursor + 1);
        return atoms;
    }

    public static Program convertInProgram(Model model) {
        int cursor = model.getCursor();
        Program program = new Program();
        model.beforeFirst();
        while (model.hasMorePredicates()) {
            Predicate pred = model.nextPredicate();
            pred.beforeFirst();
            while (pred.hasMoreLiterals()) {
                Literal lit = pred.nextLiteral();
                program.add(new Rule(new Disjunction(lit.getAtom())));
            }
        }
        model.absolute(cursor + 1);
        return program;
    }

    public static Model parse(InputStream stream) throws ParseException, NoModelParseException {
        ParsedModel model = null;
        if (stream != null) {
            Director d = new Director(stream);
            ModelProductBuilder b = new ModelProductBuilder();
            b.setTrace(false);
            d.configureBuilder(b);
            d.start();
            model = (ParsedModel)b.getProductHandler();
            if (model.isNoModel()) {
                throw new NoModelParseException();
            }
            return model;
        }
        return null;
    }

    public static Model parse(File file) throws FileNotFoundException, ParseException, NoModelParseException {
        return ParserModel.parse(new FileInputStream(file));
    }
}

