/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.testing.InputTest;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.TestInvocation;
import it.unical.mat.dlv.testing.TestSuite;
import it.unical.mat.dlv.testing.execution.TestSuiteExecutor;
import it.unical.mat.wrapper.exception.FileNotFoundInTestSuiteException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AssertTestingTest {
    TestSuite testSuite;

    @Before
    public void initializeTest() throws FileNotFoundException {
        this.testSuite = new TestSuite(new TestInvocation("invoc", "C:/Users/Kristian/Documents/dottorato/programmi/DLV/dlv.mingw.exe", null));
    }

    @Test
    public void TestGlobalAssertPassed() throws Exception, FileNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. d(2).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        testCase1.addInputTest(new InputTest(this.getProgram("d(1).")));
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("d(1). d(2)."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestSuite = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestSuite.getExpectedOutput().setContent(this.getProgram("d(2)."));
        this.testSuite.addGlobalAssert(assert1TestSuite);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void TestGlobalAssertFailed() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. d(2).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        testCase1.addInputTest(new InputTest(this.getProgram("d(1).")));
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("d(1). d(2)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d(1). d(2)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestGlobalFileInput() throws Exception {
        InputTest inputTest = new InputTest(false);
        String programCode = "c(1).b(X) :- a(X), c(X). a(2).";
        File file = new File("files/fileA.dl");
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println(programCode);
        printWriter.flush();
        printWriter.close();
        inputTest.getInputContent().setContent(file.getAbsolutePath());
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        testCase1.addInputTest(new InputTest(this.getProgram("a(1).")));
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("b(1). a(1)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assertGlobal = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assertGlobal.getExpectedOutput().setContent(this.getProgram("b(1)."));
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addGlobalAssert(assertGlobal);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertCautiouslyTrue() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertCautiouslyTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertCautiouslyTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertTrueInAtMost() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlPi\u00ef\u00bf\u00bd");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtMost", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtMost", 1);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("c."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertTrueInAtLeast() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmeno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("b."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast", 2);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertBravelyTrue() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmenoUno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertBravelyTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertBravelyTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertTrueIn() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inEsattamente");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 1);
        assert1Global.getExpectedOutput().setContent(this.getProgram("c."));
        this.testSuite.addGlobalAssert(assert1Global);
        it.unical.mat.dlv.testing.Assert assert2Global = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 2);
        assert2Global.getExpectedOutput().setContent(this.getProgram("a."));
        this.testSuite.addGlobalAssert(assert2Global);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertCautiouslyFalse() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTuttiFalse");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("d."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertCautiouslyFalse");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertFalseInAtMost() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlPi\u00ef\u00bf\u00bd");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtMost", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtMost", 1);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertFalseInAtLeast() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmeno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtLeast", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtLeast", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("c."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtLeast", 2);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertBravelyFalse() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmenoUno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertBravelyFalse");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("d."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertBravelyFalse");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("c."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertFalseIn() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. a v b :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inEsattamenteNon");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("d."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 3);
        assert1Global.getExpectedOutput().setContent(this.getProgram("c."));
        this.testSuite.addGlobalAssert(assert1Global);
        it.unical.mat.dlv.testing.Assert assert2Global = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 1);
        assert2Global.getExpectedOutput().setContent(this.getProgram("d."));
        this.testSuite.addGlobalAssert(assert2Global);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertCautiouslyTrueNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertCautiouslyTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertCautiouslyTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertTrueInAtMostNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlPiu");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtMost", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtMost", 1);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("c(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertTrueInAtLeastNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmeno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("b(X)."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast", 2);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertBravelyTrueNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmenoUno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertBravelyTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertBravelyTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertTrueInNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inEsattamente");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a(X)."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 1);
        assert1Global.getExpectedOutput().setContent(this.getProgram("c(X)."));
        this.testSuite.addGlobalAssert(assert1Global);
        it.unical.mat.dlv.testing.Assert assert2Global = new it.unical.mat.dlv.testing.Assert("assertTrueIn", 2);
        assert2Global.getExpectedOutput().setContent(this.getProgram("a(X)."));
        this.testSuite.addGlobalAssert(assert2Global);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertCautiouslyFalseNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTuttiFalse");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("d(X).e(1)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertCautiouslyFalse");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertFalseInAtMostNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlPi\u00ef\u00bf\u00bd");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtMost", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtMost", 1);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertFalseInAtLeastNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmeno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtLeast", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtLeast", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("c(X)."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertFalseInAtLeast", 2);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("d(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertBravelyFalseNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inAlmenoUno");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertBravelyFalse");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("d(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertBravelyFalse");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("c(X)."));
        this.testSuite.addGlobalAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertFalseInNonGround() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inEsattamenteNon");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 2);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("d(X)."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 3);
        assert1Global.getExpectedOutput().setContent(this.getProgram("c(X)."));
        this.testSuite.addGlobalAssert(assert1Global);
        it.unical.mat.dlv.testing.Assert assert2Global = new it.unical.mat.dlv.testing.Assert("assertFalseIn", 1);
        assert2Global.getExpectedOutput().setContent(this.getProgram("d(X)."));
        this.testSuite.addGlobalAssert(assert2Global);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertConstraint() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("soddisfattiInTuttiOk");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertConstraint");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram(":- d(X)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertConstraint");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram(":- c(2)."));
        testCase1.addAssert(assert2TestCase1);
        TestCase testCase2 = new TestCase("soddisfattiInTuttiFallito");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertConstraint");
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram(":- c(X), a(X), not b(X)."));
        testCase2.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertConstraint");
        assert1Global.getExpectedOutput().setContent(this.getProgram(":-a(X)."));
        this.testSuite.addGlobalAssert(assert1Global);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertConstraintInAtLeast() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) v d(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("soddisfattiInAlmeno2");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtLeast", 2);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram(":- a(X)."));
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("soddisfattiInAlmeno3");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtLeast", 3);
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram(":- d(X)."));
        testCase2.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtLeast", 1);
        assert1Global.getExpectedOutput().setContent(this.getProgram(":-a(X)."));
        this.testSuite.addGlobalAssert(assert1Global);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertConstraintInAtMost() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) v d(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("soddisfattiInAlPiu2");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtMost", 2);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram(":- a(X)."));
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("soddisfattiInAlPiu1");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtMost", 1);
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram(":- d(X)."));
        testCase2.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtMost", 1);
        assert1Global.getExpectedOutput().setContent(this.getProgram(":-a(X)."));
        this.testSuite.addGlobalAssert(assert1Global);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertConstraintIn() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). a(1) v b(1) v d(1) :- c(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("soddisfattiIn2");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertConstraintIn", 2);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram(":- a(X)."));
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("soddisfattiIn1");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertConstraintIn", 1);
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram(":- a(X)."));
        testCase2.addAssert(assert1TestCase2);
        TestCase testCase3 = new TestCase("soddisfattiIn3");
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertConstraintIn", 3);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram(":- a(X)."));
        testCase3.addAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertConstraintAggregates() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1). c(2). a(X) v b(X) :- c(X).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("soddisfatti");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtLeast", 1);
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram(":- #count{X: a(X)} = 0."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertConstraintIn", 1);
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram(":- #count{X: a(X)} > 0."));
        testCase1.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertConstraintInAtMost", 1);
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram(":- #count{X: a(X)} < 2."));
        testCase1.addAssert(assert1TestCase3);
        it.unical.mat.dlv.testing.Assert assert1TestCase4 = new it.unical.mat.dlv.testing.Assert("assertConstraint");
        assert1TestCase4.getExpectedOutput().setContent(this.getProgram(":- #count{X: a(X)} > 2."));
        testCase1.addAssert(assert1TestCase4);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertBestModelCost() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "employee(a). employee(b). employee(c). employee(d). employee(e).know(a,b). know(b,c). know(c,d). know(d,e).same_skill(a,b).married(c,d).member(X,p1) v member(X,p2) :- employee(X).:~ member(X,P), member(Y,P), X != Y, not know(X,Y). [1:1]:~ member(X,P), member(Y,P), X != Y, married(X,Y). [1:2]:~ member(X,P), member(Y,P), X != Y, same_skill(X,Y). [1:2]";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("cost");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert(6);
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert(0);
        testCase1.addAssert(assert2TestCase1);
        TestCase testCase2 = new TestCase("costLevel");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert(6, 1);
        testCase2.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert2TestCase2 = new it.unical.mat.dlv.testing.Assert(0, 2);
        testCase2.addAssert(assert2TestCase1);
        TestCase testCase3 = new TestCase("costFailed");
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert(7);
        testCase3.addAssert(assert1TestCase3);
        TestCase testCase4 = new TestCase("costLevelFailed");
        it.unical.mat.dlv.testing.Assert assert1TestCase4 = new it.unical.mat.dlv.testing.Assert(6, 3);
        testCase4.addAssert(assert1TestCase4);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        this.testSuite.addTestCase(testCase4);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(3).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertNumberModels() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "a. b. c. d :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("OneModelOk");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertNumberModels", 1);
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("TwoModelsOk");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertNumberModels", 2);
        InputTest inputTest2 = new InputTest(true);
        programCode = "e v f :- d.";
        inputTest2.getInputContent().setContent(this.getProgram(programCode));
        testCase2.addInputTest(inputTest2);
        testCase2.addAssert(assert1TestCase2);
        TestCase testCase3 = new TestCase("OneModelFail");
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertNumberModels", 1);
        InputTest inputTest3 = new InputTest(true);
        programCode = "e v f :- d.";
        inputTest3.getInputContent().setContent(this.getProgram(programCode));
        testCase3.addInputTest(inputTest3);
        testCase3.addAssert(assert1TestCase3);
        TestCase testCase4 = new TestCase("TwoModelsFail");
        it.unical.mat.dlv.testing.Assert assert1TestCase4 = new it.unical.mat.dlv.testing.Assert("assertNumberModels", 2);
        testCase4.addAssert(assert1TestCase4);
        TestCase testCase5 = new TestCase("NoModelsOk");
        it.unical.mat.dlv.testing.Assert assert1TestCase5 = new it.unical.mat.dlv.testing.Assert("assertNoModels");
        InputTest inputTest5 = new InputTest(true);
        programCode = ":- a, b.";
        inputTest5.getInputContent().setContent(this.getProgram(programCode));
        testCase5.addInputTest(inputTest5);
        testCase5.addAssert(assert1TestCase5);
        TestCase testCase6 = new TestCase("NoModelsFail");
        it.unical.mat.dlv.testing.Assert assert1TestCase6 = new it.unical.mat.dlv.testing.Assert("assertNoModels");
        testCase6.addAssert(assert1TestCase6);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        this.testSuite.addTestCase(testCase4);
        this.testSuite.addTestCase(testCase5);
        this.testSuite.addTestCase(testCase6);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertNumberModels", 2);
        this.testSuite.addGlobalAssert(assert1Global);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(3).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(4).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(5).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void TestAssertNumberModelsGlobal() throws Exception {
        InputTest inputTest = new InputTest(true);
        String programCode = "a. b. c. d :- c. :- a, b.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        it.unical.mat.dlv.testing.Assert assert1Global = new it.unical.mat.dlv.testing.Assert("assertNoModels");
        this.testSuite.addGlobalAssert(assert1Global);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

