/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Comment;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.LazyProgram;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.SimpleTerm;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class LazyProgramTest {
    @Test
    public void factsTest() throws UnsupportedEncodingException, ParseException {
        String code = "a(1,1). a(1,2). a(1,3).a(1,2,5).a(5,6,7).a(7,10). a(1). b(1). b(2). b(3).";
        Program p = this.getProgram(code);
        System.out.println(p.toString());
        Assert.assertTrue((p.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals(p.get(0), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1"), new SimpleTerm("1")))))));
        Assert.assertEquals(p.get(1), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1"), new SimpleTerm("2"), new SimpleTerm("5")))))));
        Assert.assertEquals(p.get(2), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1")))))));
        Assert.assertEquals(p.get(3), (Object)new Rule(new Disjunction(new NormalAtom("b", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1")))))));
    }

    @Test
    public void factsAndRulesTest() throws UnsupportedEncodingException, ParseException {
        String code = "a(1,1). a(1,2). a(1,3).a(1,2,5).a(5,6,7).a(X) :- b(X).a(X) :- b(X).a(7,10). a(1). :- b(X).b(1). b(2). b(3).";
        Program p = this.getProgram(code);
        System.out.println(p.toString());
        Assert.assertTrue((p.size() == 7 ? 1 : 0) != 0);
        Assert.assertEquals(p.get(0), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1"), new SimpleTerm("1")))))));
        Assert.assertEquals(p.get(1), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1"), new SimpleTerm("2"), new SimpleTerm("5")))))));
        Assert.assertFalse((boolean)((Rule)p.get(2)).isFact());
        Assert.assertFalse((boolean)((Rule)p.get(3)).isFact());
        Assert.assertEquals(p.get(4), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1")))))));
        Assert.assertTrue((boolean)((Rule)p.get(5)).isConstraint());
        Assert.assertEquals(p.get(6), (Object)new Rule(new Disjunction(new NormalAtom("b", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1")))))));
    }

    @Test
    public void commentsTest() throws UnsupportedEncodingException, ParseException {
        String code = "a(1,1). a(1,2). a(1,3).% ciccio \n% pasticcio \n% @schema \n% miao \n";
        Program p = this.getProgram(code);
        System.out.println(p.toString());
        Assert.assertTrue((p.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals(p.get(0), (Object)new Rule(new Disjunction(new NormalAtom("a", new ArrayList<SimpleTerm>(Arrays.asList(new SimpleTerm("1"), new SimpleTerm("1")))))));
        Assert.assertEquals(p.get(1), (Object)new Comment("%@schema"));
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        builder.configureProductHandler(new LazyProgram());
        director.configureBuilder(builder);
        director.setParseAnnotation(true);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

