/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Conjunction;
import it.unical.mat.dlv.program.DLPFunction;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.wrapper.exception.BadDLPFunctionCompositionException;
import it.unical.mat.wrapper.exception.BadInputAtomInDLPFunctionException;
import it.unical.mat.wrapper.exception.BadSplittingSetException;
import it.unical.mat.wrapper.exception.NotMutuallyIndependentDLPFunctionsException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ModularityTest {
    @Test
    public void splittingSetTest() throws UnsupportedEncodingException, ParseException {
        String p = "c v d :- a.a :- b.e :- b, f, k.f :- e.k :- e.";
        Program program = this.getProgram(p);
        HashSet<Atom> atoms = new HashSet<Atom>();
        atoms.add(new NormalAtom("c"));
        Set<Atom> splittingSet = new IndexedProgram(program).getSplittingSet(atoms);
        HashSet<NormalAtom> expectedSplit = new HashSet<NormalAtom>();
        expectedSplit.add(new NormalAtom("c"));
        expectedSplit.add(new NormalAtom("d"));
        expectedSplit.add(new NormalAtom("a"));
        expectedSplit.add(new NormalAtom("b"));
        Assert.assertEquals((long)splittingSet.size(), (long)4L);
        Assert.assertEquals(splittingSet, expectedSplit);
        atoms.add(new NormalAtom("e"));
        splittingSet = new IndexedProgram(program).getSplittingSet(atoms);
        expectedSplit.add(new NormalAtom("e"));
        expectedSplit.add(new NormalAtom("f"));
        expectedSplit.add(new NormalAtom("k"));
        Assert.assertEquals((long)splittingSet.size(), (long)7L);
        Assert.assertEquals(splittingSet, expectedSplit);
        atoms.remove(new NormalAtom("c"));
        program.add(new Rule(new Disjunction(new NormalAtom("k")), new Conjunction(new Literal(true, new NormalAtom("c")))));
        splittingSet = new IndexedProgram(program).getSplittingSet(atoms);
        Assert.assertEquals((long)splittingSet.size(), (long)7L);
        Assert.assertEquals(splittingSet, expectedSplit);
    }

    @Test
    public void splittingSetFromSubProgramTest() throws UnsupportedEncodingException, ParseException {
        String p = "c v d :- a.a :- b.e :- b, f.e :- k.f :- e.k :- e.";
        String subP = "e :- k.";
        Program program = this.getProgram(p);
        Program subProgram = this.getProgram(subP);
        IndexedProgram indProgram = new IndexedProgram(program);
        Set<Atom> splittingSet = indProgram.getSplittingSet(subProgram.getPredicateSymbolsAsAtoms());
        HashSet<NormalAtom> expectedSplit = new HashSet<NormalAtom>();
        expectedSplit.add(new NormalAtom("e"));
        expectedSplit.add(new NormalAtom("b"));
        expectedSplit.add(new NormalAtom("f"));
        expectedSplit.add(new NormalAtom("k"));
        Assert.assertEquals((long)splittingSet.size(), (long)4L);
        Assert.assertEquals(splittingSet, expectedSplit);
    }

    @Test
    public void splitBottomTest() throws UnsupportedEncodingException, ParseException, BadSplittingSetException {
        String p = "c v d :- a.a :- b.e :- b, f.e :- k.f :- e.k :- e.";
        String subP = "e :- k.";
        String expectedBottomP = "e :- b, f.e :- k.f :- e.k :- e.";
        Program program = this.getProgram(p);
        Program subProgram = this.getProgram(subP);
        Program expectedBottomProgram = this.getProgram(expectedBottomP);
        IndexedProgram indProgram = new IndexedProgram(program);
        Program bottom = indProgram.getSplitBottom(indProgram.getSplittingSet(subProgram.getPredicateSymbolsAsAtoms()));
        Assert.assertEquals((long)bottom.size(), (long)expectedBottomProgram.size());
        for (Expression expr : bottom) {
            Assert.assertTrue((boolean)expectedBottomProgram.contains(expr));
        }
    }

    @Test
    public void componentsSubProgramTest() throws UnsupportedEncodingException, ParseException {
        String p = "c v d :- a.a :- b.e :- b, f.e :- k.f :- e.k :- e.";
        String subP = "e :- k.";
        String expectedComponentR = "e :- k.k :- e.e :- b, f.f :- e.";
        Program program = this.getProgram(p);
        Program subProgram = this.getProgram(subP);
        Program expectedComponentRules = this.getProgram(expectedComponentR);
        Program componentRules = new IndexedProgram(program).getComponentsSubProgram(subProgram);
        Assert.assertEquals((long)componentRules.size(), (long)expectedComponentRules.size());
        for (Expression expr : componentRules) {
            Assert.assertTrue((boolean)expectedComponentRules.contains(expr));
        }
    }

    @Test
    public void dlpFunctionInputTest() throws UnsupportedEncodingException, ParseException {
        String p = "a :- b.b :- c.k :- d.";
        Program program = this.getProgram(p);
        DLPFunction function = new DLPFunction(program);
        NormalAtom atomC = new NormalAtom("c");
        NormalAtom atomD = new NormalAtom("c");
        try {
            function.addInput(atomC);
            function.addInput(atomD);
        }
        catch (BadInputAtomInDLPFunctionException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void dlpFunctionDisjunctionInputTest() throws UnsupportedEncodingException, ParseException {
        String p = "a(1) v z(2):- b(2).b(2) :- c(3).k(1) :- d.";
        Program program = this.getProgram(p);
        DLPFunction function = new DLPFunction(program);
        NormalAtom atomA = new NormalAtom("a");
        atomA.addAttribute(new SimpleTerm("1"));
        NormalAtom atomC = new NormalAtom("c");
        atomC.addAttribute(new SimpleTerm("3"));
        try {
            function.addInput(atomA);
            function.addInput(atomC);
        }
        catch (BadInputAtomInDLPFunctionException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
    }

    @Test(expected=BadInputAtomInDLPFunctionException.class)
    public void dlpFunctionWrongInputTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String p = "a :- b.b :- c.k :- d.";
        Program program = this.getProgram(p);
        DLPFunction function = new DLPFunction(program);
        NormalAtom atomC = new NormalAtom("c");
        NormalAtom atomA = new NormalAtom("a");
        function.addInput(atomC);
        function.addInput(atomA);
    }

    @Test(expected=BadInputAtomInDLPFunctionException.class)
    public void dlpFunctionDisjuctionWrongInputTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String p = "a(1) v z(2):- b(2).b(2) :- c(2).k(1) :- d.";
        Program program = this.getProgram(p);
        DLPFunction function = new DLPFunction(program);
        NormalAtom atomC = new NormalAtom("z");
        atomC.addAttribute(new SimpleTerm("2"));
        NormalAtom atomA = new NormalAtom("a");
        atomA.addAttribute(new SimpleTerm("1"));
        function.addInput(atomC);
        function.addInput(atomA);
    }

    @Test
    public void dlpFunctionCompositionInterferHiddenAtomsTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String f1 = "a(2) v z(2):- b(2).b(2) :- c(2).k(1) :- d.";
        String f2 = "a(1) v z(1):- b(1).a(1) :- t(1).d.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        NormalAtom atomA = new NormalAtom("a");
        atomA.addAttribute(new SimpleTerm("2"));
        function1.addInput(atomA);
        NormalAtom atomC = new NormalAtom("c");
        atomC.addAttribute(new SimpleTerm("2"));
        function1.addInput(atomC);
        NormalAtom atomD = new NormalAtom("d");
        function1.addInput(atomD);
        NormalAtom atomZ = new NormalAtom("z");
        atomZ.addAttribute(new SimpleTerm("2"));
        function1.addOutput(atomZ);
        NormalAtom atomB = new NormalAtom("b");
        atomB.addAttribute(new SimpleTerm("2"));
        function1.addOutput(atomB);
        NormalAtom atomK = new NormalAtom("k");
        atomK.addAttribute(new SimpleTerm("1"));
        function1.addHidden(atomK);
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        NormalAtom atomZ2 = new NormalAtom("z");
        atomZ2.addAttribute(new SimpleTerm("1"));
        function2.addInput(atomZ2);
        NormalAtom atomB2 = new NormalAtom("b");
        atomB2.addAttribute(new SimpleTerm("1"));
        function2.addInput(atomB2);
        NormalAtom atomA2 = new NormalAtom("a");
        atomA2.addAttribute(new SimpleTerm("1"));
        function2.addOutput(atomA2);
        NormalAtom atomD2 = new NormalAtom("d");
        function2.addOutput(atomD2);
        NormalAtom atomT2 = new NormalAtom("t");
        atomT2.addAttribute(new SimpleTerm("1"));
        function2.addHidden(atomT2);
        Assert.assertTrue((boolean)DLPFunction.respectHiddenInterface(function1, function2));
        function2.addHidden(new NormalAtom("d"));
        Assert.assertFalse((boolean)DLPFunction.respectHiddenInterface(function1, function2));
        function2.addOutput(new NormalAtom("d"));
        Assert.assertTrue((boolean)DLPFunction.respectHiddenInterface(function1, function2));
        NormalAtom atomK3 = new NormalAtom("k");
        atomK3.addAttribute(new SimpleTerm("1"));
        function2.getProgram().add(new Rule(new Disjunction(atomK3)));
        function2.addOutput(atomK3);
        Assert.assertFalse((boolean)DLPFunction.respectHiddenInterface(function1, function2));
    }

    @Test
    public void dlpFunctionCompositionDisjointOutputTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String f1 = "a v z:- b.b :- c.k :- d.";
        String f2 = "a v z:- b.a :- t.d.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        function1.addInput(new NormalAtom("a"));
        function1.addInput(new NormalAtom("c"));
        function1.addInput(new NormalAtom("d"));
        function1.addOutput(new NormalAtom("z"));
        function1.addOutput(new NormalAtom("b"));
        function1.addHidden(new NormalAtom("k"));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        function2.addInput(new NormalAtom("z"));
        function2.addInput(new NormalAtom("b"));
        function2.addOutput(new NormalAtom("a"));
        function2.addOutput(new NormalAtom("d"));
        function2.addHidden(new NormalAtom("t"));
        Assert.assertTrue((boolean)DLPFunction.respectDisjointOutput(function1, function2));
        function2.addOutput(new NormalAtom("z"));
        Assert.assertFalse((boolean)DLPFunction.respectDisjointOutput(function1, function2));
    }

    @Test
    public void dlpFunctionCompositionOutputDefinitionTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String f1 = "a(1) v z(1):- b(1).b(1) :- c(1).k(1) :- d.";
        String f2 = "a(1) v z(1):- b(1).a(1) :- t(1).d.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        NormalAtom atomA = new NormalAtom("a");
        atomA.addAttribute(new SimpleTerm("1"));
        function1.addInput(atomA);
        NormalAtom atomC = new NormalAtom("c");
        atomC.addAttribute(new SimpleTerm("1"));
        function1.addInput(atomC);
        NormalAtom atomD = new NormalAtom("d");
        function1.addInput(atomD);
        NormalAtom atomZ = new NormalAtom("z");
        atomZ.addAttribute(new SimpleTerm("1"));
        function1.addOutput(atomZ);
        NormalAtom atomB = new NormalAtom("b");
        atomB.addAttribute(new SimpleTerm("1"));
        function1.addOutput(atomB);
        NormalAtom atomK = new NormalAtom("k");
        atomK.addAttribute(new SimpleTerm("1"));
        function1.addHidden(atomK);
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        NormalAtom atomZ2 = new NormalAtom("z");
        atomZ2.addAttribute(new SimpleTerm("1"));
        function2.addInput(atomZ2);
        NormalAtom atomB2 = new NormalAtom("b");
        atomB2.addAttribute(new SimpleTerm("1"));
        function2.addInput(atomB2);
        NormalAtom atomA2 = new NormalAtom("a");
        atomA2.addAttribute(new SimpleTerm("1"));
        function2.addOutput(atomA2);
        NormalAtom atomD2 = new NormalAtom("d");
        function2.addOutput(atomD2);
        NormalAtom atomT2 = new NormalAtom("t");
        atomT2.addAttribute(new SimpleTerm("1"));
        function2.addHidden(atomT2);
        Assert.assertTrue((boolean)DLPFunction.respectOutputDefinition(function1, function2));
        Rule r1 = (Rule)this.getProgram("a(1) v b(1) :- c(1).").get(0);
        function1.getProgram().add(r1);
        Assert.assertFalse((boolean)DLPFunction.respectOutputDefinition(function1, function2));
        function2.getProgram().add(r1);
        Assert.assertTrue((boolean)DLPFunction.respectOutputDefinition(function1, function2));
        function2.getProgram().add((Expression)this.getProgram("a(3).").get(0));
        Assert.assertTrue((boolean)DLPFunction.respectOutputDefinition(function1, function2));
        function2.getProgram().add((Expression)this.getProgram("b(1).").get(0));
        Assert.assertFalse((boolean)DLPFunction.respectOutputDefinition(function1, function2));
    }

    @Test
    public void dlpFunctionMutuallyIndependentTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException {
        String composedF = "a :- b.b :- not a.";
        DLPFunction composedFunction = new DLPFunction(this.getProgram(composedF));
        HashSet<Atom> outputF1 = new HashSet<Atom>();
        HashSet<Atom> outputF2 = new HashSet<Atom>();
        outputF1.add(new NormalAtom("a"));
        outputF2.add(new NormalAtom("b"));
        Assert.assertTrue((boolean)DLPFunction.areMutuallyIndependent(outputF1, outputF2, composedFunction.getProgram()));
        composedF = "a :- b.b :- a.";
        composedFunction = new DLPFunction(this.getProgram(composedF));
        outputF1 = new HashSet();
        outputF2 = new HashSet();
        outputF1.add(new NormalAtom("a"));
        outputF2.add(new NormalAtom("b"));
        Assert.assertFalse((boolean)DLPFunction.areMutuallyIndependent(outputF1, outputF2, composedFunction.getProgram()));
    }

    @Test
    public void dlpFunctionCompositionTest() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException {
        String f1 = "a v z:- b.b :- c.k :- d.";
        String f2 = "a v z:- b.a :- t.d.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        NormalAtom atomA = new NormalAtom("a");
        function1.addInput(atomA);
        NormalAtom atomC = new NormalAtom("c");
        function1.addInput(atomC);
        function1.addInput(new NormalAtom("d"));
        NormalAtom atomZ = new NormalAtom("z");
        function1.addOutput(atomZ);
        NormalAtom atomB = new NormalAtom("b");
        function1.addOutput(atomB);
        NormalAtom atomK = new NormalAtom("k");
        function1.addHidden(atomK);
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        NormalAtom atomZ2 = new NormalAtom("z");
        function2.addInput(atomZ2);
        NormalAtom atomB2 = new NormalAtom("b");
        function2.addInput(atomB2);
        NormalAtom atomA2 = new NormalAtom("a");
        function2.addOutput(atomA2);
        function2.addOutput(new NormalAtom("d"));
        NormalAtom atomT = new NormalAtom("t");
        function2.addHidden(atomT);
        DLPFunction fComp = DLPFunction.compose(function1, function2);
        String expectedCompP = "a v z :- b.b :- c.k :- d.a v z:- b.a :- t.d.";
        Program expectedCompProgram = this.getProgram(expectedCompP);
        HashSet<NormalAtom> expectedInput = new HashSet<NormalAtom>();
        NormalAtom atomC2 = new NormalAtom("c");
        expectedInput.add(atomC2);
        HashSet<NormalAtom> expectedOutput = new HashSet<NormalAtom>();
        expectedOutput.add(new NormalAtom("a"));
        expectedOutput.add(new NormalAtom("d"));
        expectedOutput.add(new NormalAtom("z"));
        expectedOutput.add(new NormalAtom("b"));
        HashSet<NormalAtom> expectedHidden = new HashSet<NormalAtom>();
        expectedHidden.add(new NormalAtom("t"));
        expectedHidden.add(new NormalAtom("k"));
        Assert.assertEquals((long)fComp.getProgram().size(), (long)expectedCompProgram.size());
        for (Expression expr : fComp.getProgram()) {
            Assert.assertTrue((boolean)expectedCompProgram.contains(expr));
        }
        Assert.assertEquals((long)fComp.getInputSignature().size(), (long)expectedInput.size());
        for (Atom atom : fComp.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInput.contains(atom));
        }
        Assert.assertEquals((long)fComp.getOutputSignature().size(), (long)expectedOutput.size());
        for (Atom atom : fComp.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutput.contains(atom));
        }
        Assert.assertEquals((long)fComp.getHiddenSignature().size(), (long)expectedHidden.size());
        for (Atom atom : fComp.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHidden.contains(atom));
        }
    }

    @Test
    public void dlpFunctionMakeComposibleTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a(1) v z(1):- b(1).b(1) :- c(1).k(1) :- d.";
        String f2 = "a(1) v z(1):- b(1).a(1) :- t(1).d.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, false);
        HashSet<NormalAtom> expectedInputF1 = new HashSet<NormalAtom>();
        NormalAtom atomA = new NormalAtom("a");
        atomA.addAttribute(new SimpleTerm("1"));
        expectedInputF1.add(atomA);
        expectedInputF1.add(new NormalAtom("d"));
        HashSet<NormalAtom> expectedOutputF1 = new HashSet<NormalAtom>();
        NormalAtom atomB = new NormalAtom("b");
        atomB.addAttribute(new SimpleTerm("1"));
        expectedOutputF1.add(atomB);
        NormalAtom atomZ = new NormalAtom("z");
        atomZ.addAttribute(new SimpleTerm("1"));
        expectedOutputF1.add(atomZ);
        HashSet<NormalAtom> expectedHiddenF1 = new HashSet<NormalAtom>();
        NormalAtom atomK = new NormalAtom("k");
        atomK.addAttribute(new SimpleTerm("1"));
        expectedHiddenF1.add(atomK);
        NormalAtom atomC = new NormalAtom("c");
        atomC.addAttribute(new SimpleTerm("1"));
        expectedHiddenF1.add(atomC);
        HashSet<NormalAtom> expectedInputF2 = new HashSet<NormalAtom>();
        NormalAtom atomZ2 = new NormalAtom("z");
        atomZ2.addAttribute(new SimpleTerm("1"));
        expectedInputF2.add(atomZ2);
        NormalAtom atomB2 = new NormalAtom("b");
        atomB2.addAttribute(new SimpleTerm("1"));
        expectedInputF2.add(atomB2);
        HashSet<NormalAtom> expectedOutputF2 = new HashSet<NormalAtom>();
        NormalAtom atomA2 = new NormalAtom("a");
        atomA2.addAttribute(new SimpleTerm("1"));
        expectedOutputF2.add(atomA2);
        expectedOutputF2.add(new NormalAtom("d"));
        HashSet<NormalAtom> expectedHiddenF2 = new HashSet<NormalAtom>();
        NormalAtom atomT = new NormalAtom("t");
        atomT.addAttribute(new SimpleTerm("1"));
        expectedHiddenF2.add(atomT);
        Assert.assertEquals((long)expectedInputF1.size(), (long)function1.getInputSignature().size());
        for (Atom atom : function1.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF1.size(), (long)function1.getOutputSignature().size());
        for (Atom atom : function1.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF1.size(), (long)function1.getHiddenSignature().size());
        for (Atom atom : function1.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF1.contains(atom));
        }
        Assert.assertEquals((long)expectedInputF2.size(), (long)function2.getInputSignature().size());
        for (Atom atom : function2.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF2.size(), (long)function2.getOutputSignature().size());
        for (Atom atom : function2.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF2.size(), (long)function2.getHiddenSignature().size());
        for (Atom atom : function2.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF2.contains(atom));
        }
    }

    @Test
    public void dlpFunctionMakeComposibleTest2() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v b :- c.";
        String f2 = "a v b:- c.b.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, false);
        HashSet<NormalAtom> expectedInputF1 = new HashSet<NormalAtom>();
        expectedInputF1.add(new NormalAtom("b"));
        expectedInputF1.add(new NormalAtom("c"));
        HashSet<NormalAtom> expectedOutputF1 = new HashSet<NormalAtom>();
        expectedOutputF1.add(new NormalAtom("a"));
        HashSet expectedHiddenF1 = new HashSet();
        HashSet<NormalAtom> expectedInputF2 = new HashSet<NormalAtom>();
        expectedInputF2.add(new NormalAtom("a"));
        expectedInputF2.add(new NormalAtom("c"));
        HashSet<NormalAtom> expectedOutputF2 = new HashSet<NormalAtom>();
        expectedOutputF2.add(new NormalAtom("b"));
        HashSet expectedHiddenF2 = new HashSet();
        Assert.assertEquals((long)expectedInputF1.size(), (long)function1.getInputSignature().size());
        for (Atom atom : function1.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF1.size(), (long)function1.getOutputSignature().size());
        for (Atom atom : function1.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF1.size(), (long)function1.getHiddenSignature().size());
        for (Atom atom : function1.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF1.contains(atom));
        }
        Assert.assertEquals((long)expectedInputF2.size(), (long)function2.getInputSignature().size());
        for (Atom atom : function2.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF2.size(), (long)function2.getOutputSignature().size());
        for (Atom atom : function2.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF2.size(), (long)function2.getHiddenSignature().size());
        for (Atom atom : function2.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF2.contains(atom));
        }
    }

    @Test
    public void dlpFunctionMakeComposibleTest3() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v b v c :- d.c.";
        String f2 = "a v b v c :- d.b.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, false);
        HashSet<NormalAtom> expectedInputF1 = new HashSet<NormalAtom>();
        expectedInputF1.add(new NormalAtom("d"));
        expectedInputF1.add(new NormalAtom("a"));
        expectedInputF1.add(new NormalAtom("b"));
        HashSet<NormalAtom> expectedOutputF1 = new HashSet<NormalAtom>();
        expectedOutputF1.add(new NormalAtom("c"));
        HashSet expectedHiddenF1 = new HashSet();
        HashSet<NormalAtom> expectedInputF2 = new HashSet<NormalAtom>();
        expectedInputF2.add(new NormalAtom("c"));
        expectedInputF2.add(new NormalAtom("d"));
        HashSet<NormalAtom> expectedOutputF2 = new HashSet<NormalAtom>();
        expectedOutputF2.add(new NormalAtom("b"));
        expectedOutputF2.add(new NormalAtom("a"));
        HashSet expectedHiddenF2 = new HashSet();
        Assert.assertEquals((long)expectedInputF1.size(), (long)function1.getInputSignature().size());
        for (Atom atom : function1.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF1.size(), (long)function1.getOutputSignature().size());
        for (Atom atom : function1.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF1.size(), (long)function1.getHiddenSignature().size());
        for (Atom atom : function1.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF1.contains(atom));
        }
        Assert.assertEquals((long)expectedInputF2.size(), (long)function2.getInputSignature().size());
        for (Atom atom : function2.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF2.size(), (long)function2.getOutputSignature().size());
        for (Atom atom : function2.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF2.size(), (long)function2.getHiddenSignature().size());
        for (Atom atom : function2.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF2.contains(atom));
        }
    }

    @Test
    public void dlpFunctionMakeComposibleTest4() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v b :- c.b v c :- k.";
        String f2 = "a v b :- c.b v c :- k.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, false);
        HashSet<NormalAtom> expectedInputF1 = new HashSet<NormalAtom>();
        expectedInputF1.add(new NormalAtom("b"));
        expectedInputF1.add(new NormalAtom("k"));
        HashSet<NormalAtom> expectedOutputF1 = new HashSet<NormalAtom>();
        expectedOutputF1.add(new NormalAtom("a"));
        expectedOutputF1.add(new NormalAtom("c"));
        HashSet expectedHiddenF1 = new HashSet();
        HashSet<NormalAtom> expectedInputF2 = new HashSet<NormalAtom>();
        expectedInputF2.add(new NormalAtom("a"));
        expectedInputF2.add(new NormalAtom("c"));
        expectedInputF2.add(new NormalAtom("k"));
        HashSet<NormalAtom> expectedOutputF2 = new HashSet<NormalAtom>();
        expectedOutputF2.add(new NormalAtom("b"));
        HashSet expectedHiddenF2 = new HashSet();
        Assert.assertEquals((long)expectedInputF1.size(), (long)function1.getInputSignature().size());
        for (Atom atom : function1.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF1.size(), (long)function1.getOutputSignature().size());
        for (Atom atom : function1.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF1.size(), (long)function1.getHiddenSignature().size());
        for (Atom atom : function1.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF1.contains(atom));
        }
        Assert.assertEquals((long)expectedInputF2.size(), (long)function2.getInputSignature().size());
        for (Atom atom : function2.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF2.size(), (long)function2.getOutputSignature().size());
        for (Atom atom : function2.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF2.size(), (long)function2.getHiddenSignature().size());
        for (Atom atom : function2.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF2.contains(atom));
        }
    }

    @Test
    public void dlpFunctionMakeComposibleTest5() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v b v c :- d.c v b :- k.b v k.";
        String f2 = "a v b v c :- d.c v b :- k.b v k.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, false);
        HashSet<NormalAtom> expectedInputF1 = new HashSet<NormalAtom>();
        expectedInputF1.add(new NormalAtom("b"));
        expectedInputF1.add(new NormalAtom("a"));
        expectedInputF1.add(new NormalAtom("d"));
        HashSet<NormalAtom> expectedOutputF1 = new HashSet<NormalAtom>();
        expectedOutputF1.add(new NormalAtom("k"));
        expectedOutputF1.add(new NormalAtom("c"));
        HashSet expectedHiddenF1 = new HashSet();
        HashSet<NormalAtom> expectedInputF2 = new HashSet<NormalAtom>();
        expectedInputF2.add(new NormalAtom("k"));
        expectedInputF2.add(new NormalAtom("c"));
        expectedInputF2.add(new NormalAtom("d"));
        HashSet<NormalAtom> expectedOutputF2 = new HashSet<NormalAtom>();
        expectedOutputF2.add(new NormalAtom("b"));
        expectedOutputF2.add(new NormalAtom("a"));
        HashSet expectedHiddenF2 = new HashSet();
        Assert.assertEquals((long)expectedInputF1.size(), (long)function1.getInputSignature().size());
        for (Atom atom : function1.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF1.size(), (long)function1.getOutputSignature().size());
        for (Atom atom : function1.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF1.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF1.size(), (long)function1.getHiddenSignature().size());
        for (Atom atom : function1.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF1.contains(atom));
        }
        Assert.assertEquals((long)expectedInputF2.size(), (long)function2.getInputSignature().size());
        for (Atom atom : function2.getInputSignature()) {
            Assert.assertTrue((boolean)expectedInputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedOutputF2.size(), (long)function2.getOutputSignature().size());
        for (Atom atom : function2.getOutputSignature()) {
            Assert.assertTrue((boolean)expectedOutputF2.contains(atom));
        }
        Assert.assertEquals((long)expectedHiddenF2.size(), (long)function2.getHiddenSignature().size());
        for (Atom atom : function2.getHiddenSignature()) {
            Assert.assertTrue((boolean)expectedHiddenF2.contains(atom));
        }
    }

    @Test
    public void dlpFunctionMakeJoinablePassTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException {
        String f1 = "a :- not b.";
        String f2 = "b :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
        }
        catch (NotMutuallyIndependentDLPFunctionsException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
    }

    @Test(expected=NotMutuallyIndependentDLPFunctionsException.class)
    public void dlpFunctionMakeJoinableFailTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a :- b.";
        String f2 = "b :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
    }

    @Test(expected=NotMutuallyIndependentDLPFunctionsException.class)
    public void dlpFunctionMakeJoinableFailTest2() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "b :- a.a :- c.";
        String f2 = "c :- b.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
    }

    @Test(expected=NotMutuallyIndependentDLPFunctionsException.class)
    public void dlpFunctionMakeJoinableFailTest3() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v k :- b.b v z :- a.k.b.";
        String f2 = "a v k :- b.b v z :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
    }

    @Test
    public void dlpFunctionMakeJoinablePassTest2() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException {
        String f1 = "a v k :- b.b v z :- a.b.";
        String f2 = "a v k :- b.b v z :- a.k.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
        }
        catch (NotMutuallyIndependentDLPFunctionsException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
        catch (BadDLPFunctionCompositionException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
    }

    @Test
    public void dlpFunctionMakeJoinablePassTest3() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v k :- b.b v z :- a, c.";
        String f2 = "a v k :- b.b v z :- a, c.c :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
        }
        catch (NotMutuallyIndependentDLPFunctionsException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
        catch (BadDLPFunctionCompositionException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
    }

    @Test
    public void dlpFunctionMakeJoinableFailTest4() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        String f1 = "a v k :- b.b v z :- a, c.w :- a.";
        String f2 = "a v k :- b.b v z :- a, c.c :- w.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true);
            Assert.fail((String)"Expected NotMutuallyIndependentDLPFunctionsException or BadDLPFunctionCompositionException");
        }
        catch (BadDLPFunctionCompositionException badDLPFunctionCompositionException) {
        }
        catch (NotMutuallyIndependentDLPFunctionsException notMutuallyIndependentDLPFunctionsException) {
            // empty catch block
        }
    }

    @Test
    public void dlpFunctionMakeJoinableFixedInputF1PassTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException {
        String f1 = "a v k :- b.b v z :- a.b.";
        String f2 = "a v k :- b.b v z :- a.k.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        function1.addInput(new NormalAtom("k"));
        function1.addInput(new NormalAtom("z"));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true, true, false);
        }
        catch (NotMutuallyIndependentDLPFunctionsException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
    }

    @Test
    public void dlpFunctionMakeJoinableFixedInputF1FailTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String f1 = "a v k :- b.b v z :- a.";
        String f2 = "a v k :- b.b v z :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        function1.addInput(new NormalAtom("k"));
        function1.addInput(new NormalAtom("b"));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true, true, false);
            Assert.fail((String)"Expected NotMutuallyIndependentDLPFunctionsException or BadDLPFunctionCompositionException");
        }
        catch (BadDLPFunctionCompositionException badDLPFunctionCompositionException) {
        }
        catch (NotMutuallyIndependentDLPFunctionsException notMutuallyIndependentDLPFunctionsException) {
            // empty catch block
        }
    }

    @Test
    public void dlpFunctionMakeJoinableFixedInputF2PassTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException, BadDLPFunctionCompositionException {
        String f1 = "a v k :- b.b v z :- a.";
        String f2 = "a v k :- b.b v z :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        function2.addInput(new NormalAtom("k"));
        function2.addInput(new NormalAtom("z"));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true, false, true);
        }
        catch (NotMutuallyIndependentDLPFunctionsException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
        catch (BadDLPFunctionCompositionException e) {
            Assert.fail((String)("Unexpected exception " + e));
        }
    }

    @Test
    public void dlpFunctionMakeJoinableFixedInputF2FailTest1() throws UnsupportedEncodingException, ParseException, BadInputAtomInDLPFunctionException {
        String f1 = "a v k :- b.b v z :- a.";
        String f2 = "a v k :- b.b v z :- a.";
        DLPFunction function1 = new DLPFunction(this.getProgram(f1));
        DLPFunction function2 = new DLPFunction(this.getProgram(f2));
        function2.addInput(new NormalAtom("z"));
        function2.addInput(new NormalAtom("a"));
        try {
            DLPFunction.makeDLPFunctionsComposible(function1, function2, true, false, true);
            Assert.fail((String)"Expected NotMutuallyIndependentDLPFunctionsException or BadDLPFunctionCompositionException");
        }
        catch (BadDLPFunctionCompositionException badDLPFunctionCompositionException) {
        }
        catch (NotMutuallyIndependentDLPFunctionsException notMutuallyIndependentDLPFunctionsException) {
            // empty catch block
        }
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

