/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.wrapper.DLVInputProgramImpl;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVWrapper;
import it.unical.mat.wrapper.FactHandler;
import it.unical.mat.wrapper.FactResult;
import it.unical.mat.wrapper.obfuscator.Obfuscator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class ObfuscatorTest {
    @Test
    public void obfusctorNameTest() throws UnsupportedEncodingException, ParseException {
        Program p = ObfuscatorTest.getProgram("a(1):-b(1).a(X):-b(X).a(2):-a(3).a(b(X)):-c(b(X)).a(true):- 2 < #count {X1: a(X1, _)}.");
        Obfuscator obfuscator = new Obfuscator();
        obfuscator.obfuscateNames(p);
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("predicate0(1) :- predicate1(1)."));
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("predicate0(VAR0) :- predicate1(VAR0)."));
        Assert.assertTrue((boolean)((Expression)p.get(2)).toString().equals("predicate0(2) :- predicate0(3)."));
        Assert.assertTrue((boolean)((Expression)p.get(3)).toString().equals("predicate0(predicate1(VAR0)) :- predicate2(predicate1(VAR0))."));
        Assert.assertTrue((boolean)((Expression)p.get(4)).toString().equals("predicate0(constant0) :- 2 < #count{VAR1 : predicate0(VAR1, _)}."));
    }

    @Test
    public void shiftAttributeTest() throws UnsupportedEncodingException, ParseException {
        Program p = ObfuscatorTest.getProgram("a(X1,X2,X3,X4) :- b(X1,X2,X3,X4,X5).");
        Obfuscator obfuscator = new Obfuscator();
        obfuscator.shiftAttributes(p);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getVariables().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().contains(new SimpleTerm("X1")));
        Assert.assertTrue((boolean)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().contains(new SimpleTerm("X2")));
        Assert.assertTrue((boolean)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().contains(new SimpleTerm("X3")));
        Assert.assertTrue((boolean)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().contains(new SimpleTerm("X4")));
        Assert.assertTrue((((Literal)((Rule)p.get(0)).getBody().get(0)).attributes().size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Literal)((Rule)p.get(0)).body().get(0)).getVariables().contains(new SimpleTerm("X1")));
        Assert.assertTrue((boolean)((Literal)((Rule)p.get(0)).body().get(0)).getVariables().contains(new SimpleTerm("X2")));
        Assert.assertTrue((boolean)((Literal)((Rule)p.get(0)).body().get(0)).getVariables().contains(new SimpleTerm("X3")));
        Assert.assertTrue((boolean)((Literal)((Rule)p.get(0)).body().get(0)).getVariables().contains(new SimpleTerm("X4")));
        Assert.assertTrue((boolean)((Literal)((Rule)p.get(0)).body().get(0)).getVariables().contains(new SimpleTerm("X5")));
    }

    @Test
    public void shiftResumeAttributeTest() throws UnsupportedEncodingException, ParseException {
        Program p = ObfuscatorTest.getProgram("a(1, 2, 3, 4).b(1, 2, 3, 4, 5).c(1, 2, 3, 4, 5).d(1, 2, 3, 4, 5).e(1, 2, 3, 4, 5).");
        Obfuscator obfuscator = new Obfuscator();
        obfuscator.setObfuscationLevel(2);
        obfuscator.setProgram(p);
        obfuscator.setObfuscate(true);
        obfuscator.obfuscateOrResume();
        System.out.println(p);
        obfuscator.setResume(true);
        obfuscator.setObfuscate(false);
        obfuscator.obfuscateOrResume();
        System.out.println(p);
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("a(1, 2, 3, 4)."));
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("b(1, 2, 3, 4, 5)."));
    }

    @Test
    public void addRulesTest() throws UnsupportedEncodingException, ParseException {
        Program p = ObfuscatorTest.getProgram("a(X):-b(X).b(X):-c(X).c(X):-a(X).a(X):-aa(X).aa(X):-bb(X).bb(X):-aa(X).");
        Obfuscator obfuscator = new Obfuscator();
        System.out.println(String.valueOf(p.toString()) + '\n');
        obfuscator.obfuscateNames(p);
        System.out.println(String.valueOf(p.toString()) + '\n');
        obfuscator.addRules(p);
        System.out.println(String.valueOf(p.toString()) + '\n');
        obfuscator.removeRules(p);
        System.out.println(String.valueOf(p.toString()) + '\n');
        obfuscator.resumeOriginalNames(p);
        System.out.println(String.valueOf(p.toString()) + '\n');
    }

    @Test
    public void ASPcompetitionTest() throws Exception {
        ArrayList<String> problemFolders = new ArrayList<String>();
        problemFolders.add("25-GraphColouring");
        for (String folder : problemFolders) {
            int maxint = 0;
            if (folder.equals("06-Grammar-BasedInformationExtraction")) {
                maxint = 1106869;
            } else if (folder.equals("08-FastfoodOptimalityCheck")) {
                maxint = 910;
            } else if (folder.equals("25-GraphColouring")) {
                maxint = 125;
            }
            new File("obfuscator_files/" + folder + "/enc.OB.asp").delete();
            new File("obfuscator_files/" + folder + "/instances.OB.asp").delete();
            new File("obfuscator_files/" + folder + "/map").delete();
            new File("obfuscator_files/" + folder + "/results.asp").delete();
            new File("obfuscator_files/" + folder + "/results.OB.asp").delete();
            new File("obfuscator_files/" + folder + "/results.RE.asp").delete();
            new File("obfuscator_files/" + folder + "/results.RE.TMP.asp").delete();
            boolean containsQuery = this.getProgram(new File("obfuscator_files/" + folder + "/instances.asp")).containsQuery();
            System.out.println("START obfuscation " + folder + " encoding");
            String[] args = new String[]{"-l=3", "-fi=obfuscator_files/" + folder + "/enc.asp", "-fo=obfuscator_files/" + folder + "/enc.OB.asp", "-map=obfuscator_files/" + folder + "/map"};
            Obfuscator.main(args);
            System.out.println("START obfuscation " + folder + " instances");
            String[] args2 = new String[]{"-l=2", "-fi=obfuscator_files/" + folder + "/instances.asp", "-fo=obfuscator_files/" + folder + "/instances.OB.asp", "-map=obfuscator_files/" + folder + "/map"};
            Obfuscator.main(args2);
            System.out.println("START execution " + folder);
            DLVInputProgramImpl inputProgram = new DLVInputProgramImpl();
            DLVInvocation invocation = DLVWrapper.getInstance().createInvocation("obfuscator_files/dlv.mingw.exe");
            invocation.addOption("-facts");
            invocation.setNumberOfModels(1);
            if (maxint > 0) {
                invocation.setMaxint(maxint);
            }
            inputProgram.addFile("obfuscator_files/" + folder + "/enc.asp");
            inputProgram.addFile("obfuscator_files/" + folder + "/instances.asp");
            FactHandler factHandler = null;
            final Program p = new Program();
            factHandler = new FactHandler(){

                @Override
                public void handleResult(DLVInvocation obsd, FactResult res) {
                    p.add(new Rule(String.valueOf(res.toString()) + "."));
                }
            };
            invocation.setInputProgram(inputProgram);
            if (containsQuery) {
                invocation.addOption("-cautious");
            }
            invocation.subscribe(factHandler);
            invocation.run();
            invocation.waitUntilExecutionFinishes();
            this.writeProgram(new File("obfuscator_files/" + folder + "/results.asp"), p);
            System.out.println("START obfuscated execution " + folder);
            DLVInputProgramImpl inputProgramOB = new DLVInputProgramImpl();
            DLVInvocation invocationOB = DLVWrapper.getInstance().createInvocation("obfuscator_files/dlv.mingw.exe");
            invocationOB.addOption("-facts");
            if (maxint > 0) {
                invocationOB.setMaxint(maxint);
            }
            invocationOB.setNumberOfModels(1);
            inputProgramOB.addFile("obfuscator_files/" + folder + "/enc.OB.asp");
            inputProgramOB.addFile("obfuscator_files/" + folder + "/instances.OB.asp");
            final Program pOB = new Program();
            FactHandler factHandlerOB = new FactHandler(){

                @Override
                public void handleResult(DLVInvocation obsd, FactResult res) {
                    pOB.add(new Rule(String.valueOf(res.toString()) + "."));
                }
            };
            invocationOB.setInputProgram(inputProgramOB);
            if (containsQuery) {
                invocationOB.addOption("-cautious");
            }
            invocationOB.subscribe(factHandlerOB);
            invocationOB.run();
            invocationOB.waitUntilExecutionFinishes();
            this.writeProgram(new File("obfuscator_files/" + folder + "/results.OB.asp"), pOB);
            System.out.println("START resume results " + folder);
            String[] args3 = new String[]{"-l=3", "-r", "-fi=obfuscator_files/" + folder + "/results.OB.asp", "-fo=obfuscator_files/" + folder + "/results.RE.TMP.asp", "-map=obfuscator_files/" + folder + "/map"};
            Obfuscator.main(args3);
            Program tmpProgram = this.getProgram(new File("obfuscator_files/" + folder + "/results.RE.TMP.asp"));
            this.writeProgram(new File("obfuscator_files/" + folder + "/results.RE.asp"), tmpProgram);
            System.out.println("START comparison results " + folder);
            if (this.compareFiles(new File("obfuscator_files/" + folder + "/results.asp"), new File("obfuscator_files/" + folder + "/results.RE.asp"))) continue;
            System.out.println(String.valueOf(folder) + " test failed");
            Assert.assertTrue((boolean)false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compareFiles(File file1, File file2) {
        try {
            BufferedReader br1 = new BufferedReader(new InputStreamReader(new FileInputStream(file1)));
            BufferedReader br2 = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
            int line = 0;
            String str1 = "";
            String str2 = "";
            while (true) {
                if (str1 == null || str2 == null) {
                    br1.close();
                    br2.close();
                    return true;
                }
                str1 = br1.readLine();
                str2 = br2.readLine();
                ++line;
                if (str1 != null && str2 != null) {
                    if (str1.equals(str2)) continue;
                    System.out.println("ERROR at line " + line);
                    return false;
                }
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void writeProgram(File file, Program program) {
        try {
            FileWriter fw = new FileWriter(file);
            Collections.sort(program);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter outFile = new PrintWriter(bw);
            outFile.println(program.toString());
            outFile.flush();
            outFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Program getProgram(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        Director director = new Director(fis);
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private static Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

