/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVInvocationImpl;
import it.unical.mat.wrapper.FactHandler;
import it.unical.mat.wrapper.FactResult;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class SafetyTest {
    boolean trace = true;

    @Test
    public void safetyErrorRuleTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(${Y}).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyAggregateErrorRuleTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule with aggregates test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("c(X):- X = #count {T: b(T,Y), T > Y}, a(Z).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} = 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} > 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 <= #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} > VAR.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} < VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} <= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), VAR1 > #max{Z : r(Z), a(Z, V)} > VAR2.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{Z : r( X ,Z )}, c(VAR).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{VAR : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 ), c(VAR3)}, c(X).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X):- 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 )}, c(X).");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(Y):- 10>#count{X : r( X ,Z )}, c(Y), b(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1, 5) :- 12 <= #count{X5 : newPredicate(X5)} <= 15, a(X5,8).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyAggregateConjunction() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule with aggregates test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("a(1,5):- 12 = #count {X0: newPredicate(X0), H=P}.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1,5):- 12 = #count {X0: newPredicate(X0), H=2}.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("c(aX) :- UK = #count{X : not a(Y), b(X)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyAggregateErrorWeakConstraintTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule with aggregates test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} = VAR.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} = 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} > 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 <= #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} > VAR.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} < VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} <= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), VAR1 > #max{Z : r(Z), a(Z, V)} > VAR2.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{VAR : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 ), c(VAR3)}, c(X).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 )}, c(X).");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{X : r( X ,Z )}, c(Y), b(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyErrorWeakConstraintTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error weak-constraint test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram(":~ a(Y), not b(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), -b(U).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), H>2.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X=X1.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X>Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X<Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X>=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X<=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), H>V.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), d(Y), X<=Y.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), 2=Y.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), Y=2.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), 2=Y+X.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), 2=Y+H.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), Y=Y+H.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void safetyBuiltinRuleTest() throws UnsupportedEncodingException, ParseException {
        Rule r = new Rule(":- type(normal), sum(S), not #sum { A: num(I), size(N), D = N-I, J = D+1, sqr(I,J,A) } = S.");
        System.out.println(r);
        Assert.assertTrue((r.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        r = new Rule("a:-X=Y+Z.");
        Assert.assertTrue((r.getSafetyErrors().size() > 0 ? 1 : 0) != 0);
        r = new Rule("d(1) :- #count{X : not a(X), c(X)}< 1.");
        Assert.assertTrue((r.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private Program getProgramWithAnnotations(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.setParseAnnotation(true);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private Program getOutput(String code) throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        DLVInvocationImpl invocation = new DLVInvocationImpl();
        final Program p = new Program();
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation observed, FactResult result) {
                p.add(new Rule(String.valueOf(result.toString()) + "."));
            }
        };
        invocation.subscribe(factHandler);
        director.configureDlvInvocation(invocation);
        director.startOutput();
        return p;
    }
}

