/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.testing.Filter;
import it.unical.mat.dlv.testing.InputTest;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.TestInvocation;
import it.unical.mat.dlv.testing.TestSuite;
import it.unical.mat.dlv.testing.execution.TestSuiteExecutor;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.exception.ExecutableNotFoundInTestSuiteException;
import it.unical.mat.wrapper.exception.FileNotFoundInTestSuiteException;
import it.unical.mat.wrapper.exception.TestSuiteException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleExecutionTestingTest {
    TestSuite testSuite;

    @Before
    public void initializeTest() throws FileNotFoundException {
        this.testSuite = new TestSuite(new TestInvocation("invoc", "C:/Users/Kristian/Documents/dottorato/programmi/DLV/dlv.mingw.exe", null));
    }

    @Test
    public void TestOneTestCase() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "a(1..10).b(X):-a(X).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5). ciao."));
        testCase.addAssert(assert1);
        this.testSuite.addTestCase(testCase);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        it.unical.mat.dlv.testing.Assert assert2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5)."));
        testCase.addAssert(assert2);
        it.unical.mat.dlv.testing.Assert assert3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert3.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5). manzo."));
        testCase.addAssert(assert3);
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        System.out.println(executor.getTestCaseExecutors().get(0).getFailedMotivation());
    }

    @Test
    public void TestMoreTestCases() throws DLVInvocationException, IOException, ParseException, TestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "a(1..10).b(X):-a(X).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti1");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5). ciao."));
        testCase1.addAssert(assert1TestCase1);
        this.testSuite.addTestCase(testCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5)."));
        testCase1.addAssert(assert2TestCase1);
        TestCase testCase2 = new TestCase("inTutti2");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5). ciao."));
        testCase2.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert2TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase2.getExpectedOutput().setContent(this.getProgram("a(1). a(2). a(10). b(5). manzo."));
        testCase2.addAssert(assert2TestCase2);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        System.out.println(executor.getTestCaseExecutors().get(0).getFailedMotivation());
        System.out.println(executor.getTestCaseExecutors().get(1).getFailedMotivation());
    }

    @Test
    public void TestWithLocalInput() throws DLVInvocationException, IOException, ParseException, TestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(1).b(X) :- a(X), c(X).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        testCase1.addInputTest(new InputTest(this.getProgram("a(1).")));
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("b(1). a(1)."));
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("inTutti2");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        testCase2.addInputTest(new InputTest(this.getProgram("a(2).")));
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("b(1)."));
        testCase2.addAssert(assert1TestCase2);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        System.out.println(executor.getTestCaseExecutors().get(1).getFailedMotivation());
    }

    @Test
    public void TestWithLocalExcludeInput() throws DLVInvocationException, IOException, ParseException, TestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "a(1). c(1).b(X) :- a(X), c(X).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        testCase1.addExcludeInputTest(new InputTest(this.getProgram("c(1).")));
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("b(1). a(1)."));
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("inTutti2");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        testCase2.addInputTest(new InputTest(this.getProgram("ciao.")));
        testCase2.addExcludeInputTest(new InputTest(this.getProgram("b(X) :- a(X), c(X).")));
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("b(1). ciao."));
        testCase2.addAssert(assert1TestCase2);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        System.out.println(executor.getTestCaseExecutors().get(0).getFailedMotivation());
        System.out.println(executor.getTestCaseExecutors().get(1).getFailedMotivation());
    }

    @Test
    public void TestWithLocalExcludeInputFromFile() throws DLVInvocationException, IOException, ParseException, TestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "a(1). c(1).b(X) :- a(X), c(X).";
        File file = new File("tmpExclude.dl");
        PrintWriter writer = new PrintWriter(file);
        writer.println(programCode);
        writer.flush();
        writer.close();
        inputTest.getInputContent().setContent(file.getAbsolutePath());
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        testCase1.addExcludeInputTest(new InputTest(this.getProgram("c(1).")));
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("b(1). a(1)."));
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("inTutti2");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        testCase2.addInputTest(new InputTest(this.getProgram("ciao.")));
        testCase2.addExcludeInputTest(new InputTest(this.getProgram("b(X) :- a(X), c(X).")));
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("b(1). ciao."));
        testCase2.addAssert(assert1TestCase2);
        File localFile = new File("tmpLocalExclude.dl");
        PrintWriter localWriter = new PrintWriter(localFile);
        localWriter.println("ciao.ciao2.");
        localWriter.flush();
        localWriter.close();
        TestCase testCase3 = new TestCase("inTuttiLocalFile");
        testCase3.addInputTest(new InputTest(localFile.getAbsolutePath()));
        testCase3.addExcludeInputTest(new InputTest(this.getProgram("ciao.")));
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("ciao."));
        testCase3.addAssert(assert1TestCase3);
        it.unical.mat.dlv.testing.Assert assert2TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase3.getExpectedOutput().setContent(this.getProgram("ciao2."));
        testCase3.addAssert(assert2TestCase3);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        System.out.println(executor.getTestCaseExecutors().get(0).getFailedMotivation());
        System.out.println(executor.getTestCaseExecutors().get(1).getFailedMotivation());
        System.out.println(executor.getTestCaseExecutors().get(2).getFailedMotivation());
    }

    @Test
    public void TestWithNewOptions() throws DLVInvocationException, IOException, ParseException, TestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "c.a :- c.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTuttiOpzioneFilterDlv");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.setNewOptions("-filter=c");
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("inTutti");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("a."));
        testCase2.addAssert(assert1TestCase2);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        System.out.println(executor.getTestCaseExecutors().get(0).getFailedMotivation());
    }

    @Test
    public void TestWithFilters() throws DLVInvocationException, IOException, ParseException, TestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "c. d(2).-d(1).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("inTuttiFilter");
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("-d(1). d(2)."));
        Filter filter1 = new Filter(Filter.TypeFilter.NORMAL, false);
        filter1.addPredicate("d");
        testCase1.setFilter(filter1);
        testCase1.addAssert(assert1TestCase1);
        TestCase testCase2 = new TestCase("inTuttiPFilterPassed");
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("d(2)."));
        Filter filter2 = new Filter(Filter.TypeFilter.POSITIVE, false);
        filter2.addPredicate("d");
        testCase2.setFilter(filter2);
        testCase2.addAssert(assert1TestCase2);
        TestCase testCase22 = new TestCase("inTuttiPFilterFailed");
        it.unical.mat.dlv.testing.Assert assert1TestCase22 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase22.getExpectedOutput().setContent(this.getProgram("-d(1). d(2)."));
        Filter filter22 = new Filter(Filter.TypeFilter.POSITIVE, false);
        filter22.addPredicate("d");
        testCase22.setFilter(filter22);
        testCase22.addAssert(assert1TestCase22);
        TestCase testCase3 = new TestCase("inTuttiNFilter");
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("-d(1). d(2)."));
        Filter filter3 = new Filter(Filter.TypeFilter.NEGATIVE, false);
        filter3.addPredicate("d");
        testCase3.setFilter(filter3);
        testCase3.addAssert(assert1TestCase3);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase22);
        this.testSuite.addTestCase(testCase3);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getTestCaseExecutors().get(1).getFailedMotivation());
        System.out.println(executor.getTestCaseExecutors().get(2).getFailedMotivation());
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(3).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

