/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Query;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.dlv.typ.TypDirectives;
import it.unical.mat.dlv.typ.parser.ParseException;
import it.unical.mat.dlv.typ.parser.TypParser;
import it.unical.mat.wrapper.DLVError;
import it.unical.mat.wrapper.DLVInputProgram;
import it.unical.mat.wrapper.DLVInputProgramImpl;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVInvocationHandler;
import it.unical.mat.wrapper.DLVInvocationImpl;
import it.unical.mat.wrapper.DLVWrapper;
import it.unical.mat.wrapper.FactHandler;
import it.unical.mat.wrapper.FactResult;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.ModelBufferedHandler;
import it.unical.mat.wrapper.ModelHandler;
import it.unical.mat.wrapper.ModelResult;
import it.unical.mat.wrapper.Predicate;
import it.unical.mat.wrapper.PredicateHandler;
import it.unical.mat.wrapper.PredicateHandlerWithName;
import it.unical.mat.wrapper.PredicateResult;
import it.unical.mat.wrapper.QueryResultHandler;
import it.unical.mat.wrapper.QueryTupleHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WrapperTest {
    DLVInputProgram inputProgram;
    DLVInvocation invocation;
    static String folder = "files/test";
    static String FILE_A = String.valueOf(folder) + "/fileA.dl";
    static String FILE_B = String.valueOf(folder) + "/fileB.dl";
    String resFact;
    String resModel;
    String resPredicate;
    ModelResult res = null;
    FileOutputStream fileOS_A;
    PrintStream output_A;
    FileOutputStream fileOS_B;
    PrintStream output_B;

    @Before
    public void initializeTest() throws FileNotFoundException {
        this.inputProgram = new DLVInputProgramImpl();
        this.invocation = DLVWrapper.getInstance().createInvocation("files/dlv.exe");
        File file = new File(folder);
        file.mkdirs();
        this.fileOS_A = new FileOutputStream(FILE_A);
        this.output_A = new PrintStream(this.fileOS_A);
        this.fileOS_B = new FileOutputStream(FILE_B);
        this.output_B = new PrintStream(this.fileOS_B);
    }

    @After
    public void finishTest() throws DLVInvocationException {
        WrapperTest.deleteFile(new File(folder));
        if (this.invocation.getState() == DLVInvocation.DLVInvocationState.RUNNING) {
            this.invocation.killDlv();
        }
    }

    @Test
    public void programTest() throws DLVInvocationException, IOException {
        this.output_A.print("a(1..5).");
        this.output_B.print("b(1..5).");
        this.inputProgram.addFile(FILE_A);
        this.inputProgram.addFile(FILE_B);
        Assert.assertTrue((this.inputProgram.getFiles().size() == 2 ? 1 : 0) != 0);
        this.inputProgram.addText("c(1..5).");
        Assert.assertTrue((boolean)this.inputProgram.getCompleteText().equals("c(1..5)."));
        final ArrayList literals = new ArrayList();
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                literals.add(res);
            }
        };
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.subscribe(factHandler);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 15 ? 1 : 0) != 0);
        this.inputProgram.cleanText();
        literals.clear();
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 10 ? 1 : 0) != 0);
        this.invocation.reset();
        this.inputProgram.clean();
        int i = 0;
        while (i < 5) {
            System.out.println(String.valueOf(((FactResult)literals.get(i)).toString()) + ".");
            this.inputProgram.addExpression(new Rule(String.valueOf(((FactResult)literals.get(i)).toString()) + "."));
            ++i;
        }
        this.invocation.setInputProgram(this.inputProgram);
        literals.clear();
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 5 ? 1 : 0) != 0);
        this.inputProgram.clean();
        this.inputProgram.addFile(FILE_A);
        this.inputProgram.addFile(FILE_B);
        this.inputProgram.addText("c(X,Y):-a(X),b(Y).");
        literals.clear();
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 35 ? 1 : 0) != 0);
        Program a = new Program();
        Program b = new Program();
        Program c = new Program();
        Program all = new Program();
        for (FactResult literal : literals) {
            Rule fact = new Rule(String.valueOf(literal.toString()) + ".");
            if (fact instanceof Rule) {
                if (((Atom)fact.head().get(0)).getName().equals("a")) {
                    a.add(fact);
                } else if (((Atom)fact.head().get(0)).getName().equals("b")) {
                    b.add(fact);
                } else {
                    c.add(fact);
                }
            }
            all.add(fact);
        }
        this.inputProgram.clean();
        this.inputProgram.includeProgram(all);
        literals.clear();
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 35 ? 1 : 0) != 0);
        this.inputProgram.removeProgram(c);
        literals.clear();
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 10 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < 3) {
            this.inputProgram.removeExpression((Expression)a.get(i2));
            ++i2;
        }
        literals.clear();
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void invocationStateTest() throws Exception {
        Assert.assertTrue((this.invocation.getState() == DLVInvocation.DLVInvocationState.READY ? 1 : 0) != 0);
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        Assert.assertTrue((this.invocation.getState() == DLVInvocation.DLVInvocationState.RUNNING ? 1 : 0) != 0);
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((this.invocation.getState() == DLVInvocation.DLVInvocationState.FINISHED ? 1 : 0) != 0);
        this.invocation.run();
        this.invocation.killDlv();
        Assert.assertTrue((this.invocation.getState() == DLVInvocation.DLVInvocationState.KILLED ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void stopExecutionExceptionTest() throws UnsupportedOperationException, DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.stopExecution();
    }

    @Test
    public void streamOutputTest() throws UnsupportedOperationException, DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..10).");
        this.inputProgram.addText("b(1..10).");
        this.inputProgram.addText("c(X,Y) v d(X):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        BufferedReader buffer = this.invocation.getInputReader();
        int readed = buffer.read();
        while (readed > 0) {
            System.out.print((char)readed);
            readed = buffer.read();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void resumeExecutionExceptionTest() throws UnsupportedOperationException, DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.resumeExecution();
    }

    @Test
    public void invocationOptionsTest() throws DLVInvocationException {
        this.invocation.setMaxint(10);
        Assert.assertTrue((this.invocation.getOptions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.invocation.getOptions().get(0).equals("-N=10"));
        this.invocation.resetMaxint();
        Assert.assertTrue((this.invocation.getOptions().size() == 0 ? 1 : 0) != 0);
        this.invocation.setNumberOfModels(10);
        Assert.assertTrue((this.invocation.getOptions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.invocation.getOptions().get(0).equals("-n=10"));
        this.invocation.resetNumberOfModels();
        Assert.assertTrue((this.invocation.getOptions().size() == 0 ? 1 : 0) != 0);
        this.invocation.addOption("-N   = 10\t");
        this.invocation.setMaxint(20);
        Assert.assertTrue((this.invocation.getOptions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.invocation.getOptions().get(0).equals("-N=20"));
        this.invocation.resetOptions();
        this.invocation.addOption("-n= 10 -N=100 ");
        this.invocation.setNumberOfModels(20);
        Assert.assertTrue((this.invocation.getOptions().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.invocation.getOptions().get(1).equals("-n=20"));
        this.invocation.removeOptions(" -n=20  ,  -fact, -N=  100");
        Assert.assertTrue((this.invocation.getOptions().size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=DLVInvocationException.class)
    public void invocationRunningExceptionTest1() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.run();
    }

    @Test(expected=DLVInvocationException.class)
    public void invocationRunningExceptionTest2() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.setMaxint(20);
    }

    @Test(expected=DLVInvocationException.class)
    public void invocationRunningExceptionTest3() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                System.out.println(res.toString());
            }
        };
        this.invocation.subscribe(factHandler);
    }

    @Test
    public void resultTrueNegatedTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("-a(1).");
        this.invocation.setInputProgram(this.inputProgram);
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                WrapperTest.this.resFact = res.toString();
            }
        };
        PredicateHandler predicateHandler = new PredicateHandler(){

            @Override
            public void handleResult(DLVInvocation observed, PredicateResult result) {
                WrapperTest.this.resPredicate = result.toString();
            }
        };
        ModelHandler modelHandler = new ModelHandler(){

            @Override
            public void handleResult(DLVInvocation observed, ModelResult result) {
                WrapperTest.this.resModel = result.toString();
            }
        };
        this.invocation.subscribe(modelHandler);
        this.invocation.subscribe(factHandler);
        this.invocation.subscribe(predicateHandler);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((boolean)this.resFact.equals("-a(1)"));
        Assert.assertTrue((boolean)this.resPredicate.equals("-a(1).\n"));
        Assert.assertTrue((boolean)this.resModel.equals("-a(1).\n"));
    }

    @Test
    public void resultWeakConstraintTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a v b.c v d.e v f.b:-a.a:-b.:~a.[1:1]:~c.[2:2]");
        this.invocation.setInputProgram(this.inputProgram);
        ModelHandler modelHandler = new ModelHandler(){

            @Override
            public void handleResult(DLVInvocation observed, ModelResult result) {
                WrapperTest.this.res = result;
            }
        };
        this.invocation.subscribe(modelHandler);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((boolean)((Model)this.res).isBest());
        Assert.assertTrue((((Model)this.res).getCost(1) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Model)this.res).getCost(2) == 0 ? 1 : 0) != 0);
        System.out.println(this.res);
    }

    @Test
    public void resultWeakConstraint2Test() throws DLVInvocationException, IOException {
        this.inputProgram.addText("inClique(X1) v outClique(X1) :- node(X1).uedge(X1,X2) :- edge(X1,X2), X1 < X2.uedge(X2,X1) :- edge(X1,X2), X2 < X1.:- inClique(X1), outClique(X2), not uedge(X1,X2), X1 < X2.:~ outClique(X2).");
        this.invocation.setInputProgram(this.inputProgram);
        ModelHandler modelHandler = new ModelHandler(){

            @Override
            public void handleResult(DLVInvocation observed, ModelResult result) {
                WrapperTest.this.res = result;
            }
        };
        this.invocation.subscribe(modelHandler);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((boolean)((Model)this.res).isBest());
        System.out.println(this.res);
    }

    @Test(expected=DLVInvocationException.class)
    public void invocationRunningExceptionTest4() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..100).");
        this.inputProgram.addText("b(1..100).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                System.out.println(res.toString());
            }
        };
        this.invocation.unSubscribe(factHandler);
    }

    @Test(expected=DLVInvocationException.class)
    public void invocationRunningExceptionTest5() throws DLVInvocationException, IOException {
        this.invocation.run();
    }

    @Test
    public void invocationGetErrorTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..50).");
        this.inputProgram.addText("b(1..50).");
        this.inputProgram.addText("c(X,Y):-a(X), b(Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        List<DLVError> errors = this.invocation.getErrors();
        Assert.assertTrue((errors.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.invocation.getState() == DLVInvocation.DLVInvocationState.FINISHED ? 1 : 0) != 0);
    }

    @Test
    public void invocationFactHandlerTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..5).");
        this.inputProgram.addText("b(1..5).");
        final ArrayList literals = new ArrayList();
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                literals.add(res);
            }
        };
        this.invocation.subscribe(factHandler);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void invocationPredicateHandlerTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..5).");
        this.inputProgram.addText("b(1..5).");
        this.inputProgram.addText("c(1..5).");
        final ArrayList predicates = new ArrayList();
        PredicateHandler predicateHandler = new PredicateHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicates.add(res);
            }
        };
        this.invocation.subscribe(predicateHandler);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((predicates.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void invocationPredicateHandlerWithNameTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..5).");
        this.inputProgram.addText("b(1..5).");
        this.inputProgram.addText("c(1..5).");
        final ArrayList predicates = new ArrayList();
        PredicateHandlerWithName predicateHandler = new PredicateHandlerWithName(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicates.add(res);
            }

            @Override
            public List<String> getPredicateNames() {
                ArrayList<String> pred = new ArrayList<String>();
                pred.add("a");
                pred.add("b");
                return pred;
            }
        };
        this.invocation.subscribe(predicateHandler);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((predicates.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void invocationModelHandlerTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..10).");
        this.inputProgram.addText("b(X) v c(X):- a(X).");
        final ArrayList models = new ArrayList();
        ModelHandler modelHandler = new ModelHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, ModelResult res) {
                models.add(res);
            }
        };
        this.invocation.subscribe(modelHandler);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((boolean)this.invocation.haveModel());
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue(((double)models.size() == Math.pow(2.0, 10.0) ? 1 : 0) != 0);
    }

    @Test
    public void subscribeUnsubscribeInvocationTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..10).");
        this.inputProgram.addText("b(1..10).");
        this.inputProgram.addText("c(1..10).");
        final ArrayList models = new ArrayList();
        final ArrayList predicates = new ArrayList();
        final ArrayList predicatesWithName = new ArrayList();
        final ArrayList literals = new ArrayList();
        final ArrayList queryResults = new ArrayList();
        final ArrayList queryTuple = new ArrayList();
        QueryTupleHandler queryTupleHandler = new QueryTupleHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                queryTuple.add(res);
            }
        };
        QueryResultHandler queryResultHandler = new QueryResultHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                queryResults.add((Predicate)res);
            }
        };
        ModelHandler modelHandler = new ModelHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, ModelResult res) {
                models.add(res);
            }
        };
        PredicateHandler predicateHandler = new PredicateHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicates.add(res);
            }
        };
        PredicateHandlerWithName predicateHandlerWithName = new PredicateHandlerWithName(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicatesWithName.add(res);
            }

            @Override
            public List<String> getPredicateNames() {
                ArrayList<String> pred = new ArrayList<String>();
                pred.add("a");
                pred.add("b");
                return pred;
            }
        };
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                literals.add(res);
            }
        };
        this.invocation.setInputProgram(this.inputProgram);
        ArrayList<DLVInvocationHandler> handlers = new ArrayList<DLVInvocationHandler>();
        handlers.add(modelHandler);
        handlers.add(factHandler);
        handlers.add(predicateHandler);
        handlers.add(predicateHandlerWithName);
        handlers.add(queryResultHandler);
        handlers.add(queryTupleHandler);
        this.invocation.subscribe(handlers);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 30 ? 1 : 0) != 0);
        Assert.assertTrue((models.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((predicates.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((predicatesWithName.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((queryResults.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((queryTuple.size() == 0 ? 1 : 0) != 0);
        models.clear();
        predicates.clear();
        predicatesWithName.clear();
        literals.clear();
        this.invocation.unSubscribe(predicateHandler);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 30 ? 1 : 0) != 0);
        Assert.assertTrue((models.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((predicates.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((predicatesWithName.size() == 2 ? 1 : 0) != 0);
        models.clear();
        predicates.clear();
        predicatesWithName.clear();
        literals.clear();
        this.invocation.unSubscribe(handlers);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((models.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((predicates.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((predicatesWithName.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void invocationErrorsTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..10).");
        this.inputProgram.addText("b(X):- a(X,Y).");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        Assert.assertTrue((this.invocation.getErrors().size() == 2 ? 1 : 0) != 0);
        this.inputProgram.cleanText();
        this.inputProgram.addText("a(1..10).");
        this.inputProgram.addText("b(X):- a(X).");
        this.invocation.run();
        Assert.assertTrue((this.invocation.getErrors().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void invocationQueryGroundTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..2).");
        this.inputProgram.addText("b(1..2).");
        this.inputProgram.addText("a(1)?");
        final ArrayList literals = new ArrayList();
        QueryTupleHandler queryTupleHandler = new QueryTupleHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                literals.add(res);
            }
        };
        this.invocation.subscribe(queryTupleHandler);
        this.invocation.addOption("-cautious");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((literals.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Literal)literals.get(0)).getName().equals("QueryGroundResult"));
        List<Term> terms = ((Literal)literals.get(0)).attributes();
        SimpleTerm term = (SimpleTerm)terms.get(0);
        Assert.assertTrue((boolean)term.toString().equals("true"));
        final ArrayList predicates = new ArrayList();
        final ArrayList queryResults = new ArrayList();
        PredicateHandler predicateHandler = new PredicateHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicates.add((Predicate)res);
            }
        };
        QueryResultHandler queryResultHandler = new QueryResultHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                queryResults.add((Predicate)res);
            }
        };
        this.inputProgram.cleanText();
        this.invocation.resetOptions();
        this.invocation.subscribe(predicateHandler);
        this.invocation.subscribe(queryResultHandler);
        this.inputProgram.addText("a(1..2).");
        this.inputProgram.addText("b(1..2).");
        this.inputProgram.addText("a(3)?");
        this.invocation.addOption("-brave");
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((predicates.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((queryResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((queryResults.get(0) == predicates.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Predicate)predicates.get(0)).name().equals("QueryGroundResult"));
        Literal literal = ((Predicate)predicates.get(0)).getLiterals().nextElement();
        Assert.assertTrue((boolean)literal.getName().equals("QueryGroundResult"));
    }

    @Test
    public void invocationQueryNonGroundTest1() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..2).");
        this.inputProgram.addText("b(1..2).");
        this.inputProgram.addText("c(X,Y):-a(X),b(Y).");
        this.inputProgram.addText("c(X,Y)?");
        final ArrayList predicates = new ArrayList();
        final ArrayList queryResults = new ArrayList();
        final ArrayList queryTuple = new ArrayList();
        QueryTupleHandler queryTupleHandler = new QueryTupleHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                queryTuple.add(res);
            }
        };
        QueryResultHandler queryResultHandler = new QueryResultHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                queryResults.add((Predicate)res);
            }
        };
        PredicateHandler predicateHandler = new PredicateHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicates.add(res);
            }
        };
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.subscribe(predicateHandler);
        this.invocation.subscribe(queryResultHandler);
        this.invocation.subscribe(queryTupleHandler);
        this.invocation.addOption("-cautious");
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((predicates.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Predicate)predicates.get(0)).name().equals("QueryResult"));
        Assert.assertTrue((((Predicate)predicates.get(0)).size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((predicates.get(0) == queryResults.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((queryTuple.size() == 4 ? 1 : 0) != 0);
        this.inputProgram.addText(":- not k.");
        this.invocation.addOption("-cautious");
        this.invocation.run();
        Assert.assertTrue((this.invocation.getErrors().size() == 1 ? 1 : 0) != 0);
        this.invocation.resetOptions();
        this.invocation.run();
        Assert.assertTrue((this.invocation.getErrors().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void invocationQueryObjectTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..2).");
        this.inputProgram.addText("b(1..2).");
        this.inputProgram.addText("c(X,Y):-a(X),b(Y).");
        this.inputProgram.addText("a(X)?");
        this.output_A.print("b(X)?");
        this.inputProgram.addFile(FILE_A);
        Query q = new Query();
        ArrayList<Term> t = new ArrayList<Term>();
        t.add(new SimpleTerm("X"));
        t.add(new SimpleTerm("Y"));
        NormalAtom a = new NormalAtom(false, "c", t);
        Literal literal = new Literal(true, a);
        q.body().add(literal);
        this.invocation.setQuery(q);
        final ArrayList predicates = new ArrayList();
        final ArrayList queryResults = new ArrayList();
        final ArrayList queryTuple = new ArrayList();
        QueryTupleHandler queryTupleHandler = new QueryTupleHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, FactResult res) {
                queryTuple.add(res);
            }
        };
        QueryResultHandler queryResultHandler = new QueryResultHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                queryResults.add((Predicate)res);
            }
        };
        PredicateHandler predicateHandler = new PredicateHandler(){

            @Override
            public void handleResult(DLVInvocation obsd, PredicateResult res) {
                predicates.add(res);
            }
        };
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.subscribe(predicateHandler);
        this.invocation.subscribe(queryResultHandler);
        this.invocation.subscribe(queryTupleHandler);
        this.invocation.addOption("-cautious");
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        System.out.println(predicates.size());
        Assert.assertTrue((predicates.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Predicate)predicates.get(0)).name().equals("QueryResult"));
        Assert.assertTrue((((Predicate)predicates.get(0)).size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((predicates.get(0) == queryResults.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((queryTuple.size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void modelBufferedHandlerTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(1..4).");
        this.inputProgram.addText("b(X) v c(X):- a(X).");
        ModelBufferedHandler modelBufferedHandler = new ModelBufferedHandler(this.invocation);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        int count = 0;
        int oldModel = -1;
        int currentModel = -2;
        int factCount = 8;
        while (modelBufferedHandler.hasMoreModels()) {
            ++count;
            Model model = modelBufferedHandler.nextModel();
            while (model.hasMorePredicates()) {
                Predicate predicate = model.nextPredicate();
                while (predicate.hasMoreLiterals()) {
                    Literal rule = predicate.nextLiteral();
                    System.out.println("MODEL" + rule.getModelID() + " " + rule.toString());
                    currentModel = rule.getModelID();
                    if (currentModel != oldModel) {
                        Assert.assertTrue((factCount == 8 ? 1 : 0) != 0);
                        factCount = 0;
                        oldModel = currentModel;
                    }
                    ++factCount;
                }
            }
        }
        Assert.assertTrue((count == 16 ? 1 : 0) != 0);
    }

    @Test
    public void modelBufferedHandlerWithQueryTest() throws DLVInvocationException, IOException {
        this.inputProgram.addText("a(true).");
        this.inputProgram.addText("b(X,1) v c(X):- a(X).");
        this.inputProgram.addText("a(X)?");
        ModelBufferedHandler modelBufferedHandler = new ModelBufferedHandler(this.invocation);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.addOption("-brave");
        this.invocation.run();
        Assert.assertTrue((boolean)modelBufferedHandler.hasMoreModels());
    }

    @Test
    public void ruleMethodTest() throws DLVInvocationException, IOException {
        String ruleCode = "a(X) :- B(X).";
        Rule rule = new Rule(ruleCode);
        Assert.assertTrue((boolean)rule.toString().equals(ruleCode));
        ruleCode = "a(1).";
        rule = new Rule(ruleCode);
        Assert.assertTrue((boolean)rule.isFact());
    }

    @Test
    public void programApiciTest() throws DLVInvocationException, IOException {
        String ruleCode = "\"bb    a\"(X) :- b(X). b(1..4).";
        this.inputProgram.addText(ruleCode);
        this.invocation.setInputProgram(this.inputProgram);
        ModelBufferedHandler b = new ModelBufferedHandler(this.invocation);
        this.invocation.run();
        while (b.hasMoreModels()) {
            System.out.println(b.nextModel());
        }
    }

    @Test
    public void versionExecutableTest() throws DLVInvocationException {
        Assert.assertTrue((boolean)DLVWrapper.getInstance().getVersion().startsWith("DLV"));
    }

    @Test
    public void symbolFunctionOutputTest() throws DLVInvocationException, IOException {
        String ruleCode = "a(newid(X,Y)) :- b(X,Y).\nb(1,2).";
        this.inputProgram.addText(ruleCode);
        this.invocation.setInputProgram(this.inputProgram);
        ModelBufferedHandler b = new ModelBufferedHandler(this.invocation);
        this.invocation.run();
        while (b.hasMoreModels()) {
            Model model = b.nextModel();
            model.beforeFirst();
            while (model.hasMorePredicates()) {
                Predicate predicate = model.nextPredicate();
                predicate.beforeFirst();
                while (predicate.hasMoreLiterals()) {
                    Literal literal = predicate.nextLiteral();
                    if (!literal.getAtom().getName().equals("a")) continue;
                    Assert.assertTrue((boolean)(((NormalAtom)literal.getAtom()).getAttributeAt(0) instanceof NormalAtom));
                }
            }
        }
    }

    @Test
    public void listOutputTest() throws it.unical.mat.dlv.parser.ParseException, DLVInvocationException, IOException {
        String ruleCode = "a(1..10).\nlista([X]) :- a(X).";
        this.inputProgram.addText(ruleCode);
        this.invocation.setInputProgram(this.inputProgram);
        ModelBufferedHandler b = new ModelBufferedHandler(this.invocation);
        this.invocation.run();
        while (b.hasMoreModels()) {
            System.out.println(b.nextModel());
        }
    }

    @Test
    public void multiSetOutputTest() throws it.unical.mat.dlv.parser.ParseException, DLVInvocationException, IOException {
        String ruleCode = "a(1..10).\nlista({X}) :- a(X).";
        this.inputProgram.addText(ruleCode);
        this.invocation.setInputProgram(this.inputProgram);
        ModelBufferedHandler b = new ModelBufferedHandler(this.invocation);
        this.invocation.run();
        while (b.hasMoreModels()) {
            System.out.println(b.nextModel());
        }
    }

    @Test
    public void example1ListTest() throws DLVInvocationException, IOException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a( x, 1).\n");
        ruleCode.append("a( y, 2).\n");
        ruleCode.append("aNext(X,Y) :- a(_,X), a(_,Y), X<Y, not aNotNext(X,Y).\n");
        ruleCode.append("aNotNext(X,Y) :- a(_,X), a(_,Z), a(_,Y), X<Z, Z<Y.\n");
        ruleCode.append("aNotMin(X) :- aNext(_,X).\n");
        ruleCode.append("aMin(X) :- a(_,X), not aNotMin(X).\n");
        ruleCode.append("aNotMax(X) :- aNext(X,_).\n");
        ruleCode.append("aMax(X) :- a(_,X), not aNotMax(X).\n");
        ruleCode.append("partialAList(X,[Id]) :- aMax(X),a(Id,X).\n");
        ruleCode.append("partialAList(X,[Id|YL]) :- partialAList(Y,YL), aNext(X,Y), a(Id,X).\n");
        this.inputProgram.addText(ruleCode.toString());
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.setMaxint(10);
        this.invocation.addOption("-nofdcheck");
        ModelBufferedHandler b = new ModelBufferedHandler(this.invocation);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        while (b.hasMoreModels()) {
            System.out.println(b.nextModel());
        }
    }

    @Test
    public void standardErrorTest() throws DLVInvocationException, IOException {
        String ruleCode = "a(1..10).\nlista(X) :- a(X)";
        this.inputProgram.addText(ruleCode);
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
        BufferedReader errReader = ((DLVInvocationImpl)this.invocation).getErrorReader();
        String line = errReader.readLine();
        while (line != null) {
            System.out.println(line);
            line = errReader.readLine();
        }
    }

    @Test
    public void example2ListTest() throws DLVInvocationException, IOException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a( x, 1).\n");
        ruleCode.append("a( y, 2).\n");
        ruleCode.append("aNext(X,Y) :- a(_,X), a(_,Y), X<Y, not aNotNext(X,Y).\n");
        ruleCode.append("aNotNext(X,Y) :- a(_,X), a(_,Z), a(_,Y), X<Z, Z<Y.\n");
        ruleCode.append("aNotMin(X) :- aNext(_,X).\n");
        ruleCode.append("aMin(X) :- a(_,X), not aNotMin(X).\n");
        ruleCode.append("aNotMax(X) :- aNext(X,_).\n");
        ruleCode.append("aMax(X) :- a(_,X), not aNotMax(X).\n");
        ruleCode.append("partialAList(X,[Id]) :- aMax(X),a(Id,X).\n");
        this.inputProgram.addText(ruleCode.toString());
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.setMaxint(10);
        this.invocation.addOption("-nofdcheck");
        ModelBufferedHandler b = new ModelBufferedHandler(this.invocation);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        while (b.hasMoreModels()) {
            System.out.println(b.nextModel());
        }
    }

    @Test
    public void emptyQueryResultTest() throws DLVInvocationException, IOException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a( x, 1).\n");
        ruleCode.append("a( y, 2).\n");
        ruleCode.append("a( X, 3)?\n");
        this.inputProgram.addText(ruleCode.toString());
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.addOption("-brave");
        final ArrayList models = new ArrayList();
        final ArrayList literals = new ArrayList();
        QueryTupleHandler qtHandler = new QueryTupleHandler(){

            @Override
            public void handleResult(DLVInvocation observed, FactResult result) {
                literals.add((Literal)result);
            }
        };
        ModelHandler modelHandler = new ModelHandler(){

            @Override
            public void handleResult(DLVInvocation observed, ModelResult result) {
                models.add((Model)result);
            }
        };
        this.invocation.subscribe(modelHandler);
        this.invocation.subscribe(qtHandler);
        this.invocation.run();
        this.invocation.waitUntilExecutionFinishes();
        Assert.assertTrue((models.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Model)models.get(0)).firstPredicate().name().equals("EmptyQueryResult"));
        Assert.assertTrue((literals.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void DLVDBInvocationTest() throws DLVInvocationException, IOException, ParseException {
        Program program = new Program();
        program.add(new Rule("a."));
        program.add(new Rule("b."));
        String typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.\n\nUSE \"edge complex\"(X,Y)\nMAPTO \"edge complex\"(VARCHAR(20),VARCHAR(90)).\n\nCREATE reachable(X,Y)\nMAPTO \"reachable complex\"(varchar(33),varchar(44,66,77))\nKEEP_AFTER_EXECUTION.";
        program.setTypDirectives(this.getTypDirectives(typContent));
        this.inputProgram.includeProgram(program);
        this.invocation = DLVWrapper.getInstance().createDLVDBInvocation("files/dlv.exe");
        this.invocation.setInputProgram(this.inputProgram);
        this.invocation.run();
    }

    private TypDirectives getTypDirectives(String code) throws ParseException, UnsupportedEncodingException {
        TypParser typParser = new TypParser(new ByteArrayInputStream(code.getBytes("UTF-8")));
        return typParser.start();
    }

    private static boolean deleteFile(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    WrapperTest.deleteFile(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }
}

