#include "DataOra.h"

DataOra::DataOra()
{
}

void
DataOra::setData(
        int giorno,
        int mese,
        int anno)
{
    setGiorno(giorno);
    setMese(mese);
    setAnno(anno);
}

int
DataOra::getGiorno() const
{
    return giorno;
}

void
DataOra::setGiorno(
        int value)
{
    giorno = value;
}

int
DataOra::getMese() const
{
    return mese;
}

void
DataOra::setMese(
        int value)
{
    mese = value;
}

int
DataOra::getAnno() const
{
    return anno;
}

void
DataOra::setAnno(
        int value)
{
    anno = value;
}

int
DataOra::getOra() const
{
    return ora;
}

void
DataOra::setOra(
        int value)
{
    ora = value;
}

int
DataOra::getMinuto() const
{
    return minuto;
}

void
DataOra::setMinuto(
        int value)
{
    minuto = value;
}

bool
DataOra::stessoMese(
        const DataOra& right) const
{
    return stessoAnno(right) && mese == right.mese;
}

bool
DataOra::stessoAnno(
        const DataOra& right) const
{
    return anno == right.anno;
}

bool
DataOra::operator==(
        const DataOra& right) const
{
    return anno == right.anno && mese == right.mese && giorno == right.giorno
        && ora == right.ora && minuto == right.minuto;
}

bool
DataOra::operator<(
        const DataOra& right) const
{
    if(anno < right.anno)
        return true;
    
    if(anno == right.anno)
    {
        if(mese < right.mese)
            return true;
        
        if(mese == right.mese)
        {
            if(giorno < right.giorno)
                return true;
            
            if(giorno == right.giorno)
            {
                if(ora < right.ora)
                    return true;
                
                if(ora == right.ora)
                {
                    if(minuto < right.minuto)
                        return true;
                }
            }
        }
    }
    
    return false;
}

bool
DataOra::operator<=(
        const DataOra& right) const
{
    return *this < right || *this == right;
}

bool
DataOra::operator>(
        const DataOra& right) const
{
    return !(*this <= right);
}

bool
DataOra::operator>=(
        const DataOra& right) const
{
    return !(*this < right);
}
