#include "McRonalds.h"

#include <cassert>

int McRonalds::prossimoCodice = 1;

McRonalds::McRonalds()
{
}

McRonalds::~McRonalds()
{
}

vector<Ristorante> &
McRonalds::getRistoranti()
{
    return ristoranti;
}

const vector<Ristorante> &
McRonalds::getRistoranti() const
{
    return ristoranti;
}

vector<Pietanza> &
McRonalds::getPietanze()
{
    return pietanze;
}

const vector<Pietanza> &
McRonalds::getPietanze() const
{
    return pietanze;
}

int
McRonalds::registraRistorante(
        const string &nomeRistorante)
{
    assert(indiceRistorante(nomeRistorante) != -1);
    
    ristoranti.push_back(Ristorante(prossimoCodice++, nomeRistorante));
    
    return ristoranti.size() - 1;
}

void 
McRonalds::registraScontrini(
        int codiceRistorante, 
        const vector<Scontrino> &scontrini)
{
    int i = indiceRistorante(codiceRistorante);
    
    assert(i != -1);
    
    for(unsigned j = 0; j < scontrini.size(); j++)
        ristoranti[i].getScontrini().push_back(scontrini[j]);
}

int
McRonalds::indiceRistorante(
        int codice) const
{
    for(unsigned i = 0; i < ristoranti.size(); i++)
        if(ristoranti[i].getCodice() == codice)
            return i;
    
    return -1;
}

int
McRonalds::indiceRistorante(
        const string &nome) const
{
    for(unsigned i = 0; i < ristoranti.size(); i++)
        if(ristoranti[i].getNome() == nome)
            return i;
    
    return -1;
}

int
McRonalds::calorieMedie(
        const string &nomeRistorante,
        const DataOra &mese) const
{
    int i = indiceRistorante(nomeRistorante);
    
    assert(i != -1);
    
    return ristoranti[i].calorieMedie(mese);
}

Pietanza
McRonalds::pietanzaPiuVenduta(
        const string &nomeRistorante,
        const DataOra &anno) const
{
    int i = indiceRistorante(nomeRistorante);
    
    assert(i != -1);
    
    return ristoranti[i].pietanzaPiuVenduta(anno, pietanze);
}
