#ifndef MCRONALDS_H_
#define MCRONALDS_H_

#include "Ristorante.h"

class McRonalds
{
public:
	McRonalds();
	virtual ~McRonalds();
	
	vector<Ristorante> &getRistoranti();
	const vector<Ristorante> &getRistoranti() const;
	
	vector<Pietanza> &getPietanze();
	const vector<Pietanza> &getPietanze() const;
	
	// Ogni ristorante, quando si iscrive al sistema, indica l'indirizzo completo (assumiamo sia il nome)
	// e riceve un codice identificativo.
	int registraRistorante(const string &nomeRistorante);
	
	// Una volta registrato, un ristorante deve comunicare mensilmente quante e quali pietanze
	// sono state consumate (gli scontrini emessi).
	void registraScontrini(int codiceRistorante, const vector<Scontrino> &scontrini);
	
    int indiceRistorante(int codice) const;
    int indiceRistorante(const string &nome) const;
	
	// b.1
	int calorieMedie(const string &nomeRistorante, const DataOra &mese) const;
	
	// b.2
	Pietanza pietanzaPiuVenduta(const string &nomeRistorante, const DataOra &anno) const;
	
private:
    vector<Ristorante> ristoranti;
    vector<Pietanza> pietanze;
    
    static int prossimoCodice;
};

#endif /*MCRONALDS_H_*/
