#include "Ristorante.h"

Ristorante::Ristorante()
{
}

Ristorante::Ristorante(
        int _codice,
        const string &_nome)
: codice(_codice), nome(_nome)
{
}

Ristorante::~Ristorante()
{
}

int
Ristorante::getCodice() const
{
    return codice;
}

void
Ristorante::setCodice(
        int value)
{
    codice = value;
}

string
Ristorante::getNome() const
{
    return nome;
}

void
Ristorante::setNome(
        const string &value)
{
    nome = value;
}

vector<Scontrino> &
Ristorante::getScontrini()
{
    return scontrini;
}

const vector<Scontrino> &
Ristorante::getScontrini() const
{
    return scontrini;
}

int
Ristorante::calorieMedie(
        const DataOra &mese) const
{
    int calorie = 0;
    int pietanze = 0;
    
    for(unsigned i = 0; i < scontrini.size(); i++)
    {
        if(scontrini[i].getDataOraEmissione().stessoMese(mese))
        {
            calorie += scontrini[i].contaCalorie();
            pietanze += scontrini[i].contaPietanze();
        }
    }
    
    return pietanze != 0 ? calorie / pietanze : -1;
}

Pietanza
Ristorante::pietanzaPiuVenduta(
        const DataOra &anno, 
        const vector<Pietanza> &pietanze) const
{
    Pietanza result;
    int max = 0;
    
    for(unsigned i = 0; i < pietanze.size(); i++)
    {
        int count = 0;
        
        for(unsigned j = 0; j < scontrini.size(); j++)
        {
            if(scontrini[j].getDataOraEmissione().stessoAnno(anno))
                count += scontrini[j].vendute(pietanze[i]);
        }
        
        if(count > max)
        {
            result = pietanze[i];
            max = count;
        }
    }
    
    return result;
}
