#ifndef RISTORANTE_H_
#define RISTORANTE_H_

#include "Scontrino.h"

class Ristorante
{
public:
	Ristorante();
	Ristorante(int codice, const string &nome);
	virtual ~Ristorante();
	
	int getCodice() const;
	void setCodice(int value);
	
	string getNome() const;
	void setNome(const string &value);
	
	vector<Scontrino> &getScontrini();
	const vector<Scontrino> &getScontrini() const;
	
    // b.1: metodo ausiliario
    int calorieMedie(const DataOra &mese) const;
    
    // b.2: metodo ausiliario
    Pietanza pietanzaPiuVenduta(const DataOra &anno, const vector<Pietanza> &pietanze) const;
    
private:
    int codice;
    string nome;
    
    vector<Scontrino> scontrini;
};

#endif /*RISTORANTE_H_*/
