#include "Scontrino.h"

Scontrino::Scontrino()
{
}

Scontrino::~Scontrino()
{
}

DataOra
Scontrino::getDataOraEmissione() const
{
    return dataOraEmissione;
}

void
Scontrino::setDataOraEmissione(
        const DataOra &value)
{
    dataOraEmissione = value;
}

vector<ElementoScontrino> &
Scontrino::getPietanze()
{
    return pietanze;
}

const vector<ElementoScontrino> &
Scontrino::getPietanze() const
{
    return pietanze;
}

int
Scontrino::contaCalorie() const
{
    int result = 0;
    for(unsigned i = 0; i < pietanze.size(); i++)
        result += pietanze[i].getPietanza().getCalorie();
    
    return result;
}

int
Scontrino::contaPietanze() const
{
    int result = 0;
    for(unsigned i = 0; i < pietanze.size(); i++)
        result += pietanze[i].getQuantita();
    
    return result;
}

int
Scontrino::vendute(
        const Pietanza &pietanza) const
{
    int result = 0;
    for(unsigned i = 0; i < pietanze.size(); i++)
        if(pietanze[i].getPietanza() == pietanza)
            result += pietanze[i].getQuantita();
    
    return result;
}
