#ifndef SCONTRINO_H_
#define SCONTRINO_H_

#include "DataOra.h"
#include "ElementoScontrino.h"

#include <vector>

using std::vector;

class Scontrino
{
public:
	Scontrino();
	virtual ~Scontrino();
	
	DataOra getDataOraEmissione() const;
	void setDataOraEmissione(const DataOra &value);
	
	vector<ElementoScontrino> &getPietanze();
	const vector<ElementoScontrino> &getPietanze() const;
	
	// b.1: metodi ausiliari
	int contaCalorie() const;
	int contaPietanze() const;
	
	// b.2: metodo ausiliario
	int vendute(const Pietanza &pietanza) const;
	    
private:
    DataOra dataOraEmissione;
    vector<ElementoScontrino> pietanze;
};

#endif /*SCONTRINO_H_*/
