#ifndef CODAINTPRODOTTOLIMITATO_H_
#define CODAINTPRODOTTOLIMITATO_H_

#include "CodaInt.h"

// Una coda di interi dal prodotto limitato "è una" coda di interi,
// quindi uso l'ereditarietà pubblica!
class CodaIntProdottoLimitato : public CodaInt
{
public:
	CodaIntProdottoLimitato(int maxProd);
	
	// in una coda dal prodotto limitato il prodotto degli interi
	// non deve eccedere maxProd, quindi bisogna ridefinire il
	// metodo per l'inserimento (per quello di rimozione va bene
	// l'implementazione della classe CodaInt).
	void inserisci(int x);
	
private:
    int maxProd;
    
    // calcola il prodotto degli interi presenti nella coda
    int calcolaProdotto() const;
};

#endif /*CODAINTPRODOTTOLIMITATO_H_*/
