#include "FIA.h"

FIA::FIA()
{
}

list<string> &
FIA::getPiloti()
{
    return piloti;
}

list<GranPremio> &
FIA::getGranPremi()
{
    return granPremi;
}

const list<string> &
FIA::getPiloti() const
{
    return piloti;
}

const list<GranPremio> &
FIA::getGranPremi() const
{
    return granPremi;
}

string 
FIA::determinaVincitore(
        const GranPremio & gp) const
{
    // inizializza il vincitore al primo pilota
    list<string>::const_iterator it = piloti.begin();
    string vincitore = *it;
    
    // calcola il tempo finale del vincitore (corrente)
    Time tempoVincitore = gp.calcolaTempoFinale(*it);
    it++;
    
    // per ogni pilota
    for(; it != piloti.end(); it++)
    {
        // calcola il suo tempo finale
        Time tempo = gp.calcolaTempoFinale(*it);
        
        // se il tempo è inferiore a quello del vincitore (corrente)
        if(tempo < tempoVincitore)
        {
            // abbiamo un nuovo vincitore
            vincitore = *it;
            tempoVincitore = tempo;
        }
    }
    
    return vincitore;
}

string 
FIA::determinaPilotaGiroRecord(
        const GranPremio & gp) const
{
    // visto che bisogna accedere a molte strutture di GranPremio,
    // meglio implementare il metodo in quella classe
    return gp.pilotaGiroRecord();
}
