#include "GranPremio.h"

GranPremio::GranPremio()
{
}

Data
GranPremio::getData() const
{
    return data;
}

Circuito
GranPremio::getCircuito() const
{
    return circuito;
}

void
GranPremio::setCircuito(
        const Circuito & value)
{
    circuito = value;
}

void
GranPremio::setData(
        Data value)
{
    data = value;
}

list<Giro> &
GranPremio::getGiriProveLibere()
{
    return giriProveLibere;
}

list<Giro> &
GranPremio::getGiriProveUfficiali()
{
    return giriProveUfficiali;
}

list<Giro> &
GranPremio::getGiriWarmUp()
{
    return giriWarmUp;
}

list<Giro> &
GranPremio::getGiriGara()
{
    return giriGara;
}

const list<Giro> &
GranPremio::getGiriProveLibere() const
{
    return giriProveLibere;
}

const list<Giro> &
GranPremio::getGiriProveUfficiali() const
{
    return giriProveUfficiali;
}

const list<Giro> &
GranPremio::getGiriWarmUp() const
{
    return giriWarmUp;
}

const list<Giro> &
GranPremio::getGiriGara() const
{
    return giriGara;
}

Time
GranPremio::calcolaTempoFinale(
        string pilota) const
{
    // inizializza il tempo a ZERO
    Time tempo;
    
    // per ogni giro del GP
    for(list<Giro>::const_iterator it = giriGara.begin(); 
        it != giriGara.end(); it++)
        // se il giro è del pilota
        if(it->getVettura().getPilota() == pilota)
            // aggiungi il tempo del giro al tempo totale del pilota
            tempo += it->getTempo();
    
    return tempo;
}

string
GranPremio::pilotaGiroRecord() const
{
    // inizializza il giro record al primo giro del GP
    list<Giro>::const_iterator it = giriGara.begin();
    list<Giro>::const_iterator record = it;
    it++;
    
    // per ogni giro del GP
    for(; it != giriGara.end(); it++)
        // se il tempo è inferiore
        if(it->getTempo() < record->getTempo())
            // abbiamo un nuovo record
            record = it;
    
    // restituisci il pilota che ha effettuato il miglior giro
    return record->getVettura().getPilota();
}
