#ifndef GRANPREMIO_H_
#define GRANPREMIO_H_

#include <list>

#include "Data.h"
#include "Giro.h"
#include "Circuito.h"

using namespace std;

class GranPremio
{
public:
	GranPremio();
	
	Data getData() const;
	void setData(Data value);
	
	Circuito getCircuito() const;
	void setCircuito(const Circuito & value);
	
    list<Giro> & getGiriProveLibere();
    list<Giro> & getGiriProveUfficiali();
    list<Giro> & getGiriWarmUp();
    list<Giro> & getGiriGara();
    
    const list<Giro> & getGiriProveLibere() const;
    const list<Giro> & getGiriProveUfficiali() const;
    const list<Giro> & getGiriWarmUp() const;
    const list<Giro> & getGiriGara() const;
    
    // Determina il tempo finale del pilota (la somma di tutti i suoi giri)
    Time calcolaTempoFinale(string pilota) const;
    
    // Determina il pilota che ha effettuato il miglior giro in gara
    string pilotaGiroRecord() const;
    
private:
    Data data;
    Circuito circuito;
    list<Giro> giriProveLibere;
    list<Giro> giriProveUfficiali;
    list<Giro> giriWarmUp;
    list<Giro> giriGara;
};

#endif /*GRANPREMIO_H_*/
