#include "Time.h"

ostream &
operator<<(
        ostream & out,
        const Time & time)
{
    int mill = time.millisecondi % 1000;
    int sec = time.millisecondi / 1000 % 60;
    int min = time.millisecondi / 60000 % 60;
    int ore = time.millisecondi / 3600000;
    
    return out << ore << "h " << min << "' " << sec << "." << mill << "\"";   
}

Time::Time()
: millisecondi(0)
{
}

bool
Time::operator<(
        const Time & right) const
{
    return millisecondi < right.millisecondi;
}

Time &
Time::operator+=(
        const Time & right)
{
    millisecondi += right.millisecondi;
    return *this;
}
