#include "Enoteca.h"

bool Enoteca::aggiungiBottiglia(BottigliaDiVino b)
{
    bool modificato = false;
    for(list<BottigliaDiVino>::iterator bott = vini.begin(); bott != vini.end(); bott++)
    {
        if((*bott) == b)
        {
            (*bott).setPrezzo(b.getPrezzo());
            modificato = true;
        }
    }
    vini.push_back(b);
    return modificato;
}

int Enoteca::annataPiuIngombrante()
{
    int numBot = 0;
    int annata = -1;

    for(list<BottigliaDiVino>::iterator bott1 = vini.begin(); bott1 != vini.end(); bott1++)
    {
        int annataTemp = (*bott1).getAnnata();
        int numBotTemp = 0;
        for(list<BottigliaDiVino>::iterator bott2 = vini.begin(); bott2 != vini.end(); bott2++)
            if((*bott2).getAnnata() == annataTemp)
                numBot++;

        if(numBotTemp > numBot)
        {
            numBot = numBotTemp;
            annata = annataTemp;
        }
        else if(numBotTemp == numBot && annataTemp < annata)
            annata = annataTemp;
    }

    return annata;
}

int Enoteca::valorePiuCostose(int annata)
{
    int maxPrezzoInAnnata = -1;

    for(list<BottigliaDiVino>::iterator bott = vini.begin(); bott != vini.end(); bott++)
        if((*bott).getAnnata() == annata && (*bott).getPrezzo()
                > maxPrezzoInAnnata)
            maxPrezzoInAnnata = (*bott).getPrezzo();

    int value = 0;

    for(list<BottigliaDiVino>::iterator bott = vini.begin(); bott != vini.end(); bott++)
        if((*bott).getAnnata() == annata && (*bott).getPrezzo()
                == maxPrezzoInAnnata)
            value += (*bott).getPrezzo();

    return (maxPrezzoInAnnata >= 0) ? value : -1;
}

list<Vitigno> Enoteca::vitigniAlmenoDueProduttori()
{
    list<Vitigno> vitigniDueProd;
    for(list<BottigliaDiVino>::iterator bot1 = vini.begin(); bot1 != vini.end(); bot1++)
    {
        list<BottigliaDiVino>::iterator bot2 = bot1;
        for(bot2++; bot2 != vini.end(); bot2++)
            if((*bot1).getNome() == (*bot2).getNome() && (*bot1).getProduttore() != (*bot2).getProduttore())
            {
                bool ePresente = false;
                for(list<Vitigno>::iterator vit = vitigniDueProd.begin(); !ePresente && vit != vitigniDueProd.end(); vit++)
                    if((*bot1).getNome() == (*vit))
                        ePresente = true;
                if(!ePresente)
                    vitigniDueProd.push_back((*bot1).getNome());
            }

    }
    return vitigniDueProd;
}
