#ifndef FRUTTIVENDOLO_H
#define FRUTTIVENDOLO_H

#include "BottigliaDiVino.h"
#include <cstdlib>
#include <iostream>
#include <list>
using namespace std;

class Enoteca
{

    private:
        list<BottigliaDiVino> vini;

    public:

        /**
         * Il metodo inserisce una bottiglia di vino nell'enoteca,
         * in particolare, quando una nuova bottiglia viene inserita
         * -Nota: l'inserimento (push_back) va sempre fatto-
         * se la bottiglia e' gia' presente in cantina
         * ma con prezzo differente, viene
         * aggiornato il prezzo di tutte le bottiglie
         * uguali (secondo l'operatore== della classe BottigliaDiVino)
         * presenti in cantina e il metodo restituisce true
         *
         * Altrimenti, se non vi e' stato aggiornamento di prezzo
         * il metodo restituisce false
         */
        bool aggiungiBottiglia(BottigliaDiVino b);

        /**
         * Restituisce l'annata per la quale in cantina
         * e' presente il maggior numero di bottiglie
         *
         * In caso vi sia piu' di una annata che ha questa caratteristica
         * il metodo restituisce quella piu' vecchia
         *
         * Se la cantina e' vuota il metodo restituisce -1
         */
        int annataPiuIngombrante();

        /**
         * Fissata una annata, il metodo restituisce il
         * valore complessivo totale (calcolato come somma dei prezzi)
         * di tutti e soli i vini piu costosi di quella annata
         *
         * Se non vi sono vini in quella annata il metodo
         * restituisce -1
         */
        int valorePiuCostose(int annata);

        /**
         * Restituisce la lista dei vitigni per i quali
         * in cantina sono presenti bottiglie di almeno
         * due produttori
         */
        list<Vitigno> vitigniAlmenoDueProduttori();

        inline list<BottigliaDiVino>& getContent();
};

list<BottigliaDiVino>& Enoteca::getContent()
{
    return vini;
}

#endif
