#include "FifaWorldCup2010.h"

bool FifaWorldCup2010::aggiungiPartita(Partita p)
{
    if(p.getSquadra1() == p.getSquadra2())
        return false;

    for(list<Partita>::iterator pp = partiteDisputate.begin(); pp
            != partiteDisputate.end(); pp++)
    {
        if(pp->getData() == p.getData() && (pp->getSquadra1()
                == p.getSquadra1() || pp->getSquadra2()
                == p.getSquadra1() || pp->getSquadra1()
                == p.getSquadra2() || pp->getSquadra2()
                == p.getSquadra2()))
            return false;
    }
    partiteDisputate.push_back(p);
    return true;
}

int FifaWorldCup2010::maxGoalFatti()
{
    int maxGoal = 0;
    for(list<Partita>::iterator p = partiteDisputate.begin(); p
            != partiteDisputate.end(); p++)
    {
        string squadra = p->getSquadra1();
        int numGoalTemp = p->getGoalSquadra1();
        for(int i = 1; i <= 2; i++)
        {
            if(i == 2)
            {
                squadra = p->getSquadra2();
                numGoalTemp = p->getGoalSquadra2();
            }
            list<Partita>::iterator pp = p;
            pp++;
            for(; pp != partiteDisputate.end(); pp++)
            {
                if(pp->getSquadra1() == squadra)
                    numGoalTemp += pp->getGoalSquadra1();
                else if(pp->getSquadra2() == squadra)
                    numGoalTemp += pp->getGoalSquadra2();
            }
            if(numGoalTemp > maxGoal)
                maxGoal = numGoalTemp;
        }
    }
    return maxGoal;
}

int FifaWorldCup2010::calcolaPunti(string s)
{
    int punti = 0;
    for(list<Partita>::iterator p = partiteDisputate.begin(); p
            != partiteDisputate.end(); p++)
    {
        if(p->getSquadra1() == s)
        {
            if(p->getGoalSquadra1() > p->getGoalSquadra2())
                punti += 3;
            else if(p->getGoalSquadra1() == p->getGoalSquadra2())
                punti++;
        }
        else if(p->getSquadra2() == s)
        {
            if(p->getGoalSquadra2() > p->getGoalSquadra1())
                punti += 3;
            else if(p->getGoalSquadra1() == p->getGoalSquadra2())
                punti++;
        }
    }
    return punti;
}

int FifaWorldCup2010::puntiVincitore()
{
    int puntiVinc = 0;
    list<Partita>::iterator p = partiteDisputate.begin();
    for(; p != partiteDisputate.end(); p++)
    {
        int punti = calcolaPunti(p->getSquadra1());
        if(punti > puntiVinc)
            puntiVinc = punti;
        punti = calcolaPunti(p->getSquadra2());
        if(punti > puntiVinc)
            puntiVinc = punti;
    }
    return puntiVinc;
}

bool FifaWorldCup2010::verificaUnVincitore()
{
    int puntiVinc = puntiVincitore();
    bool trovatoPrimoVincitore = false;
    string primoVincitore;
    for(list<Partita>::iterator p = partiteDisputate.begin(); p
            != partiteDisputate.end(); p++)
    {
        string squadra = p->getSquadra1();
        for(int i = 1; i <= 2; i++)
        {
            if(i == 2)
                squadra = p->getSquadra2();
            int punti = calcolaPunti(squadra);
            if(punti == puntiVinc)
            {
                if(!trovatoPrimoVincitore)
                {
                    trovatoPrimoVincitore = true;
                    primoVincitore = squadra;
                }
                else if(squadra != primoVincitore)
                    return false;
            }
        }
    }
    return true;
}

