#ifndef FIFAWORLDCUP2010_H
#define FIFAWORLDCUP2010_H

#include "Partita.h"
#include <cstdlib>
#include <iostream>
#include <list>
using namespace std;

/*
 * La classe FifaWorldCup2010 sar utilizzata dalla FIFA
 * per gestire le statistiche sulle partite disputate
 * durante la coppa del mondo 2010 in Sud Africa
 * dagli ottavi di finale in poi, ovvero
 * al termine della fase eliminatoria (a gironi).
 *
 * Le partite verranno inserite nel sistema
 * man mano che esse vengono disputate.
 *
 * Tenere presente che le statistiche possono essere richieste
 * prima della fine della competizione ovvero,
 * i metodi della classe devono essere corretti anche quando
 * non sono state disputate/inserite tutte le partite.
 * */
class FifaWorldCup2010
{
    private:
       list<Partita> partiteDisputate;

    public:

        /*
         * Il seguente metodo aggiunge (push_back) una data partita p
         * alla lista delle partite disputate se e solo se entrambe le seguenti
         * condizioni sono soddisfatte:
         *
         * - le due squadre di p sono diverse;
         * 
         * - non esiste gia', fra quelle disputate, un'altra partita avente
         *   la stessa data di p e che nel contempo coivolga
         *   una o entrambe le squadre di p
         *
         * Nei casi in cui e' possibile fare l'inserimento,
         * il metodo restituisce true, altrimenti restituisce false.
         * */
        bool aggiungiPartita(Partita p);



        /*
         * Il seguente metodo restituisce il numero massimo di goal realizzati da
         * una singola squadra nel corso del mondiale.
         *
         * Ad esempio, se l'Italia ha segnato un totale di 18 goal, la Francia 15,
         * la Germania 18 e le altre squadre 0, il metodo deve restituire 18.
         *
         * Se non vi sono partite disputate, il metodo restituisce 0.
         * */
        int maxGoalFatti();


        /*
         * Il seguente metodo restituisce i punti totalizzati
         * da una data squadra nelle partite che ha disputato.
         *
         * Se la squadra non ha disputato alcuna partita,
         * il metodo restituisce 0.
         *
         * Si tenga presente che una squadra prende 3 punti se vince,
         * 1 punto se pareggia, 0 punti se prede.
         * */
        int calcolaPunti(string s);


        /*
         * Il metodo restituisce il numero massimo di punti realizzati da una singola squadra.
         *
         * Ad esempio, se l'Italia ha totalizzato 3 punti, la Francia 1,
         * la Germania 3, il Brasile 1 e le altre squadre 0, il metodo deve 
         * restituire 3.

         * Se non vi sono partite disputate, il metodo restituisce 0.
         * */
        int puntiVincitore();


        /*
         * Il metodo restituisce true se e solo se esiste un solo vincitore,
         * ovvero una sola squadra che ha totalizzato piu' punti di tutte le altre.
         *
         * Ad esempio, se l'Italia ha totalizzato 3 punti, la Francia 1,
         * la Germania 3, il Brasile 1 e le altre squadre 0, il metodo deve 
         * restituire false perch ci sono due squadre a 3 punti (e 3  il massimo
         * numero di punti realizzati da una singola squadra).
         *
         * Se non vi sono partite disputate, il metodo restituisce false.
         * */
        bool verificaUnVincitore();

        inline list<Partita>& getContent();
};

list<Partita>& FifaWorldCup2010::getContent()
{
    return partiteDisputate;
}

#endif
