#ifndef CARICO_DI_FRUTTA_H_
#define CARICO_DI_FRUTTA_H_

#include<string>
using namespace std;

enum TipoFrutto {None = 0, PeraAbate, MelaMelinda, AnanasDelMonte, BananaCiquita};

class CaricoDiFrutta
{
private:
	TipoFrutto frutto;
	int chilogrammi; //interi > 0
	int costoAlKg; //interi > 0
	int dataScadenza; //interi >= 0

public:
	CaricoDiFrutta(TipoFrutto=None, int=0, int=0, int=0);

	/* Due "carichi" sono uguali se tutti i campi sono uguali */
	bool operator==(const CaricoDiFrutta&) const;

	TipoFrutto getFrutto() const;
    void setFrutto(TipoFrutto frutto);

    int getChilogrammi() const;
    void setChilogrammi(int chilogrammi);

    int getCostoAlKg() const;
    void setCostoAlKg(int costoAlKg);

    int getDataScadenza() const;
    void setDataScadenza(int dataScadenza);
};

#endif
