#include "Fruttivendolo.h"

/**
 * Se nel magazzino c'e' gia' un "carico di frutta"
 * che differisce (da quello che si vorrebbe inserire)
 * al piu' della sola voce "chilogrammi"
 * aggiorna il "vecchio carico"
 * incrementando la voce "chilogrammi"
 * della quantita' del "nuovo carico"
 * In tal caso restituisce false.
 *
 *  Altrimenti inserisce il "nuovo carico" (push_back)
 *  e restituisce true
 */
bool Fruttivendolo::aggiungiCarico(CaricoDiFrutta c)
{
    for(list<CaricoDiFrutta>::iterator it = magazzino.begin(); it != magazzino.end(); it++)
    {
        if((*it).getCostoAlKg() == c.getCostoAlKg() &&
           (*it).getDataScadenza() == c.getDataScadenza() &&
           (*it).getFrutto() == c.getFrutto())
        {
            int old_KGs = (*it).getChilogrammi();
            (*it).setChilogrammi(old_KGs + c.getChilogrammi());
            return false;
        }
    }
    magazzino.push_back(c);
    return true;
}

/**
 *  Restituisce la lista dei carichi piu' costosi,
 *  nello stesso ordine in cui sono presenti nel magazzino.
 *  Il costo del carico dipende dal
 *  "costo al chilogrammo" e dal numero di "chilogrammi".
 */
list<CaricoDiFrutta> Fruttivendolo::carichiPiuCostosi()
{
    int costoCaricoPiuCostoso = 0;
    list<CaricoDiFrutta> carichiCostosi;

    for(list<CaricoDiFrutta>::iterator it = magazzino.begin(); it != magazzino.end(); it++)
    {
        int costoCaricoCorrente = (*it).getCostoAlKg() * (*it).getChilogrammi();

        if(costoCaricoCorrente > costoCaricoPiuCostoso)
        {
            carichiCostosi.clear();
            carichiCostosi.push_back(*it);
            costoCaricoPiuCostoso = costoCaricoCorrente;
        }
        else if (costoCaricoCorrente == costoCaricoPiuCostoso)
        {
            carichiCostosi.push_back((*it));
        }
    }
    return carichiCostosi;
}

/**
 * Restituisce la data di scadenza piu' prossima,
 * rispetto alla "data attuale"
 *
 * Un frutto e' considerato scaduto se la sua "data di scadenza"
 * e' strettamente precedente alla "data attuale".
 *
 * Un frutto e' in scadenza se la sua "data di scadenza" e'
 * uguale o successiva alla "data attuale"
 *
 * Se il magazzino e' vuoto restituisce -1
 *
 * Se la merce e' tutta scaduta restituisce -2
 */
int Fruttivendolo::prossimaScadenza(int dataAttuale)
{
    if(magazzino.empty())
        return -1;

    int dataProssima;
    bool esisteDataProssima = false;

    for(list<CaricoDiFrutta>::iterator it = magazzino.begin(); it != magazzino.end(); it++)
    {
        if(!esisteDataProssima)
        {
            if((*it).getDataScadenza() >= dataAttuale)
            {
                dataProssima = (*it).getDataScadenza();
                esisteDataProssima = true;
            }
        }
        else
        {
            if((*it).getDataScadenza() < dataProssima && (*it).getDataScadenza() >= dataAttuale)
                dataProssima = (*it).getDataScadenza();
        }
    }

    if(!esisteDataProssima)
        return -2;

    return dataProssima;
}

/**
 * Restituisce la quantita' totale (in chilogrammi)
 * di tutta la frutta nel magazzino non ancora scaduta
 * ma piu' prossima a scadere
 *
 * Un frutto e' considerato scaduto se la sua "data di scadenza"
 * e' strettamente precedente alla "data attuale".
 *
 * Un frutto e' in scadenza se la sua "data di scadenza" e'
 * uguale o successiva alla "data attuale"
 */
int Fruttivendolo::quantitaMerceInScadenza(int dataAttuale)
{
    int kg_in_scadenza = 0;

    int minData = prossimaScadenza(dataAttuale);

    if(minData >= 0)
    {
        for(list<CaricoDiFrutta>::iterator it = magazzino.begin(); it != magazzino.end(); it++)
        {
            if((*it).getDataScadenza() == minData)
                kg_in_scadenza += (*it).getChilogrammi();
        }
    }

    return kg_in_scadenza;
}
