#ifndef FRUTTIVENDOLO_H
#define FRUTTIVENDOLO_H

#include "CaricoDiFrutta.h"
#include <cstdlib>
#include <iostream>
#include <list>
using namespace std;

class Fruttivendolo
{

private:
	list<CaricoDiFrutta> magazzino;

public:

    /**
     * Se nel magazzino c'e' gia' un "carico di frutta"
     * che differisce (da quello che si vorrebbe inserire)
     * al piu' della sola voce "chilogrammi"
     * aggiorna il "vecchio carico"
     * incrementando la voce "chilogrammi"
     * della quantita' del "nuovo carico"
     * In tal caso restituisce false.
     *
     *  Altrimenti inserisce il "nuovo carico" (push_back)
     *  e restituisce true
     */
    bool aggiungiCarico(CaricoDiFrutta c);


    /**
     *  Restituisce la lista dei carichi piu' costosi,
     *  nello stesso ordine in cui sono presenti nel magazzino.
     *  Il costo del carico dipende dal
     *  "costo al chilogrammo" e dal numero di "chilogrammi".
     */
    list<CaricoDiFrutta> carichiPiuCostosi();


    /**
     * Restituisce la data di scadenza piu' prossima,
     * rispetto alla "data attuale"
     *
     * Un frutto e' considerato scaduto se la sua "data di scadenza"
     * e' strettamente precedente alla "data attuale".
     *
     * Un frutto e' in scadenza se la sua "data di scadenza" e'
     * uguale o successiva alla "data attuale"
     *
     * Se il magazzino e' vuoto restituisce -1
     *
     * Se la merce e' tutta scaduta restituisce -2
     */
    int prossimaScadenza(int dataAttuale);


    /**
     * Restituisce la quantita' totale (in chilogrammi)
     * di tutta la frutta nel magazzino non ancora scaduta
     * ma piu' prossima a scadere
     *
     * Un frutto e' considerato scaduto se la sua "data di scadenza"
     * e' strettamente precedente alla "data attuale".
     *
     * Un frutto e' in scadenza se la sua "data di scadenza" e'
     * uguale o successiva alla "data attuale"
     */
    int quantitaMerceInScadenza(int dataAttuale);


	inline list<CaricoDiFrutta>& getContent();
};

list<CaricoDiFrutta>& Fruttivendolo::getContent()
{
    return magazzino;
}

#endif
