#include "ArchivioTesi12345.h"


/* - - - - METODI DA IMPLEMENTARE - - - - */


bool ArchivioTesi12345::caricaTesi(Tesi t)
{
	for(unsigned i = 0; i < archivio.size(); i++)
		if(archivio[i] == t)
			return false;
	archivio.push_back(t);
	return true;
}

bool ArchivioTesi12345::esisteAutoreRelatore() const
{
	for(unsigned i = 0; i < archivio.size(); i++)
		for(unsigned j = 0; j < archivio.size(); j++)
			if(archivio[i].getAutore() == archivio[j].getRelatore())
				return true;
	return false;
}

int ArchivioTesi12345::numeroRelatori() const
{
	vector<string> relatori;
	for(unsigned i = 0; i < archivio.size(); i++)
	{
		bool ePresente = false;
		string relatore = archivio[i].getRelatore();
		for(unsigned j = 0; j < relatori.size() && !ePresente; j++)
			if(relatori[j] == relatore)
				ePresente = true;
		if(!ePresente)
			relatori.push_back(relatore);
	}
	return relatori.size();
}


int ArchivioTesi12345::dammiMediaTesiPerRelatore() const
{
	return archivio.empty() ? 0 : archivio.size() / numeroRelatori();
}


int ArchivioTesi12345::dammiAnnoMigliorePiuRecente() const
{
	int annoMigliore = 1900;
	int nTesiMax = 0;
	for(unsigned i = 0; i < archivio.size(); i++)
	{
		int anno = archivio[i].getAnno();
		int nTesi = 0;
		for(unsigned j = 0; j < archivio.size(); j++)
			if(archivio[j].getAnno() == anno)
				nTesi++;
		if(nTesi > nTesiMax || (nTesi == nTesiMax && anno > annoMigliore))
		{
			annoMigliore = anno;
			nTesiMax = nTesi;
		}
	}
	return annoMigliore;
}



/* - - - - METODI DA NON MODIFICARE - - - - */

ArchivioTesi12345::ArchivioTesi12345() {}

vector<Tesi>& ArchivioTesi12345::getContent()
{
	return archivio;
}

AbstractTest* getInstance()
{
	return new ArchivioTesi12345();
}
