#include "Azienda.h"

#include<algorithm>

Azienda::Azienda()
{
}

const list<Cliente>&
Azienda::getClienti() const
{
    return clienti;
}

list<Cliente>&
Azienda::getClienti()
{
    return clienti;
}

const list<Polizza>&
Azienda::getPolizze() const
{
    return polizze;
}

list<Polizza>&
Azienda::getPolizze()
{
    return polizze;
}

// esercizio b.1
Cliente
Azienda::clienteConPiuPolizzeFinoAl(
        const Data& data) const
{
    int max = 0;
    Cliente maxCliente; 
    
    for(list<Cliente>::const_iterator itC = clienti.begin();
        itC != clienti.end(); itC++)
    {
        int count = 0;
        for(list<Polizza>::const_iterator itP = polizze.begin();
            itP != polizze.end(); itP++)
        {
            if(itP->getDataStipula() < data && itP->hasSottoscrittore(*itC))
                count++;            
        }
        
        if(count > max)
        {
            max = count;
            maxCliente = *itC;
        }
    }
    
    return maxCliente;
}

// esercizio b.2
Polizza
Azienda::polizzaConPremioMaggioreIn(
        const Data& data) const
{
    double max = .0;
    Polizza maxPolizza;
    
    for(list<Polizza>::const_iterator it = polizze.begin(); 
        it != polizze.end(); it++)
        if(it->isAttiva(data) && it->getPremio() > max)
        {
            max = it->getPremio();
            maxPolizza = *it;
        }
    
    return maxPolizza;
}

// esercizio c.1
list<Cliente>
Azienda::clientiConPolizzeMaggiore1000() const
{
    list<Cliente> result;
    
    for(list<Polizza>::const_iterator itP = polizze.begin();
        itP != polizze.end(); itP++)
    {
        if(itP->getPremio() > 1000)
        {
            for(list<Cliente>::const_iterator itC = itP->getSottoscrittori().begin();
                itC != itP->getSottoscrittori().end(); itC++)
            {
                // aggiungi il cliente se non è stato già aggiunto
                if(find(result.begin(), result.end(), *itC) == result.end())
                    result.push_back(*itC);
            }
        }
    }

    return result;
}

// esercizio c.1
list<Cliente>
Azienda::clientiConPolizzeMaggiore1000_versione2() const
{
    list<Cliente> result;
    
    for(list<Cliente>::const_iterator itC = clienti.begin();
        itC != clienti.end(); itC++)
    {
        bool trovato = false;
        
        for(list<Polizza>::const_iterator itP = polizze.begin();
            itP != polizze.end() && ! trovato; itP++)
        {
            if(itP->hasSottoscrittore(*itC) && itP->getPremio() > 1000)
            {
                trovato = true;
                result.push_back(*itC);
            }
        }
    }

    return result;
}

// esercizio c.2
list<Cliente> 
Azienda::clientiInsolventi(
        const Data& data) const
{
    list<Cliente> result;
    
    for(list<Polizza>::const_iterator itP = polizze.begin();
        itP != polizze.end(); itP++)
    {
        if(itP->getDataStipula() <= data && ! itP->isPagata())
        {
            for(list<Cliente>::const_iterator itC = itP->getSottoscrittori().begin();
                itC != itP->getSottoscrittori().end(); itC++)
            {
                // aggiungi il cliente se non è stato già aggiunto
                if(find(result.begin(), result.end(), *itC) == result.end())
                    result.push_back(*itC);
            }
        }
    }
    
    return result;
}

// esercizio c.2
list<Cliente>
Azienda::clientiInsolventi_versione2(
        const Data& data) const
{
    list<Cliente> result;
    
    for(list<Cliente>::const_iterator itC = clienti.begin();
        itC != clienti.end(); itC++)
    {
        bool trovato = false;
        
        for(list<Polizza>::const_iterator itP = polizze.begin();
            itP != polizze.end() && ! trovato; itP++)
        {
            if(itP->hasSottoscrittore(*itC) && itP->getDataStipula() <= data 
                    && ! itP->isPagata())
            {
                trovato = true;
                result.push_back(*itC);
            }
        }
    }

    return result;
}
