#ifndef CLIENTE_H_
#define CLIENTE_H_

#include <string>

#include "Data.h"

using namespace std;

class Cliente
{
public:
	Cliente();

    string getCodiceFiscale() const;
    void setCodiceFiscale(const string& value);
    
    string getNome() const;
    void setNome(const string& value);
    
    string getCognome() const;
    void setCognome(const string& value);
    
    string getIndirizzo() const;
    void setIndirizzo(const string& value);
    
    const Data& getDataNascita() const;
    void setDataNascita(const Data& value);
    
    string getCittaResidenza() const;
    void setCittaResidenza(const string& value);
    
    bool operator==(const Cliente& right) const;
    
    // non occorre ridefinire l'operatore di assegnamento di default perché
    // non c'è uso di memoria dinamica
    
private:
    string codiceFiscale;
    string nome;
    string cognome;
    string indirizzo;
    Data dataNascita;
    string cittaResidenza;
};

#endif /*CLIENTE_H_*/
