#include "Data.h"

Data::Data()
{
}

void
Data::setData(
        int giorno,
        int mese,
        int anno)
{
    setGiorno(giorno);
    setMese(mese);
    setAnno(anno);
}

int
Data::getGiorno() const
{
    return giorno;
}

void
Data::setGiorno(
        int value)
{
    giorno = value;
}

int
Data::getMese() const
{
    return mese;
}

void
Data::setMese(
        int value)
{
    mese = value;
}

int
Data::getAnno() const
{
    return anno;
}

void
Data::setAnno(
        int value)
{
    anno = value;
}

bool
Data::operator==(
        const Data& right) const
{
    return anno == right.anno && mese == right.mese && giorno == right.giorno;
}

bool
Data::operator<(
        const Data& right) const
{
    if(anno < right.anno)
        return true;
    
    if(anno == right.anno)
    {
        if(mese < right.mese)
            return true;
        
        if(mese == right.mese && giorno == right.giorno)
            return true;
    }
    
    return false;
}

bool
Data::operator<=(
        const Data& right) const
{
    return *this < right || *this == right;
}

bool
Data::operator>(
        const Data& right) const
{
    return !(*this <= right);
}

bool
Data::operator>=(
        const Data& right) const
{
    return !(*this < right);
}
