#include "Polizza.h"

Polizza::Polizza()
{
}

Polizza::Tipo
Polizza::getTipo() const
{
    return tipo;
}

void
Polizza::setTipo(
        Tipo value)
{
    tipo = value;
}

const list<string>&
Polizza::getBeneficiari() const
{
    return beneficiari;
}

list<string>&
Polizza::getBeneficiari()
{
    return beneficiari;
}

const list<Cliente>&
Polizza::getSottoscrittori() const
{
    return sottoscrittori;
}

list<Cliente>&
Polizza::getSottoscrittori()
{
    return sottoscrittori;
}

const list<string>&
Polizza::getProtetti() const
{
    return protetti;
}

list<string>&
Polizza::getProtetti()
{
    return protetti;
}

double 
Polizza::getMassimale() const
{
    return massimale;
}

void 
Polizza::setMassimale(
        double value)
{
    massimale = value;
}

double 
Polizza::getPremio() const
{
    return premio;
}

void 
Polizza::getPremio(
        double value)
{
    premio = value;
}

const Data& 
Polizza::getDataStipula() const
{
    return dataStipula;
}

void 
Polizza::setDataStipula(
        const Data& value)
{
    dataStipula = value;
}

const Data& 
Polizza::getScadenza() const
{
    return scadenza;
}

void 
Polizza::setScadenza(
        const Data& value)
{
    scadenza = value;
}

bool 
Polizza::isPagata() const
{
    return pagata;
}

void 
Polizza::setPagata(
        bool value)
{
    pagata = value;
}

bool
Polizza::hasSottoscrittore(
        const Cliente& cliente) const
{
    for(list<Cliente>::const_iterator it = sottoscrittori.begin();
        it != sottoscrittori.end(); it++)
    {
        if(*it == cliente)
            return true;
    }
    
    return false;
}

bool
Polizza::isAttiva(
        const Data& data) const
{
    return pagata && dataStipula <= data && data <= scadenza;
}

