#ifndef POLIZZA_H_
#define POLIZZA_H_

#include <string>
#include <list>

#include "Cliente.h"
#include "Data.h"

using namespace std;

class Polizza
{
public:
    enum Tipo {AUTO, IMMOBILE, VITA};
    
	Polizza();
	
	Tipo getTipo() const;
	void setTipo(Tipo value);
	
	const list<Cliente>& getSottoscrittori() const;
	list<Cliente>& getSottoscrittori();
	
	const list<string>& getBeneficiari() const;
	list<string>& getBeneficiari();
	
	const list<string>& getProtetti() const;
	list<string>& getProtetti();
	
	double getMassimale() const;
	void setMassimale(double value);
	
	double getPremio() const;
	void getPremio(double value);
	
    const Data& getDataStipula() const;
    void setDataStipula(const Data& value);
    
    const Data& getScadenza() const;
    void setScadenza(const Data& value);
    
	bool isPagata() const;
	void setPagata(bool value);
	
	bool hasSottoscrittore(const Cliente& cliente) const;
	
	// true se la polizza è attiva nella data specificata
	bool isAttiva(const Data& data) const;
	
private:
    Tipo tipo;
    list<Cliente> sottoscrittori;
    list<string> beneficiari;   // persone beneficiarie
    list<string> protetti;      // persone o oggetti protetti
    double massimale;
    double premio;
    Data dataStipula;
    Data scadenza;
    bool pagata;
};

#endif /*POLIZZA_H_*/
